/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.internal.stereo;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.diagram.common.internal.stereo.AdapterImpl;
import org.eclipse.uml2.diagram.common.stereo.StereotypeListener;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PackageStereotypeAdapter
extends AdapterImpl {
    private final StereotypeListener myListener;

    public PackageStereotypeAdapter(StereotypeListener listener) {
        this.myListener = listener;
    }

    @Override
    public void setTarget(Notifier newTarget) {
        if (newTarget == null) {
            for (EObject application : this.getStereotypeApplications(this.getTarget())) {
                this.disconnectFromStereotypeApplication(application);
            }
        }
        if (newTarget != null) {
            for (EObject application : this.getStereotypeApplications(newTarget)) {
                this.connectToStereotypeApplication(application);
            }
        }
        super.setTarget(newTarget);
    }

    private List<EObject> getStereotypeApplications(Object target) {
        if (target instanceof Resource) {
            Package pakkage = this.getPackage((Resource)target);
            Resource resource = (Resource)target;
            LinkedList<EObject> result = new LinkedList<EObject>();
            for (EObject o : resource.getContents()) {
                if (!this.isStereotypeApplication(pakkage, o)) continue;
                result.add(o);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public boolean isForListener(StereotypeListener that) {
        return this.myListener == that;
    }

    @Override
    public void notifyChanged(Notification notification) {
        Object oldValue;
        EObject application;
        Object newValue;
        if (3 == notification.getEventType() && (newValue = notification.getNewValue()) != null && newValue instanceof EObject && this.isStereotypeApplication(application = (EObject)newValue)) {
            this.connectToStereotypeApplication(application);
        }
        if (4 == notification.getEventType() && (oldValue = notification.getOldValue()) != null && oldValue instanceof EObject && this.isStereotypeApplication(application = (EObject)oldValue)) {
            this.disconnectFromStereotypeApplication(application);
        }
    }

    private boolean isStereotypeApplication(EObject application) {
        Package pakkage = this.getPackage((Resource)this.getTarget());
        return this.isStereotypeApplication(pakkage, application);
    }

    private Package getPackage(Resource resource) {
        return (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
    }

    private boolean isStereotypeApplication(Package pakkage, EObject application) {
        EList profiles = pakkage.getAllAppliedProfiles();
        EPackage ePackage = application.eClass().getEPackage();
        return profiles.contains((Object)UMLUtil.getProfile((EPackage)ePackage));
    }

    private void connectToStereotypeApplication(EObject newEObject) {
        newEObject.eAdapters().add((Object)new StereotypeApplicationAdapter(this.myListener));
    }

    private void disconnectFromStereotypeApplication(EObject newEObject) {
        StereotypeApplicationAdapter forListener = null;
        for (Adapter next : newEObject.eAdapters()) {
            if (!(next instanceof StereotypeApplicationAdapter) || !((StereotypeApplicationAdapter)next).isForListener(this.myListener)) continue;
            forListener = (StereotypeApplicationAdapter)next;
            break;
        }
        if (forListener != null) {
            newEObject.eAdapters().remove(forListener);
        }
    }

    private static class StereotypeApplicationAdapter
    extends AdapterImpl {
        private final StereotypeListener myListener;

        public StereotypeApplicationAdapter(StereotypeListener listener) {
            this.myListener = listener;
        }

        public boolean isForListener(StereotypeListener that) {
            return this.myListener == that;
        }

        @Override
        public void notifyChanged(Notification notification) {
            EStructuralFeature feature;
            if (1 == notification.getEventType() && notification.getFeature() instanceof EStructuralFeature && (feature = (EStructuralFeature)notification.getFeature()).getName() != null && feature.getName().startsWith("base_")) {
                Object oldValue;
                EObject application = (EObject)this.getTarget();
                Object newValue = notification.getNewValue();
                if (newValue != null && newValue instanceof Element) {
                    this.myListener.stereotypeApplied((Element)newValue, UMLUtil.getStereotype((EObject)application), application);
                }
                if ((oldValue = notification.getOldValue()) != null) {
                    this.myListener.stereotypeUnapplied((Element)oldValue, UMLUtil.getStereotype((EObject)application));
                }
            }
        }
    }
}

