/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.layered;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.uml2.diagram.common.editparts.PrimaryShapeEditPart;
import org.eclipse.uml2.diagram.common.layered.MultiLayeredContainer;
import org.eclipse.uml2.diagram.common.layered.MultilayeredFigure;
import org.eclipse.uml2.diagram.common.layered.MultilayeredSupport;

public class MultilayeredSupportImpl
implements MultilayeredSupport {
    private final Map<String, IFigure> myLayerToFigure = new HashMap<String, IFigure>();
    private final Map<String, IFigure> myLayerToContentPane = new HashMap<String, IFigure>();
    private MultilayeredSupport myParent;
    private IFigure myParentDefaultContentPane;

    public MultilayeredSupportImpl() {
        this.myParent = null;
        this.myParentDefaultContentPane = null;
    }

    public MultilayeredSupportImpl(GraphicalEditPart parentEditPart) {
        this.setParentFromParentEditPart(parentEditPart);
    }

    public void setParentFromParentEditPart(GraphicalEditPart parentEditPart) {
        IFigure parentFigure = this.getPrimaryFigure(parentEditPart);
        this.myParent = parentFigure instanceof MultilayeredFigure ? ((MultilayeredFigure)parentFigure).getMultilayeredSupport() : null;
        this.myParentDefaultContentPane = parentEditPart.getContentPane();
    }

    private IFigure getPrimaryFigure(GraphicalEditPart editPart) {
        if (editPart instanceof PrimaryShapeEditPart) {
            return ((PrimaryShapeEditPart)editPart).getPrimaryShape();
        }
        return editPart.getFigure();
    }

    @Override
    public void addToLayers(MultiLayeredContainer container) {
        for (Map.Entry<String, IFigure> nextEntry : this.myLayerToFigure.entrySet()) {
            String layerKey = nextEntry.getKey();
            IFigure parent = this.getContentPane(container, layerKey);
            IFigure figure = nextEntry.getValue();
            figure = MultilayeredSupportImpl.getDecorated(figure);
            parent.add(figure);
        }
    }

    @Override
    public void removeFromLayers(MultiLayeredContainer container) {
        for (Map.Entry<String, IFigure> e : this.myLayerToFigure.entrySet()) {
            String layerKey = e.getKey();
            IFigure parent = this.getContentPane(container, layerKey);
            IFigure figure = e.getValue();
            figure = MultilayeredSupportImpl.getDecorated(figure);
            parent.remove(figure);
        }
    }

    @Override
    public IFigure getContentPaneOn(String layerKey) {
        return this.myLayerToContentPane.get(layerKey);
    }

    public void setLayerToFigure(String layerKey, IFigure figure) {
        assert (!this.myLayerToFigure.containsKey(layerKey));
        assert (figure != null);
        this.myLayerToFigure.put(layerKey, figure);
    }

    public void setLayerToContentPane(String layerKey, IFigure contentPane) {
        assert (!this.myLayerToContentPane.containsKey(layerKey));
        assert (contentPane != null);
        this.myLayerToContentPane.put(layerKey, contentPane);
    }

    private IFigure getContentPane(MultiLayeredContainer container, String layerKey) {
        IFigure parent = null;
        if (this.myParent != null) {
            parent = this.myParent.getContentPaneOn(layerKey);
        }
        if (parent == null && "Middle layer".equals(layerKey)) {
            parent = this.myParentDefaultContentPane;
        }
        if (parent == null && (parent = container.getLayerContentPane(layerKey)) == null) {
            throw new IllegalStateException("Unexpected layer key: " + layerKey);
        }
        return parent;
    }

    private static IFigure getDecorated(IFigure figure) {
        if (figure.getParent() instanceof DefaultSizeNodeFigure) {
            figure = figure.getParent();
        }
        if (figure.getParent() instanceof BorderedNodeFigure) {
            figure = figure.getParent();
        }
        return figure;
    }
}

