/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.links;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.uml2.diagram.common.links.PortOperationsExt;
import org.eclipse.uml2.diagram.common.links.ProvidedInterfaceLink;
import org.eclipse.uml2.diagram.common.links.RequiredInterfaceLink;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Usage;

public class ComponentOperationsExt {
    public static List<ProvidedInterfaceLink> realizedInterfaces(Component component, Classifier classifier) {
        return Collections.unmodifiableList(ComponentOperationsExt.realizedInterfaces(component, classifier, true));
    }

    protected static List<ProvidedInterfaceLink> realizedInterfaces(Component component, Classifier classifier, boolean resolve) {
        LinkedList<ProvidedInterfaceLink> realizedInterfaces = new LinkedList<ProvidedInterfaceLink>();
        if (classifier instanceof Interface) {
            realizedInterfaces.add(new ProvidedInterfaceLink(null, (NamedElement)classifier, (Interface)classifier));
        }
        for (Dependency clientDependency : classifier.getClientDependencies()) {
            if (!(clientDependency instanceof InterfaceRealization)) continue;
            Iterator suppliers = resolve ? clientDependency.getSuppliers().iterator() : ((InternalEList)clientDependency.getSuppliers()).basicIterator();
            while (suppliers.hasNext()) {
                NamedElement supplier = (NamedElement)suppliers.next();
                if (!(supplier instanceof Interface)) continue;
                realizedInterfaces.add(new ProvidedInterfaceLink((InterfaceRealization)clientDependency, (NamedElement)classifier, (Interface)supplier));
            }
        }
        return realizedInterfaces;
    }

    protected static Collection<RequiredInterfaceLink> usedInterfaces(Component component, Classifier classifier, boolean resolve) {
        HashSet<RequiredInterfaceLink> usedInterfaces = new HashSet<RequiredInterfaceLink>();
        for (Dependency clientDependency : classifier.getClientDependencies()) {
            if (!(clientDependency instanceof Usage)) continue;
            Iterator suppliers = resolve ? clientDependency.getSuppliers().iterator() : ((InternalEList)clientDependency.getSuppliers()).basicIterator();
            while (suppliers.hasNext()) {
                NamedElement supplier = (NamedElement)suppliers.next();
                if (!(supplier instanceof Interface)) continue;
                usedInterfaces.add(new RequiredInterfaceLink((Usage)clientDependency, (NamedElement)classifier, (Interface)supplier));
            }
        }
        return usedInterfaces;
    }

    public static Collection<RequiredInterfaceLink> getRequireds(Component component) {
        HashSet<RequiredInterfaceLink> requireds = new HashSet<RequiredInterfaceLink>();
        requireds.addAll(ComponentOperationsExt.usedInterfaces(component, (Classifier)component, false));
        for (ComponentRealization realization : component.getRealizations()) {
            for (Classifier realizingClassifier : realization.getRealizingClassifiers()) {
                if (realizingClassifier == null) continue;
                requireds.addAll(ComponentOperationsExt.usedInterfaces(component, realizingClassifier, false));
                for (Classifier parent : realizingClassifier.allParents()) {
                    requireds.addAll(ComponentOperationsExt.usedInterfaces(component, parent, false));
                }
            }
        }
        for (Port ownedPort : component.getOwnedPorts()) {
            requireds.addAll(PortOperationsExt.getRequireds(ownedPort));
        }
        return requireds;
    }

    protected static EList<Interface> realizedInterfaces(Component component, Classifier classifier, boolean resolve, EList<Interface> realizedInterfaces) {
        for (Dependency clientDependency : classifier.getClientDependencies()) {
            if (!(clientDependency instanceof InterfaceRealization)) continue;
            Iterator suppliers = resolve ? clientDependency.getSuppliers().iterator() : ((InternalEList)clientDependency.getSuppliers()).basicIterator();
            while (suppliers.hasNext()) {
                NamedElement supplier = (NamedElement)suppliers.next();
                if (!(supplier instanceof Interface)) continue;
                realizedInterfaces.add((Object)((Interface)supplier));
            }
        }
        return realizedInterfaces;
    }
}

