/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.links;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.Smoothness;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;

public class ConnectionRoutingHelper {
    public static void setConnectionAnchors(Edge connection, Point sourceAnchorPoint, Rectangle sourceBounds, Point targetAnchorPoint, Rectangle targetBounds) {
        ConnectionRoutingHelper.setConnectionSourceAnchor(connection, sourceAnchorPoint, sourceBounds);
        ConnectionRoutingHelper.setConnectionTargetAnchor(connection, targetAnchorPoint, targetBounds);
    }

    public static void setConnectionSourceAnchor(Edge connection, Point sourceAnchorPoint, Rectangle sourceBounds) {
        IdentityAnchor sourceAnchor = (IdentityAnchor)connection.getSourceAnchor();
        if (sourceAnchor == null) {
            sourceAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        }
        sourceAnchor.setId(ConnectionRoutingHelper.getAnchorTerminal(sourceAnchorPoint, sourceBounds));
        connection.setSourceAnchor((Anchor)sourceAnchor);
    }

    public static void setConnectionTargetAnchor(Edge connection, Point targetAnchorPoint, Rectangle targetBounds) {
        IdentityAnchor targetAnchor = (IdentityAnchor)connection.getTargetAnchor();
        if (targetAnchor == null) {
            targetAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        }
        targetAnchor.setId(ConnectionRoutingHelper.getAnchorTerminal(targetAnchorPoint, targetBounds));
        connection.setTargetAnchor((Anchor)targetAnchor);
    }

    public static void setConnectionBendPoints(Edge connection, List<Point> bendPoints, Point sourceRefPoint, Point targetRefPoint, boolean isSmooth) {
        ArrayList<RelativeBendpoint> newBendpoints = new ArrayList<RelativeBendpoint>();
        for (Point bendPoint : bendPoints) {
            newBendpoints.add(new RelativeBendpoint(bendPoint.x - (int)sourceRefPoint.preciseX(), bendPoint.y - (int)sourceRefPoint.preciseY(), bendPoint.x - (int)targetRefPoint.preciseX(), bendPoint.y - (int)targetRefPoint.preciseY()));
        }
        if (isSmooth) {
            RoutingStyle umlRoutingStyle = (RoutingStyle)connection.getStyle(NotationPackage.Literals.ROUTING_STYLE);
            if (umlRoutingStyle == null) {
                umlRoutingStyle = NotationFactory.eINSTANCE.createRoutingStyle();
            }
            umlRoutingStyle.setSmoothness(Smoothness.NORMAL_LITERAL);
        }
        RelativeBendpoints umlBendpoints = (RelativeBendpoints)connection.getBendpoints();
        umlBendpoints.setPoints(newBendpoints);
    }

    private static String getAnchorTerminal(Point point, Rectangle participantBounds) {
        return ConnectionRoutingHelper.composeTerminalString(BaseSlidableAnchor.getAnchorRelativeLocation((Point)point, (Rectangle)participantBounds));
    }

    private static String composeTerminalString(PrecisionPoint p) {
        StringBuffer s = new StringBuffer(24);
        s.append('(');
        s.append((float)p.preciseX);
        s.append(',');
        s.append((float)p.preciseY);
        s.append(')');
        return s.toString();
    }
}

