/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.links;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterLinkDescriptor;
import org.eclipse.uml2.diagram.common.links.ILinkDetector;
import org.eclipse.uml2.diagram.common.links.ILinkFilter;

public class DefaultLinkFilter
implements ILinkFilter {
    private final ILinkDetector myLinkDetector;
    private Collection<IUpdaterLinkDescriptor> myLinks;

    public DefaultLinkFilter(ILinkDetector linkDetector) {
        this.myLinkDetector = linkDetector;
        this.myLinks = new LinkedList<IUpdaterLinkDescriptor>();
    }

    @Override
    public void visit(IUpdaterLinkDescriptor link) {
        if (!(this.myLinkDetector.isProvidedInterfaceLink(link) || this.myLinkDetector.isRequiredInterfaceLink(link) || this.myLinkDetector.isInterfaceRealizationLink(link) || this.myLinkDetector.isUsageLink(link))) {
            this.myLinks.add(link);
        }
    }

    @Override
    public Collection<IUpdaterLinkDescriptor> getFilteredLinks() {
        return Collections.unmodifiableCollection(this.myLinks);
    }
}

