/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.links;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterLinkDescriptor;
import org.eclipse.uml2.diagram.common.links.DefaultLinkFilter;
import org.eclipse.uml2.diagram.common.links.ILinkDetector;
import org.eclipse.uml2.diagram.common.links.ILinkFilter;
import org.eclipse.uml2.diagram.common.links.InterfaceRealizationLinkFilter;
import org.eclipse.uml2.diagram.common.links.ProvidedInterfaceLinkFilter;
import org.eclipse.uml2.diagram.common.links.RequiredInterfaceLinkFilter;
import org.eclipse.uml2.diagram.common.links.UsageLinkFilter;

public class InterfaceLinkManager {
    private boolean ourHideProvidedInterfaceLinks;
    private boolean ourHideRequiredInterfaceLinks;
    private boolean ourHideInterfaceRealizationLinks;
    private boolean ourHideUsageLinks;
    private final List<ILinkFilter> myLinkManagers;
    private final ILinkDetector myLinkDetector;

    public InterfaceLinkManager(Collection<IUpdaterLinkDescriptor> linkDescriptors, IPreferenceStore store, ILinkDetector linkDetector) {
        this.myLinkDetector = linkDetector;
        this.myLinkManagers = new ArrayList<ILinkFilter>(5);
        this.refreshOptions(store);
        this.buildTable(linkDescriptors);
    }

    public Collection<IUpdaterLinkDescriptor> getFilteredLinkDescriptors() {
        ArrayList<IUpdaterLinkDescriptor> result = new ArrayList<IUpdaterLinkDescriptor>();
        for (ILinkFilter manager : this.myLinkManagers) {
            result.addAll(manager.getFilteredLinks());
        }
        return result;
    }

    private void initFilters() {
        if (!this.ourHideProvidedInterfaceLinks) {
            this.myLinkManagers.add(new ProvidedInterfaceLinkFilter(this.myLinkDetector));
        }
        if (!this.ourHideRequiredInterfaceLinks) {
            this.myLinkManagers.add(new RequiredInterfaceLinkFilter(this.myLinkDetector));
        }
        if (!this.ourHideInterfaceRealizationLinks) {
            this.myLinkManagers.add(new InterfaceRealizationLinkFilter(this.myLinkDetector));
        }
        if (!this.ourHideUsageLinks) {
            this.myLinkManagers.add(new UsageLinkFilter(this.myLinkDetector));
        }
        this.myLinkManagers.add(new DefaultLinkFilter(this.myLinkDetector));
    }

    private void refreshOptions(IPreferenceStore store) {
        this.ourHideProvidedInterfaceLinks = store.getBoolean("org.eclipse.uml2.diagram.preferences.hide_provided_interface_links");
        this.ourHideRequiredInterfaceLinks = store.getBoolean("org.eclipse.uml2.diagram.preferences.hide_required_interface_links");
        this.ourHideInterfaceRealizationLinks = store.getBoolean("org.eclipse.uml2.diagram.preferences.hide_interface_realization_links");
        this.ourHideUsageLinks = store.getBoolean("org.eclipse.uml2.diagram.preferences.hide_usage_links");
    }

    private void buildTable(Collection<IUpdaterLinkDescriptor> linkDescriptors) {
        this.initFilters();
        for (IUpdaterLinkDescriptor next : linkDescriptors) {
            for (ILinkFilter manager : this.myLinkManagers) {
                manager.visit(next);
            }
        }
    }
}

