/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.links;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterLinkDescriptor;
import org.eclipse.uml2.diagram.common.links.ILinkDetector;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;

public class RefreshComplementaryLinksHelper {
    public static final String PORT_PROVIDED_INTERFACES_AFTER_PORT_EVENT = "Port`s provided interfaces after port event";
    public static final String PORT_PROVIDED_INTERFACE_AFTER_PORT_PROVIDED_SOURCE_CHANGED = "Port`s provided interface`s interface realization links";
    public static final String INTERFACE_TARGET_INTERFACE_REALIZATIONS_AFTER_PORT_PROVIDED_TARGET_CHANGED = "Interface`s target interface realization links";
    public static final String PORT_AFTER_INTERFACE_REALIZATION_TARGET_CHANGED = "Port`s provided interfaces, corresponding to interface realization, after interface realization target changed";
    public static final String PORT_AFTER_INTERFACE_REALIZATION_SOURCE_CHANGED = "Port`s provided interfaces, corresponding to interface realization, after interface realization source changed";
    public static final String INTERFACE_AFTER_PORT_REQUIRED_REORIENTED = "Usages targeted by interface";
    public static final String PORT_REQUIRED_INTERFACE_TARGET_USAGES_AFTER_REQUIRED_INTERFACE_SOURCE_CHANGED = "Usages targeted by link`s target interface";
    public static final String PORT_AFTER_USAGE_TARGET_CHANGED = "Required interface links of ports typed by unchanged usage source";
    public static final String PORT_AFTER_USAGE_SOURCE_CHANGED = "Required interface links of ports typed by new and old usage source";
    private final Map<EObject, View> myViewMap = new HashMap<EObject, View>();
    private final Map<NotificationDescription, String> myNotificationDescriptions = new HashMap<NotificationDescription, String>();
    private static final RefreshComplementaryLinksHelper INSTANCE = new RefreshComplementaryLinksHelper();

    public static RefreshComplementaryLinksHelper getInstance() {
        return INSTANCE;
    }

    private RefreshComplementaryLinksHelper() {
    }

    public void addNotificationDescription(EObject semanticObject, Object notificationFeature, String action) {
        this.myNotificationDescriptions.put(new NotificationDescription(semanticObject, notificationFeature), action);
    }

    public void handleNotification(IGraphicalEditPart editPart, Notification notification, IDiagramLinkInfoProvider provider) {
        NotificationDescription descr = new NotificationDescription(editPart.getNotationView().getElement(), notification.getFeature());
        String action = this.myNotificationDescriptions.get(descr);
        if (action != null) {
            this.myNotificationDescriptions.remove(descr);
            if (action == PORT_PROVIDED_INTERFACES_AFTER_PORT_EVENT) {
                this.refreshPortProvidedInterfaceConnections(editPart, provider);
            } else if (action == PORT_PROVIDED_INTERFACE_AFTER_PORT_PROVIDED_SOURCE_CHANGED) {
                this.refreshPortProvidedInterfaceConnectionsAfterPortProvidedSourceChanged(editPart, notification, provider);
            } else if (action == INTERFACE_TARGET_INTERFACE_REALIZATIONS_AFTER_PORT_PROVIDED_TARGET_CHANGED) {
                this.refreshInterfaceConnectionsAfterPortProvidedTargetChanged(editPart, provider);
            } else if (action == PORT_AFTER_INTERFACE_REALIZATION_TARGET_CHANGED) {
                this.refreshPortConnectionsAfterInterfaceRealizationTargetChanged(editPart, notification, provider);
            } else if (action == PORT_AFTER_INTERFACE_REALIZATION_SOURCE_CHANGED) {
                this.refreshPortConnectionsAfterInterfaceRealizationSourceChanged(editPart, notification, provider);
            } else if (action == INTERFACE_AFTER_PORT_REQUIRED_REORIENTED) {
                this.refreshInterfaceConnectionsAfterPortRequiredReoriented(editPart, provider);
            } else if (action == PORT_REQUIRED_INTERFACE_TARGET_USAGES_AFTER_REQUIRED_INTERFACE_SOURCE_CHANGED) {
                this.refreshPortRequiredInterfaceConnectionsAfterRequiredInterfaceSourceChanged(editPart, notification, provider);
            } else if (action == PORT_AFTER_USAGE_TARGET_CHANGED) {
                this.refreshPortAfterUsageTargetChanged(editPart, notification, provider);
            } else if (action == PORT_AFTER_USAGE_SOURCE_CHANGED) {
                this.refreshRelatingPortsAfterUsageSourceChanged(editPart, notification, provider);
            }
        }
    }

    private void refreshPortProvidedInterfaceConnections(IGraphicalEditPart portEditPart, IDiagramLinkInfoProvider provider) {
        View view = portEditPart.getNotationView();
        Collection<? extends IUpdaterLinkDescriptor> portLinks = provider.getContainedLinks(view);
        LinkedList<IUpdaterLinkDescriptor> proposedLinks = new LinkedList<IUpdaterLinkDescriptor>();
        EObject element = view.getElement();
        ILinkDetector linkDetector = provider.getLinkDetector();
        for (IUpdaterLinkDescriptor iUpdaterLinkDescriptor : portLinks) {
            if (!linkDetector.isProvidedInterfaceLink(iUpdaterLinkDescriptor) || iUpdaterLinkDescriptor.getSource() != element) continue;
            proposedLinks.add(iUpdaterLinkDescriptor);
        }
        LinkedList linkedList = new LinkedList(portEditPart.getSourceConnections());
        LinkedList<EditPart> existingEditParts = new LinkedList<EditPart>();
        for (EditPart editPart : linkedList) {
            Edge edge = (Edge)editPart.getModel();
            if (!provider.isPortProvidedEdge(edge)) continue;
            existingEditParts.add(editPart);
        }
        this.refreshConnections(proposedLinks, existingEditParts, portEditPart, provider);
    }

    private void refreshPortRequiredInterfaceConnections(IGraphicalEditPart portEditPart, Notification notification, IDiagramLinkInfoProvider provider) {
        View view = portEditPart.getNotationView();
        Collection<? extends IUpdaterLinkDescriptor> portLinks = provider.getContainedLinks(view);
        LinkedList<IUpdaterLinkDescriptor> proposedLinks = new LinkedList<IUpdaterLinkDescriptor>();
        EObject element = view.getElement();
        ILinkDetector linkDetector = provider.getLinkDetector();
        for (IUpdaterLinkDescriptor iUpdaterLinkDescriptor : portLinks) {
            if (!linkDetector.isRequiredInterfaceLink(iUpdaterLinkDescriptor) || iUpdaterLinkDescriptor.getSource() != element) continue;
            proposedLinks.add(iUpdaterLinkDescriptor);
        }
        LinkedList linkedList = new LinkedList(portEditPart.getSourceConnections());
        LinkedList<EditPart> existingEditParts = new LinkedList<EditPart>();
        for (EditPart editPart : linkedList) {
            Edge edge = (Edge)editPart.getModel();
            if (!provider.isPortRequiredEdge(edge)) continue;
            existingEditParts.add(editPart);
        }
        this.refreshConnections(proposedLinks, existingEditParts, portEditPart, provider);
    }

    private void refreshPortAfterUsageTargetChanged(IGraphicalEditPart interfaceEditPart, Notification notification, IDiagramLinkInfoProvider provider) {
        HashSet<View> portViews = new HashSet<View>();
        Edge usageEdge = (Edge)(notification.getOldValue() == null ? notification.getNewValue() : notification.getOldValue());
        EObject classifierObject = usageEdge.getSource().getElement();
        if (!(classifierObject instanceof Classifier)) {
            return;
        }
        Classifier classifier = (Classifier)classifierObject;
        View interfaceView = interfaceEditPart.getNotationView();
        for (Object targetEdgeObject : interfaceView.getTargetEdges()) {
            Port port;
            Edge targetEdge = (Edge)targetEdgeObject;
            if (!provider.isPortRequiredEdge(targetEdge) || (port = (Port)targetEdge.getSource().getElement()).getType() != classifier) continue;
            portViews.add(targetEdge.getSource());
        }
        for (View view : portViews) {
            IGraphicalEditPart portEditPart = this.getEditPart(view, interfaceEditPart);
            this.refreshPortRequiredInterfaceConnections(portEditPart, notification, provider);
        }
    }

    private void refreshPortProvidedInterfaceConnectionsAfterPortProvidedSourceChanged(IGraphicalEditPart portEditPart, Notification notification, IDiagramLinkInfoProvider provider) {
        Edge portProvidedEdge = (Edge)notification.getNewValue();
        View interfaceView = portProvidedEdge.getTarget();
        IGraphicalEditPart interfaceEditPart = this.getEditPart(interfaceView, portEditPart);
        this.refreshInterfaceInterfaceRealizations(interfaceEditPart, provider);
    }

    private void refreshRelatingPortsAfterUsageSourceChanged(IGraphicalEditPart usageEditPart, Notification notification, IDiagramLinkInfoProvider provider) {
        View oldSourceView = (View)notification.getOldValue();
        View newSourceView = (View)notification.getNewValue();
        if (oldSourceView == null || newSourceView == null) {
            return;
        }
        HashMap<EObject, View> portViews = new HashMap<EObject, View>();
        EObject oldClassifierObject = oldSourceView.getElement();
        EObject newClassifierObject = newSourceView.getElement();
        if (!(oldClassifierObject instanceof Classifier) || !(newClassifierObject instanceof Classifier)) {
            return;
        }
        Classifier oldClassifier = (Classifier)oldClassifierObject;
        Classifier newClassifier = (Classifier)newClassifierObject;
        Diagram diagram = oldSourceView.getDiagram();
        ArrayList<View> views = new ArrayList<View>();
        views.add((View)diagram);
        int i = 0;
        while (i < views.size()) {
            Port port;
            View next = (View)views.get(i);
            EObject element = next.getElement();
            if (element instanceof Port && ((port = (Port)element).getType() == oldClassifier || port.getType() == newClassifier) && !portViews.containsKey(element)) {
                portViews.put(element, next);
            }
            RefreshComplementaryLinksHelper.addAllChildrenViews(views, next);
            ++i;
        }
        for (View view : portViews.values()) {
            IGraphicalEditPart portEditPart = this.getEditPart(view, usageEditPart);
            this.refreshPortRequiredInterfaceConnections(portEditPart, notification, provider);
        }
    }

    private void refreshInterfaceTargetUsageConnections(IGraphicalEditPart interfaceEditPart, IDiagramLinkInfoProvider provider) {
        View view = interfaceEditPart.getNotationView();
        Interface element = (Interface)view.getElement();
        Collection<IUpdaterLinkDescriptor> interfaceLinks = this.getTargetUsageLinks(element, provider);
        LinkedList<IUpdaterLinkDescriptor> proposedLinks = new LinkedList<IUpdaterLinkDescriptor>();
        ILinkDetector linkDetector = provider.getLinkDetector();
        for (IUpdaterLinkDescriptor link : interfaceLinks) {
            if (!linkDetector.isUsageLink(link) || link.getDestination() != element) continue;
            proposedLinks.add(link);
        }
        LinkedList connectionEditParts = new LinkedList(interfaceEditPart.getTargetConnections());
        LinkedList<EditPart> existingEditParts = new LinkedList<EditPart>();
        for (EditPart editPart : connectionEditParts) {
            Edge edge = (Edge)editPart.getModel();
            if (!provider.isUsageEdge(edge)) continue;
            existingEditParts.add(editPart);
        }
        this.refreshConnections(proposedLinks, existingEditParts, interfaceEditPart, provider);
    }

    private void refreshInterfaceConnectionsAfterPortProvidedTargetChanged(IGraphicalEditPart interfaceEditPart, IDiagramLinkInfoProvider provider) {
        this.refreshInterfaceInterfaceRealizations(interfaceEditPart, provider);
    }

    private void refreshInterfaceInterfaceRealizations(IGraphicalEditPart interfaceEditPart, IDiagramLinkInfoProvider provider) {
        View view = interfaceEditPart.getNotationView();
        Collection<IUpdaterLinkDescriptor> interfaceLinks = this.getTargetInterfaceRealizationLinks((Interface)view.getElement(), provider);
        LinkedList<IUpdaterLinkDescriptor> proposedLinks = new LinkedList<IUpdaterLinkDescriptor>();
        EObject element = view.getElement();
        ILinkDetector linkDetector = provider.getLinkDetector();
        for (IUpdaterLinkDescriptor link : interfaceLinks) {
            if (!linkDetector.isInterfaceRealizationLink(link) || link.getDestination() != element) continue;
            proposedLinks.add(link);
        }
        LinkedList connectionEditParts = new LinkedList(interfaceEditPart.getTargetConnections());
        LinkedList<EditPart> existingEditParts = new LinkedList<EditPart>();
        for (EditPart editPart : connectionEditParts) {
            Edge edge = (Edge)editPart.getModel();
            if (!provider.isInterfaceRealizationEdge(edge)) continue;
            existingEditParts.add(editPart);
        }
        this.refreshConnections(proposedLinks, existingEditParts, interfaceEditPart, provider);
    }

    private void refreshPortConnectionsAfterInterfaceRealizationTargetChanged(IGraphicalEditPart interfaceRealizationEditPart, Notification notification, IDiagramLinkInfoProvider provider) {
        View oldInterfaceView = (View)notification.getOldValue();
        Edge edge = (Edge)interfaceRealizationEditPart.getModel();
        View classifierView = edge.getSource();
        EObject classifier = classifierView.getElement();
        HashSet<View> portViews = new HashSet<View>();
        for (Object targetObject : oldInterfaceView.getTargetEdges()) {
            Edge targetEdge = (Edge)targetObject;
            if (!provider.isPortProvidedEdge(targetEdge) || targetEdge.getSource() == null || targetEdge.getSource().getElement() == null || ((Port)targetEdge.getSource().getElement()).getType() != classifier) continue;
            portViews.add(targetEdge.getSource());
        }
        for (View portView : portViews) {
            this.refreshPortProvidedInterfaceConnections((IGraphicalEditPart)interfaceRealizationEditPart.getViewer().getEditPartRegistry().get(portView), provider);
        }
    }

    private void refreshPortConnectionsAfterInterfaceRealizationSourceChanged(IGraphicalEditPart interfaceRealizationEditPart, Notification notification, IDiagramLinkInfoProvider provider) {
        View oldSourceView = (View)notification.getOldValue();
        View newSourceView = (View)notification.getNewValue();
        if (oldSourceView == null || newSourceView == null) {
            return;
        }
        HashMap<EObject, View> portViews = new HashMap<EObject, View>();
        EObject oldClassifierObject = oldSourceView.getElement();
        EObject newClassifierObject = newSourceView.getElement();
        if (!(oldClassifierObject instanceof Classifier) || !(newClassifierObject instanceof Classifier)) {
            return;
        }
        Classifier oldClassifier = (Classifier)oldClassifierObject;
        Classifier newClassifier = (Classifier)newClassifierObject;
        Diagram diagram = oldSourceView.getDiagram();
        ArrayList<View> views = new ArrayList<View>();
        views.add((View)diagram);
        int i = 0;
        while (i < views.size()) {
            Port port;
            View next = (View)views.get(i);
            EObject element = next.getElement();
            if (element instanceof Port && ((port = (Port)element).getType() == oldClassifier || port.getType() == newClassifier) && !portViews.containsKey(element)) {
                portViews.put(element, next);
            }
            RefreshComplementaryLinksHelper.addAllChildrenViews(views, next);
            ++i;
        }
        for (View view : portViews.values()) {
            IGraphicalEditPart portEditPart = this.getEditPart(view, interfaceRealizationEditPart);
            this.refreshPortProvidedInterfaceConnections(portEditPart, provider);
        }
    }

    private void refreshInterfaceConnectionsAfterPortRequiredReoriented(IGraphicalEditPart interfaceEditPart, IDiagramLinkInfoProvider provider) {
        this.refreshInterfaceTargetUsageConnections(interfaceEditPart, provider);
    }

    private void refreshPortRequiredInterfaceConnectionsAfterRequiredInterfaceSourceChanged(IGraphicalEditPart portEditPart, Notification notification, IDiagramLinkInfoProvider provider) {
        Edge edge = (Edge)(notification.getNewValue() == null ? notification.getOldValue() : notification.getNewValue());
        View interfaceView = edge.getTarget();
        IGraphicalEditPart interfaceEditPart = (IGraphicalEditPart)portEditPart.getViewer().getEditPartRegistry().get(interfaceView);
        this.refreshInterfaceTargetUsageConnections(interfaceEditPart, provider);
    }

    private void refreshConnections(Collection<IUpdaterLinkDescriptor> proposedLinks, Collection<EditPart> existingEditParts, IGraphicalEditPart editPart, IDiagramLinkInfoProvider provider) {
        LinkedList<EditPart> editPartsToRemove = new LinkedList<EditPart>();
        for (EditPart existingEditPart : existingEditParts) {
            Edge edge = (Edge)existingEditPart.getModel();
            boolean found = false;
            Iterator<IUpdaterLinkDescriptor> linkIterator = proposedLinks.iterator();
            while (linkIterator.hasNext()) {
                IUpdaterLinkDescriptor linkDescriptor = linkIterator.next();
                if (!provider.hasVisualId(edge, linkDescriptor.getVisualID()) || linkDescriptor.getSource() != edge.getSource().getElement() || linkDescriptor.getDestination() != edge.getTarget().getElement()) continue;
                linkIterator.remove();
                found = true;
            }
            if (found) continue;
            editPartsToRemove.add(existingEditPart);
        }
        this.deleteViews(editPartsToRemove.iterator(), editPart);
        this.createConnections(proposedLinks, editPart, provider);
    }

    private void deleteViews(Iterator<EditPart> editParts, IGraphicalEditPart baseEditPart) {
        boolean doDelete;
        CompoundCommand cc = new CompoundCommand(DiagramUIMessages.DeleteCommand_Label);
        while (editParts.hasNext()) {
            cc.add(this.getDeleteViewCommand(editParts.next()));
        }
        boolean bl = doDelete = !cc.isEmpty() && cc.canExecute();
        if (doDelete) {
            this.executeCommand((Command)cc, baseEditPart);
        }
    }

    private Command getDeleteViewCommand(EditPart editPart) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)editPart).getEditingDomain();
        return new ICommandProxy((ICommand)new DeleteCommand(editingDomain, (View)editPart.getModel()));
    }

    private Collection<IAdaptable> createConnections(Collection<IUpdaterLinkDescriptor> linkDescriptors, IGraphicalEditPart givenEditPart, IDiagramLinkInfoProvider provider) {
        LinkedList<IAdaptable> adapters = new LinkedList<IAdaptable>();
        for (IUpdaterLinkDescriptor nextLinkDescriptor : linkDescriptors) {
            IGraphicalEditPart sourceEditPart = this.getEditPart(nextLinkDescriptor.getSource(), givenEditPart);
            IGraphicalEditPart targetEditPart = this.getEditPart(nextLinkDescriptor.getDestination(), givenEditPart);
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), provider.getType(nextLinkDescriptor.getVisualID()), -1, false, givenEditPart.getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart((EditPart)sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart((EditPart)targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            this.executeCommand(cmd, givenEditPart);
            IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
            if (viewAdapter == null) continue;
            adapters.add(viewAdapter);
        }
        return adapters;
    }

    private View findView(EObject element, IGraphicalEditPart editPart) {
        View view = this.myViewMap.get(element);
        if (view == null || view.getElement() != element || view.getDiagram() != editPart.getNotationView().getDiagram()) {
            view = this.searchView(element, editPart);
        }
        return view;
    }

    private View searchView(EObject element, IGraphicalEditPart editPart) {
        Diagram topElement = editPart.getNotationView().getDiagram();
        ArrayList<View> views = new ArrayList<View>();
        views.add((View)topElement);
        this.myViewMap.clear();
        int i = 0;
        while (i < views.size()) {
            View currentView = (View)views.get(i);
            EObject currentElement = currentView.getElement();
            if (currentElement != null) {
                if (!this.myViewMap.containsKey(currentElement)) {
                    this.myViewMap.put(currentElement, currentView);
                }
                if (currentElement == element) {
                    return currentView;
                }
            }
            RefreshComplementaryLinksHelper.addAllChildrenViews(views, currentView);
            ++i;
        }
        return null;
    }

    private IGraphicalEditPart getEditPart(EObject element, IGraphicalEditPart knownEditPart) {
        View view = this.findView(element, knownEditPart);
        if (view == null) {
            return null;
        }
        return (IGraphicalEditPart)knownEditPart.getViewer().getEditPartRegistry().get(view);
    }

    private IGraphicalEditPart getEditPart(View view, IGraphicalEditPart knownEditPart) {
        return (IGraphicalEditPart)knownEditPart.getViewer().getEditPartRegistry().get(view);
    }

    private void executeCommand(Command command, IGraphicalEditPart knownEditPart) {
        knownEditPart.getViewer().getEditDomain().getCommandStack().execute(command);
    }

    private Collection<IUpdaterLinkDescriptor> getTargetInterfaceRealizationLinks(Interface target, IDiagramLinkInfoProvider provider) {
        LinkedList<IUpdaterLinkDescriptor> result = new LinkedList<IUpdaterLinkDescriptor>();
        for (EObject linkObject : target.getRelationships(UMLPackage.eINSTANCE.getInterfaceRealization())) {
            NamedElement source;
            InterfaceRealization link;
            EList sources;
            if (!(linkObject instanceof InterfaceRealization) || (sources = (link = (InterfaceRealization)linkObject).getClients()).size() != 1 || !((source = (NamedElement)sources.get(0)) instanceof Classifier) || !link.getSuppliers().contains((Object)target)) continue;
            result.add(provider.createInterfaceRealizationLinkDescriptor((Classifier)sources.get(0), target, link));
        }
        return result;
    }

    private Collection<IUpdaterLinkDescriptor> getTargetUsageLinks(Interface target, IDiagramLinkInfoProvider provider) {
        LinkedList<IUpdaterLinkDescriptor> result = new LinkedList<IUpdaterLinkDescriptor>();
        for (EObject linkObject : target.getRelationships(UMLPackage.eINSTANCE.getUsage())) {
            NamedElement source;
            Usage link;
            EList sources;
            if (!(linkObject instanceof Usage) || (sources = (link = (Usage)linkObject).getClients()).size() != 1 || !((source = (NamedElement)sources.get(0)) instanceof Classifier) || !link.getSuppliers().contains((Object)target)) continue;
            result.add(provider.createUsageLinkDescriptor((Classifier)source, target, link));
        }
        return result;
    }

    private static Collection<View> addAllChildrenViews(Collection<View> output, View parent) {
        output.addAll((Collection<View>)parent.getChildren());
        return output;
    }

    public static interface IDiagramLinkInfoProvider {
        public ILinkDetector getLinkDetector();

        public Collection<? extends IUpdaterLinkDescriptor> getContainedLinks(View var1);

        public boolean isPortProvidedEdge(Edge var1);

        public boolean isInterfaceRealizationEdge(Edge var1);

        public boolean isPortRequiredEdge(Edge var1);

        public boolean isUsageEdge(Edge var1);

        public boolean hasVisualId(Edge var1, int var2);

        public String getType(int var1);

        public IUpdaterLinkDescriptor createInterfaceRealizationLinkDescriptor(Classifier var1, Interface var2, InterfaceRealization var3);

        public IUpdaterLinkDescriptor createUsageLinkDescriptor(Classifier var1, Interface var2, Usage var3);
    }

    private class NotificationDescription {
        private EObject object;
        private Object notificationFeature;

        public NotificationDescription(EObject object, Object notificationFeature) {
            this.object = object;
            this.notificationFeature = notificationFeature;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.notificationFeature == null ? 0 : this.notificationFeature.hashCode());
            result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof NotificationDescription)) {
                return false;
            }
            NotificationDescription other = (NotificationDescription)obj;
            if (this.notificationFeature == null ? other.notificationFeature != null : !this.notificationFeature.equals(other.notificationFeature)) {
                return false;
            }
            return !(this.object == null ? other.object != null : !this.object.equals(other.object));
        }
    }
}

