/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.parser.stereotype;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.uml2.diagram.common.commands.ApplyStereotypeHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class AppliedStereotypeParser
implements ISemanticParser {
    private static final String APPLIED_PROFILE = "\u00ab{0}\u00bb";
    protected static final String STEREOTYPE_SEPARATOR = ",";
    private static final String PLUGIN_ID = "org.eclipse.uml2.diagram.common";

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        Object feature;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            EStructuralFeature featureImpl = (EStructuralFeature)feature;
            return featureImpl.getName().startsWith("base_");
        }
        return false;
    }

    public List<?> getSemanticElementsBeingParsed(EObject eObject) {
        Element element = (Element)eObject;
        LinkedList result = new LinkedList();
        result.addAll(element.getStereotypeApplications());
        return result;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable subject) {
        return null;
    }

    public String getEditString(IAdaptable element, int flags) {
        Element subject = this.doAdapt(element);
        EList stereos = subject.getAppliedStereotypes();
        if (stereos.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (Stereotype next : stereos) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(next.getName());
        }
        return result.toString();
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        Element subject = this.doAdapt(element);
        List<String> toApply = AppliedStereotypeParser.getStereotypesToApply(newString);
        return ApplyStereotypeHelper.getCommand(subject, toApply);
    }

    public String getPrintString(IAdaptable element, int flags) {
        String classifier = this.getElementLabel(this.doAdapt(element));
        String editString = this.getEditString(element, flags);
        if (classifier != null) {
            String result = classifier;
            if (editString != null && editString.length() > 0) {
                result = String.valueOf(result) + ", " + editString;
            }
            return NLS.bind((String)APPLIED_PROFILE, (Object[])new Object[]{result});
        }
        return editString == null || editString.length() == 0 ? editString : NLS.bind((String)APPLIED_PROFILE, (Object[])new Object[]{editString});
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return false;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        Element subject = this.doAdapt(element);
        List<String> toApply = AppliedStereotypeParser.getStereotypesToApply(editString);
        ArrayList<String> applicables = new ArrayList<String>();
        for (Stereotype stereo : subject.getApplicableStereotypes()) {
            applicables.add(stereo.getName());
        }
        for (String str : toApply) {
            if (applicables.contains(str)) continue;
            return new ParserEditStatus(4, PLUGIN_ID, 1, "Unknown stereotype: " + str, null);
        }
        return ParserEditStatus.EDITABLE_STATUS;
    }

    private static List<String> getStereotypesToApply(String editString) {
        StringTokenizer t = new StringTokenizer(editString, STEREOTYPE_SEPARATOR);
        ArrayList<String> toApply = new ArrayList<String>(t.countTokens());
        while (t.hasMoreTokens()) {
            toApply.add(t.nextToken().trim());
        }
        return toApply;
    }

    protected String getElementLabel(Element element) {
        return null;
    }

    protected Element doAdapt(IAdaptable adaptable) {
        Element element = (Element)adaptable.getAdapter(EObject.class);
        return element;
    }
}

