/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.pathmap;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;

public abstract class PathMapResolver {
    protected static final String PATHMAP_FORMAT = "pathmap://{0}/{1}";

    public abstract boolean isApplicable(URI var1);

    public abstract Collection<String> getProfiles(URI var1, String var2) throws Exception;

    protected boolean isProfileFile(String fileName) {
        return fileName.endsWith("profile.uml");
    }

    protected Collection<String> getProfilesFromFolder(File folder, String pathmapVarName) {
        if (!folder.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<String> pathmaps = new ArrayList<String>();
        String[] files = folder.list();
        int i = 0;
        while (i < files.length) {
            String currFile = files[i];
            if (this.isProfileFile(currFile)) {
                String pathmap = NLS.bind((String)PATHMAP_FORMAT, (Object[])new Object[]{pathmapVarName, currFile});
                pathmaps.add(pathmap);
            }
            ++i;
        }
        return pathmaps;
    }
}

