/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.sheet.chooser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.diagram.common.sheet.chooser.ConfigurableFilterMatcher;
import org.eclipse.uml2.diagram.common.sheet.chooser.ElementChooserPage;
import org.eclipse.uml2.diagram.common.sheet.chooser.FilteredListControl;
import org.eclipse.uml2.diagram.common.sheet.chooser.SimpleNamedElementLabelProvider;

public class ElementFilteredListChooser
implements ElementChooserPage {
    private FilteredListControl myFilteredList;
    private final ElementChooserPage.Validator myValidator;
    private Object[] myListElements;
    private final AdapterFactoryContentProvider myAdapterFctoryContentProvier;
    private final AdapterFactory myItemProvidersAdapterFactory;
    private final TransactionalEditingDomain myEditingDomain;
    private final EObject mySourceObject;
    private final EStructuralFeature myFeature;

    public ElementFilteredListChooser(AdapterFactory itemProvidersAdapterFactory, EObject sourceObject, EStructuralFeature feature, ElementChooserPage.Validator validator, TransactionalEditingDomain editingDomain) {
        this.myItemProvidersAdapterFactory = itemProvidersAdapterFactory;
        this.mySourceObject = sourceObject;
        this.myFeature = feature;
        this.myValidator = validator;
        this.myAdapterFctoryContentProvier = new AdapterFactoryContentProvider(itemProvidersAdapterFactory);
        this.myEditingDomain = editingDomain;
    }

    @Override
    public Control createControl(Composite parent) {
        this.myFilteredList = new FilteredListControl(parent, (ILabelProvider)new AdapterFactoryLabelProvider(this.myItemProvidersAdapterFactory));
        Object featureValue = this.mySourceObject.eGet(this.myFeature);
        if (featureValue != null) {
            this.myFilteredList.setInitialSelections(new Object[]{featureValue});
        }
        SimpleNamedElementLabelProvider labelProvider = new SimpleNamedElementLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider(this.myItemProvidersAdapterFactory));
        this.myFilteredList.setFilterMatcher(new ConfigurableFilterMatcher(labelProvider));
        this.myListElements = this.collectElements(this.mySourceObject.eResource().getResourceSet());
        this.myFilteredList.setListElements(this.myListElements);
        return this.myFilteredList;
    }

    @Override
    public final List<?> getSelection() {
        Object[] result = this.myFilteredList.getSelectedElements();
        return Arrays.asList(result);
    }

    @Override
    public final void setSelection(List<?> selection) {
        if (selection == null || selection.isEmpty()) {
            this.myFilteredList.setSelection(null);
        } else {
            this.addMissingElements(selection);
            this.myFilteredList.setSelection(selection.toArray());
        }
    }

    private void addMissingElements(List<?> selection) {
        List<Object> els = Arrays.asList(this.myListElements);
        if (els.containsAll(selection)) {
            return;
        }
        ArrayList elementsToAdd = new ArrayList(selection.size());
        for (Object next : selection) {
            if ((next = this.myValidator.validate(next)) == null || els.contains(next)) continue;
            elementsToAdd.add(next);
        }
        this.addElements(elementsToAdd.toArray(new Object[elementsToAdd.size()]));
    }

    private void addElements(Object[] elements) {
        this.myListElements = this.concatArrays(this.myListElements, elements);
        this.myFilteredList.setListElements(this.myListElements);
    }

    private Object[] concatArrays(Object[] first, Object[] second) {
        Object[] result = new Object[first.length + second.length];
        System.arraycopy(second, 0, result, 0, second.length);
        System.arraycopy(first, 0, result, second.length, first.length);
        return result;
    }

    protected EObject[] collectElements(Object inputElement) {
        LinkedList<EObject> result = new LinkedList<EObject>();
        for (EObject next : this.getAllChildren(inputElement)) {
            EObject transformed;
            if (!(next instanceof EObject) || (transformed = this.myValidator.validate(next)) == null) continue;
            result.add(transformed);
        }
        return result.toArray(new EObject[result.size()]);
    }

    protected Collection<EObject> getAllChildren(Object parentElement) {
        return ItemPropertyDescriptor.getReachableObjectsOfType((EObject)this.mySourceObject, (EClassifier)this.myFeature.getEType());
    }

    @Override
    public void addDoubleClickListener(IDoubleClickListener l) {
        this.myFilteredList.addDoubleClickListener(l);
    }

    @Override
    public void addSelectionListener(ISelectionChangedListener l) {
        this.myFilteredList.addSelectionListener(l);
    }
}

