/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.sheet.chooser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.uml2.diagram.common.Messages;
import org.eclipse.uml2.diagram.common.providers.ImageUtils;
import org.eclipse.uml2.diagram.common.sheet.chooser.ElementChooserPage;
import org.eclipse.uml2.diagram.common.sheet.chooser.UMLContainmentFilter;
import org.eclipse.uml2.diagram.common.sheet.chooser.UMLFileFilter;

public class ElementTreeChooser
implements ElementChooserPage {
    private final AdapterFactory myItemProvidersAdapterFactory;
    private TreeViewer myTreeViewer;
    private URI mySelectedModelElementURI;
    private final TransactionalEditingDomain myEditingDomain;
    private final EObject mySourceObject;
    private final EStructuralFeature myFeature;
    private MainRoot myRoot;

    public ElementTreeChooser(AdapterFactory itemProvidersAdapterFactory, EObject sourceObject, EStructuralFeature feature, TransactionalEditingDomain editingDomain) {
        this.myItemProvidersAdapterFactory = itemProvidersAdapterFactory;
        this.mySourceObject = sourceObject;
        this.myFeature = feature;
        this.myEditingDomain = editingDomain;
    }

    @Override
    public Control createControl(Composite parent) {
        Composite composite = this.createModelBrowser(parent);
        this.myRoot = new MainRoot(this.mySourceObject);
        this.myTreeViewer.setInput((Object)this.myRoot);
        this.myTreeViewer.addFilter((ViewerFilter)new UMLFileFilter());
        if (this.myFeature instanceof EReference) {
            this.myTreeViewer.addFilter((ViewerFilter)new UMLContainmentFilter((EReference)this.myFeature, false));
        }
        this.myTreeViewer.expandToLevel((Object)this.myRoot.getCurrentResourceRoot(), 1);
        this.myTreeViewer.expandToLevel((Object)this.myRoot.getLoadedResourcesRoot(), 1);
        new MenuBuilder(this.myTreeViewer).attachMenu();
        return composite;
    }

    @Override
    public List<?> getSelection() {
        return ((IStructuredSelection)this.myTreeViewer.getSelection()).toList();
    }

    @Override
    public void setSelection(List<?> selection) {
        if (selection == null || selection.isEmpty()) {
            this.myTreeViewer.setSelection(null);
        } else {
            ArrayList<TreePath> paths = new ArrayList<TreePath>(selection.size());
            for (Object next : selection) {
                TreePath path = this.getTreePath(next);
                if (path == null) continue;
                paths.add(path);
            }
            this.myTreeViewer.setSelection((ISelection)new StructuredSelection(paths), true);
        }
    }

    private Composite createModelBrowser(Composite composite) {
        this.myTreeViewer = new TreeViewer(composite, 2820);
        this.myTreeViewer.setContentProvider((IContentProvider)new ModelElementsTreeContentProvider(this.myItemProvidersAdapterFactory, this.myEditingDomain.getResourceSet()));
        this.myTreeViewer.setLabelProvider((IBaseLabelProvider)new ModelElementsTreeLabelProvider());
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 300;
        layoutData.widthHint = 300;
        Tree result = this.myTreeViewer.getTree();
        result.setLayout((Layout)new GridLayout());
        result.setLayoutData((Object)layoutData);
        return result;
    }

    public URI getSelectedModelElementURI() {
        return this.mySelectedModelElementURI;
    }

    public void dispose() {
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        this.myEditingDomain.dispose();
    }

    private TreePath getTreePath(Object element) {
        if (element == null) {
            return null;
        }
        if (!(element instanceof EObject)) {
            return new TreePath(new Object[]{element});
        }
        List<Object> segments = this.buildPathSegments((EObject)element);
        Collections.reverse(segments);
        TreePath path = new TreePath(segments.toArray(new Object[segments.size()]));
        return path;
    }

    private List<Object> buildPathSegments(EObject element) {
        ArrayList<Object> segments = new ArrayList<Object>();
        EObject container = element;
        while (container != null) {
            segments.add(container);
            container = container.eContainer();
        }
        if (this.isInCurrentResource(element)) {
            segments.add(this.myRoot.getCurrentResourceRoot());
            segments.add(this.myRoot);
            return segments;
        }
        if (this.inInLoadedResource(element)) {
            segments.add(element.eResource());
            segments.add(this.myRoot.getLoadedResourcesRoot());
            segments.add(this.myRoot);
            return segments;
        }
        Path path = new Path(element.eResource().getURI().toFileString());
        IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        while (resource != null) {
            segments.add(resource);
            resource = resource.getParent();
        }
        segments.add(this.myRoot.getWorkspaceRoot());
        segments.add(this.myRoot);
        return segments;
    }

    private boolean inInLoadedResource(EObject element) {
        return this.mySourceObject.eResource().getResourceSet().getResources().contains((Object)element.eResource());
    }

    private boolean isInCurrentResource(EObject element) {
        return this.mySourceObject.eResource().equals(element.eResource());
    }

    @Override
    public void addSelectionListener(ISelectionChangedListener l) {
        this.myTreeViewer.addSelectionChangedListener(l);
    }

    @Override
    public void addDoubleClickListener(IDoubleClickListener l) {
        this.myTreeViewer.addDoubleClickListener(l);
    }

    private static class CollapseAllAction
    extends Action {
        private final TreeViewer myViewer;

        CollapseAllAction(TreeViewer viewer) {
            this.myViewer = viewer;
        }

        public void run() {
            this.myViewer.collapseAll();
        }

        public void update() {
        }
    }

    private static class ExpandNodeAction
    extends Action {
        private List<Object> mySelection;
        private final TreeViewer myViewer;

        ExpandNodeAction(TreeViewer viewer) {
            this.myViewer = viewer;
        }

        public void run() {
            Object firstSelected;
            Object object = firstSelected = this.mySelection.isEmpty() ? null : this.mySelection.get(0);
            if (firstSelected == null) {
                return;
            }
            this.myViewer.expandToLevel(firstSelected, -1);
        }

        public void update() {
            this.mySelection = ((IStructuredSelection)this.myViewer.getSelection()).toList();
        }
    }

    class MainRoot
    implements TreeRoot {
        private EObject object;
        private TreeRoot myCurrentResourceRoot;
        private TreeRoot myLoadedResourcesRoot;
        private TreeRoot myWorkspaceRoot;

        MainRoot(EObject object) {
            this.object = object;
        }

        public EObject getObject() {
            return this.object;
        }

        @Override
        public String getLabel() {
            return null;
        }

        public TreeRoot getCurrentResourceRoot() {
            if (this.myCurrentResourceRoot == null) {
                this.myCurrentResourceRoot = new CurrentResource(this.object);
            }
            return this.myCurrentResourceRoot;
        }

        public TreeRoot getLoadedResourcesRoot() {
            if (this.myLoadedResourcesRoot == null) {
                this.myLoadedResourcesRoot = new LoadedResources(this.object);
            }
            return this.myLoadedResourcesRoot;
        }

        public TreeRoot getWorkspaceRoot() {
            if (this.myWorkspaceRoot == null) {
                this.myWorkspaceRoot = new Workspace(this.object);
            }
            return this.myWorkspaceRoot;
        }

        private class CurrentResource
        implements TreeRoot {
            private Resource object;

            CurrentResource(EObject object) {
                this.object = object.eResource();
            }

            @Override
            public Object getObject() {
                return this.object;
            }

            @Override
            public String getLabel() {
                return Messages.ElementTreeChooser_label_current_resources;
            }
        }

        private class LoadedResources
        implements TreeRoot {
            private ResourceSet object;

            LoadedResources(EObject object) {
                this.object = object.eResource().getResourceSet();
            }

            @Override
            public Object getObject() {
                return this.object;
            }

            @Override
            public String getLabel() {
                return Messages.ElementTreeChooser_label_loaded_resources;
            }
        }

        private class Workspace
        implements TreeRoot {
            private IWorkspaceRoot object = ResourcesPlugin.getWorkspace().getRoot();

            Workspace(EObject object) {
            }

            @Override
            public Object getObject() {
                return this.object;
            }

            @Override
            public String getLabel() {
                return Messages.ElementTreeChooser_label_workspace;
            }
        }
    }

    private static class MenuBuilder
    implements IMenuListener {
        private final TreeViewer myViewer;
        private final ExpandNodeAction myExpandNodeChildrenAction;
        private final CollapseAllAction myCollapseAllChildrenAction;
        private static final ImageDescriptor IMG_COLLAPSE_ALL = ImageUtils.getImageDescriptor("icons/collapseall.gif");

        public MenuBuilder(TreeViewer viewer) {
            this.myViewer = viewer;
            this.myCollapseAllChildrenAction = new CollapseAllAction(viewer);
            this.myCollapseAllChildrenAction.setImageDescriptor(IMG_COLLAPSE_ALL);
            this.myCollapseAllChildrenAction.setText(Messages.ElementTreeChooser_action_collapse_all);
            this.myExpandNodeChildrenAction = new ExpandNodeAction(viewer);
            this.myExpandNodeChildrenAction.setText(Messages.ElementTreeChooser_action_expand_node);
        }

        public void attachMenu() {
            MenuManager menuManager = new MenuManager();
            menuManager.addMenuListener((IMenuListener)this);
            menuManager.add((IAction)this.myCollapseAllChildrenAction);
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IAction)this.myExpandNodeChildrenAction);
            this.myViewer.getTree().setMenu(menuManager.createContextMenu((Control)this.myViewer.getTree()));
        }

        public void removeMenu() {
            this.myViewer.getTree().setMenu(null);
        }

        public void menuAboutToShow(IMenuManager manager) {
            this.myCollapseAllChildrenAction.update();
            this.myExpandNodeChildrenAction.update();
        }
    }

    private static class ModelElementsTreeContentProvider
    implements ITreeContentProvider {
        private static final Object[] NOTHING = new Object[0];
        private static final ITreeContentProvider myWorkbenchContentProvider = new WorkbenchContentProvider();
        private final AdapterFactoryContentProvider myAdapterFctoryContentProvier;
        private final ResourceSet myResourceSet;

        public ModelElementsTreeContentProvider(AdapterFactory itemProvidersAdapterFactory, ResourceSet resourceSet) {
            this.myAdapterFctoryContentProvier = new AdapterFactoryContentProvider(itemProvidersAdapterFactory);
            this.myResourceSet = resourceSet;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] result;
            if (parentElement instanceof TreeRoot) {
                parentElement = ((TreeRoot)parentElement).getObject();
            }
            if ((result = myWorkbenchContentProvider.getChildren(parentElement)) != null && result.length > 0) {
                return result;
            }
            if (parentElement instanceof ResourceSet) {
                EList resources = ((ResourceSet)parentElement).getResources();
                return resources.toArray((Object[])new Resource[resources.size()]);
            }
            if (parentElement instanceof IFile) {
                IFile modelFile = (IFile)parentElement;
                IPath resourcePath = modelFile.getFullPath();
                try {
                    Resource modelResource = this.myResourceSet.getResource(URI.createPlatformResourceURI((String)resourcePath.toString(), (boolean)true), true);
                    return this.myAdapterFctoryContentProvier.getChildren((Object)modelResource);
                }
                catch (WrappedException e) {
                    e.printStackTrace();
                    return NOTHING;
                }
            }
            return this.myAdapterFctoryContentProvier.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            Object parent = myWorkbenchContentProvider.getParent(element);
            if (parent != null) {
                return parent;
            }
            if (!(element instanceof EObject)) {
                return null;
            }
            EObject eObject = (EObject)element;
            if (eObject.eContainer() == null && eObject.eResource().getURI().isFile()) {
                String path = eObject.eResource().getURI().path();
                return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
            }
            return this.myAdapterFctoryContentProvier.getParent((Object)eObject);
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TreeRoot) {
                element = ((TreeRoot)element).getObject();
            }
            if (element instanceof IFile) {
                return this.isValidModelFile((IFile)element);
            }
            return myWorkbenchContentProvider.hasChildren(element) || this.myAdapterFctoryContentProvier.hasChildren(element);
        }

        private boolean isValidModelFile(IFile file) {
            String fileExtension = file.getFullPath().getFileExtension();
            return "uml".equals(fileExtension);
        }

        public Object[] getElements(Object inputElement) {
            MainRoot root = (MainRoot)inputElement;
            return new Object[]{root.getCurrentResourceRoot(), root.getLoadedResourcesRoot(), root.getWorkspaceRoot()};
        }

        public void dispose() {
            this.myAdapterFctoryContentProvier.dispose();
            myWorkbenchContentProvider.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            myWorkbenchContentProvider.inputChanged(viewer, oldInput, newInput);
            this.myAdapterFctoryContentProvier.inputChanged(viewer, oldInput, newInput);
        }
    }

    private class ModelElementsTreeLabelProvider
    implements ILabelProvider {
        private WorkbenchLabelProvider myWorkbenchLabelProvider = new WorkbenchLabelProvider();
        private AdapterFactoryLabelProvider myAdapterFactoryLabelProvider;

        private ModelElementsTreeLabelProvider() {
            this.myAdapterFactoryLabelProvider = new AdapterFactoryLabelProvider(ElementTreeChooser.this.myItemProvidersAdapterFactory);
        }

        public Image getImage(Object element) {
            Image result;
            if (element instanceof TreeRoot) {
                element = ((TreeRoot)element).getObject();
            }
            return (result = this.myWorkbenchLabelProvider.getImage(element)) != null ? result : this.myAdapterFactoryLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof TreeRoot) {
                return ((TreeRoot)element).getLabel();
            }
            String result = this.myWorkbenchLabelProvider.getText(element);
            return result != null && result.length() > 0 ? result : this.myAdapterFactoryLabelProvider.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.myWorkbenchLabelProvider.addListener(listener);
            this.myAdapterFactoryLabelProvider.addListener(listener);
        }

        public void dispose() {
            this.myWorkbenchLabelProvider.dispose();
            this.myAdapterFactoryLabelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.myWorkbenchLabelProvider.isLabelProperty(element, property) || this.myAdapterFactoryLabelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.myWorkbenchLabelProvider.removeListener(listener);
            this.myAdapterFactoryLabelProvider.removeListener(listener);
        }
    }

    private static interface TreeRoot {
        public Object getObject();

        public String getLabel();
    }
}

