/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.sheet.chooser;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.UMLPackage;

public class MetaclassContainmentFilter {
    private static final boolean DEBUG = Boolean.FALSE;
    private final EPackage myMetamodel;
    private final EPackageRegistry myRegistry;
    private final Map<EClass, Set<EClass>> myAncestorsOrSelfMap;
    private final List<EReference> myContainments;

    public MetaclassContainmentFilter(EPackage metamodel) {
        this(metamodel, Collections.emptyList());
    }

    public MetaclassContainmentFilter(EPackage metamodel, List<EReference> excludedContainments) {
        this.myMetamodel = metamodel;
        this.myRegistry = this.myMetamodel == UMLPackage.eINSTANCE ? EPackageRegistry.getUML() : new EPackageRegistry(this.myMetamodel);
        this.myAncestorsOrSelfMap = new HashMap<EClass, Set<EClass>>();
        this.myContainments = Collections.unmodifiableList(MetaclassContainmentFilter.loadContainments(this.myMetamodel, excludedContainments));
    }

    private static List<EReference> loadContainments(EPackage metamodel, List<EReference> excludedContainments) {
        LinkedList<EReference> result = new LinkedList<EReference>();
        for (EClassifier nextClassifier : metamodel.getEClassifiers()) {
            if (!(nextClassifier instanceof EClass)) continue;
            for (EStructuralFeature next : ((EClass)nextClassifier).getEStructuralFeatures()) {
                EReference reference;
                if (!(next instanceof EReference) || excludedContainments.contains(reference = (EReference)next) || !reference.isContainment() || reference.isDerived()) continue;
                result.add(reference);
            }
        }
        return result;
    }

    public Set<EClass> getAncestorsOrSelf(EClass eClass) {
        if (eClass.getEPackage() != this.myMetamodel) {
            throw new IllegalArgumentException("Alien class: " + eClass + ", Expected metamodel: " + this.myMetamodel + ", Actual metamodel: " + eClass.getEPackage());
        }
        Set<EClass> result = this.myAncestorsOrSelfMap.get(eClass);
        if (result == null) {
            result = this.loadAncestorsOrSelf(eClass);
            this.myAncestorsOrSelfMap.put(eClass, result);
        }
        return result;
    }

    private Set<EClass> loadAncestorsOrSelf(EClass eClass) {
        HashSet<EClass> result = new HashSet<EClass>();
        result.add(eClass);
        this.debugAdding(eClass, null);
        result.addAll(this.myRegistry.getSubTypes(eClass));
        this.debugAddingSubtypes(eClass);
        boolean scopeChanged = true;
        while (scopeChanged) {
            scopeChanged = false;
            for (EReference containment : this.myContainments) {
                EClass owner = containment.getEContainingClass();
                if (result.contains(owner) || !this.isCompatible(containment, result) || !result.add(owner)) continue;
                scopeChanged = true;
                this.debugAdding(owner, containment);
                result.addAll(this.myRegistry.getSubTypes(owner));
                this.debugAddingSubtypes(owner);
            }
        }
        return result;
    }

    private boolean isCompatible(EReference containment, Set<EClass> subtypesClosure) {
        if (containment.getEType() instanceof EClass) {
            EClass type = (EClass)containment.getEType();
            if (subtypesClosure.contains(type)) {
                return true;
            }
            Set<EClass> allSubtypesForType = this.myRegistry.getSubTypes(type);
            if (!allSubtypesForType.isEmpty()) {
                for (EClass next : subtypesClosure) {
                    if (!allSubtypesForType.contains(next)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void debugAdding(EClass owner, EReference containment) {
        if (DEBUG) {
            System.out.print("Adding: " + owner.getName());
            if (containment != null) {
                System.out.println(", due to: " + containment.getEContainingClass().getName() + "#" + containment.getName() + ":" + containment.getEType().getName());
            } else {
                System.out.println(", as root");
            }
        }
    }

    private void debugAddingSubtypes(EClass owner) {
        if (!DEBUG) {
            return;
        }
        Set<EClass> ownerSubtypes = this.myRegistry.getSubTypes(owner);
        if (!ownerSubtypes.isEmpty()) {
            System.out.println("\t processing subtypes: ");
            for (EClass subtype : ownerSubtypes) {
                System.out.println("\t Adding: subtype: " + subtype.getName());
            }
        }
    }

    private static class EPackageRegistry {
        private static EPackageRegistry UML_INSTANCE;
        private final Map<EClass, Set<EClass>> mySubTypesMap = new HashMap<EClass, Set<EClass>>();

        public EPackageRegistry(EPackage metamodel) {
            for (EClassifier next : metamodel.getEClassifiers()) {
                if (!(next instanceof EClass)) continue;
                this.registerSuperTypes((EClass)next);
            }
        }

        public Set<EClass> getSubTypes(EClass eClass) {
            Set<EClass> result = this.mySubTypesMap.get(eClass);
            return result == null ? Collections.emptySet() : result;
        }

        private void registerSuperTypes(EClass eClass) {
            for (EClass nextSuper : eClass.getEAllSuperTypes()) {
                if (nextSuper.getEPackage() != eClass.getEPackage()) continue;
                Set<EClass> registry = this.mySubTypesMap.get(nextSuper);
                if (registry == null) {
                    registry = new HashSet<EClass>();
                    this.mySubTypesMap.put(nextSuper, registry);
                }
                registry.add(eClass);
            }
        }

        public static EPackageRegistry getUML() {
            if (UML_INSTANCE == null) {
                UML_INSTANCE = new EPackageRegistry((EPackage)UMLPackage.eINSTANCE);
            }
            return UML_INSTANCE;
        }
    }
}

