/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.stereo;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.uml2.diagram.common.Messages;
import org.eclipse.uml2.diagram.common.stereo.ApplyProfileAction;
import org.eclipse.uml2.diagram.common.stereo.ProfileRegistry;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class ApplyProfileInfoAction
extends ApplyProfileAction {
    private ProfileRegistry.ProfileInfo myProfileInfo;

    public ApplyProfileInfoAction(IWorkbenchPage workbenchPage, Package package_, ProfileRegistry.ProfileInfo profileInfo) {
        super(workbenchPage, package_, null);
        this.myProfileInfo = profileInfo;
    }

    @Override
    protected String calculateText() {
        String name = this.myProfileInfo.name;
        return name != null ? name : EMPTY_NAME;
    }

    @Override
    protected boolean calculateChecked() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return !this.myProfileInfo.isBroken;
    }

    @Override
    protected ApplyProfileAction.ApplyProfileCommand getApplyProfileCommand(IEditCommandRequest request) {
        return new ApplyProfileInfoCommand(Messages.ApplyProfileAction_apply_profile_command, this.myPackage, this.myProfileInfo, request);
    }

    private class ApplyProfileInfoCommand
    extends ApplyProfileAction.ApplyProfileCommand {
        Package myPackage;
        private ProfileRegistry.ProfileInfo myProfileInfo;

        protected ApplyProfileInfoCommand(String label, Package package_, ProfileRegistry.ProfileInfo profileinfo, IEditCommandRequest request) {
            super(label, package_, null, request);
            this.myPackage = package_;
            this.myProfileInfo = profileinfo;
        }

        @Override
        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Profile profile = this.getProfile();
            if (profile == null) {
                return CommandResult.newErrorCommandResult((String)(String.valueOf(Messages.ApplyProfileInfoAction_command_result_could_note_load_profile) + this.myProfileInfo.uri));
            }
            this.myPackage.applyProfile(profile);
            return CommandResult.newOKCommandResult((Object)profile);
        }

        private Profile getProfile() {
            return this.myProfileInfo.getProfile(this.myPackage.eResource());
        }
    }
}

