/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.stereo;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.uml2.diagram.common.UMLCommonPlugin;
import org.eclipse.uml2.uml.Profile;

public class ProfileRegistry {
    private static ProfileRegistry myInstance;
    private final IPreferenceStore preferences = UMLCommonPlugin.getInstance().getPreferenceStore();
    private static final String ELEMENT_PROFILE_REGISTRY = "profileRegistry";
    private static final String ELEMENT_PROFILE = "profile";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_URI = "uri";
    private static final String ATTR_IS_BROKEN = "isBroken";

    private ProfileRegistry() {
    }

    public static ProfileRegistry getInstance() {
        if (myInstance == null) {
            myInstance = new ProfileRegistry();
        }
        return myInstance;
    }

    public List<ProfileInfo> getProfiles() {
        XMLMemento rootMemento = this.getRootMemento();
        if (rootMemento == null) {
            return Collections.emptyList();
        }
        ArrayList<ProfileInfo> result = new ArrayList<ProfileInfo>();
        IMemento[] iMementoArray = rootMemento.getChildren(ELEMENT_PROFILE);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento childMemento = iMementoArray[n2];
            ProfileInfo info = this.getProfileInfo(childMemento);
            if (info != null) {
                result.add(info);
            }
            ++n2;
        }
        return result;
    }

    public void addProfile(Profile profile) {
        XMLMemento rootMemento = this.getOrCreateRootMemento();
        IMemento memento = this.getMementoForProfile((IMemento)rootMemento, this.getKey(profile));
        if (memento != null) {
            this.storeProfileInMemento(profile, memento);
        }
        String str = this.getXMLString(rootMemento);
        this.saveInPreferences(str);
    }

    public String getPreferencesString(ProfileInfo ... profiles) {
        XMLMemento root = this.createRootMenu();
        if (profiles != null) {
            ProfileInfo[] profileInfoArray = profiles;
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                ProfileInfo profileInfo = profileInfoArray[n2];
                IMemento child = root.createChild(ELEMENT_PROFILE, profileInfo.uri);
                this.storeProfileInfoInMemento(profileInfo, child);
                ++n2;
            }
        }
        return this.getXMLString(root);
    }

    private void markAsBroken(ProfileInfo info) {
        XMLMemento rootMemento = this.getOrCreateRootMemento();
        this.markMementoAsBroken(this.getMementoForProfile((IMemento)rootMemento, info.uri));
        String str = this.getXMLString(rootMemento);
        this.saveInPreferences(str);
    }

    private String getXMLString(XMLMemento rootMemento) {
        StringWriter writer = new StringWriter();
        try {
            rootMemento.save((Writer)writer);
            return writer.toString();
        }
        catch (IOException e) {
            ProfileRegistry.logError("Couldn't save Profile to Registry ", e);
            return null;
        }
    }

    private IMemento getMementoForProfile(IMemento containerMemento, String profileKey) {
        IMemento child;
        IMemento[] childMementos;
        IMemento[] iMementoArray = childMementos = containerMemento.getChildren(ELEMENT_PROFILE);
        int n = childMementos.length;
        int n2 = 0;
        while (n2 < n) {
            child = iMementoArray[n2];
            if (profileKey.equals(child.getString(ATTR_URI))) {
                return child;
            }
            ++n2;
        }
        child = containerMemento.createChild(ELEMENT_PROFILE, profileKey);
        child.putString(ATTR_URI, profileKey);
        return child;
    }

    private XMLMemento getRootMemento() {
        String str = this.getRegistryFromPreferences();
        if (str == null || "".equals(str)) {
            return null;
        }
        try {
            XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)new StringReader(str));
            return rootMemento;
        }
        catch (WorkbenchException e) {
            ProfileRegistry.logError("Couldn't get ProfileRegistry ", e);
            return null;
        }
    }

    private XMLMemento getOrCreateRootMemento() {
        XMLMemento rootMemento = this.getRootMemento();
        if (rootMemento == null) {
            rootMemento = this.createRootMenu();
        }
        return rootMemento;
    }

    private XMLMemento createRootMenu() {
        return XMLMemento.createWriteRoot((String)ELEMENT_PROFILE_REGISTRY);
    }

    private void storeProfileInMemento(Profile profile, IMemento memento) {
        memento.putString(ATTR_URI, EcoreUtil.getURI((EObject)profile).toString());
        memento.putString(ATTR_NAME, profile.getName());
        memento.putBoolean(ATTR_IS_BROKEN, false);
    }

    private void storeProfileInfoInMemento(ProfileInfo profile, IMemento memento) {
        memento.putString(ATTR_URI, profile.uri);
        memento.putString(ATTR_NAME, profile.name);
        memento.putBoolean(ATTR_IS_BROKEN, profile.isBroken);
    }

    private void markMementoAsBroken(IMemento memento) {
        memento.putBoolean(ATTR_IS_BROKEN, true);
    }

    private ProfileInfo getProfileInfo(IMemento memento) {
        return new ProfileInfo(memento.getString(ATTR_URI), memento.getString(ATTR_NAME), memento.getBoolean(ATTR_IS_BROKEN));
    }

    private String getRegistryFromPreferences() {
        return this.preferences.getString(ELEMENT_PROFILE_REGISTRY);
    }

    private void saveInPreferences(String str) {
        this.preferences.setValue(ELEMENT_PROFILE_REGISTRY, str);
    }

    private String getKey(Profile profile) {
        return EcoreUtil.getURI((EObject)profile).toString();
    }

    private static void logError(String message, Throwable e) {
        UMLCommonPlugin.getInstance().getLog().log((IStatus)new Status(4, UMLCommonPlugin.getPluginId(), message, e));
    }

    private static void logWarning(String message, Throwable e) {
        UMLCommonPlugin.getInstance().getLog().log((IStatus)new Status(2, UMLCommonPlugin.getPluginId(), message, e));
    }

    public static class ProfileInfo {
        public final String uri;
        public final String name;
        public final boolean isBroken;

        private ProfileInfo(String uri, String name, boolean isBroken) {
            this.uri = uri;
            this.name = name;
            this.isBroken = isBroken;
        }

        public ProfileInfo(String uri, String name) {
            this.uri = uri;
            this.name = name;
            this.isBroken = false;
        }

        public final Profile getProfile(Resource resource) {
            try {
                return (Profile)resource.getResourceSet().getEObject(URI.createURI((String)this.uri), true);
            }
            catch (Exception e) {
                ProfileRegistry.getInstance().markAsBroken(this);
                ProfileRegistry.logWarning(NLS.bind((String)"Couldn't load {1} for URI {0}", (Object[])new Object[]{this.name, this.uri}), e);
                return null;
            }
        }
    }
}

