/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.stereo;

import java.util.ArrayList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.uml2.diagram.common.stereo.StereotypeImages;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class StereotypeOperationsEx
extends UMLUtil {
    public static Image getAppliedStereotypeImage(Element element) {
        return StereotypeOperationsEx.getAppliedStereotypeImage(element, null);
    }

    public static Image getAppliedStereotypeImage(Element element, ImageDescriptor metaclassImage) {
        if (element.getStereotypeApplications().isEmpty()) {
            return null;
        }
        ImageDescriptor[] result = StereotypeOperationsEx.getListOfAppliedStereotypeImages(element, metaclassImage);
        if (result.length == 0) {
            return null;
        }
        return new StereotypeImageDescriptor(result).createImage();
    }

    public static Image composeImages(ImageDescriptor ... images) {
        return new StereotypeImageDescriptor(images).createImage();
    }

    public static Image composeImages(ImageDescriptor last, ImageDescriptor ... images) {
        ImageDescriptor[] allImages = new ImageDescriptor[images.length + 1];
        System.arraycopy(images, 0, allImages, 0, images.length);
        allImages[allImages.length - 1] = last;
        return StereotypeOperationsEx.composeImages(allImages);
    }

    public static ImageDescriptor getImage(Stereotype stereo) {
        return StereotypeImages.getImageDescriptor(stereo, null);
    }

    public static ImageDescriptor getImage(Stereotype stereo, ImageDescriptor metaclassImage) {
        return StereotypeImages.getImageDescriptor(stereo, metaclassImage);
    }

    public static ImageDescriptor[] getListOfAppliedStereotypeImages(Element element, ImageDescriptor metaclassImage) {
        EList stereoApplications = element.getStereotypeApplications();
        ArrayList<ImageDescriptor> result = new ArrayList<ImageDescriptor>(stereoApplications.size());
        for (EObject stereoApplication : stereoApplications) {
            ImageDescriptor imageDescriptor = StereotypeImages.getImageDescriptorForStereotypeApplication(stereoApplication, metaclassImage);
            if (imageDescriptor == null) continue;
            result.add(imageDescriptor);
        }
        return result.toArray(new ImageDescriptor[result.size()]);
    }

    public static EList<Stereotype> getApplicableStereotypes(Package package_, EClassifier elementMetaclass) {
        if (package_ != null) {
            UniqueEList.FastCompare applicableStereotypes = new UniqueEList.FastCompare();
            for (ProfileApplication profileApplication : package_.getAllProfileApplications()) {
                Profile appliedProfile = profileApplication.getAppliedProfile();
                if (appliedProfile == null) continue;
                for (Stereotype stereotype : appliedProfile.getOwnedStereotypes()) {
                    ENamedElement appliedDefinition = profileApplication.getAppliedDefinition((NamedElement)stereotype);
                    if (!(appliedDefinition instanceof EClass) || ((EClass)appliedDefinition).isAbstract() || StereotypeOperationsEx.getExtension(elementMetaclass, stereotype) == null) continue;
                    applicableStereotypes.add((Object)stereotype);
                }
            }
            return ECollections.unmodifiableEList((EList)applicableStereotypes);
        }
        return ECollections.emptyEList();
    }

    protected static Extension getExtension(EClassifier elementMetaclass, Stereotype stereotype) {
        for (Property attribute : stereotype.getAllAttributes()) {
            EClassifier eClassifier;
            Type type;
            String name;
            Association association = attribute.getAssociation();
            if (!(association instanceof Extension) || StereotypeOperationsEx.isEmpty((String)(name = attribute.getName())) || !name.startsWith("base_") || !((type = attribute.getType()) instanceof Class) || (eClassifier = StereotypeOperationsEx.getEClassifier((Class)((Class)type))) == null || !((EClass)eClassifier).isSuperTypeOf((EClass)elementMetaclass)) continue;
            return (Extension)association;
        }
        return null;
    }

    private static class StereotypeImageDescriptor
    extends CompositeImageDescriptor {
        private ImageDescriptor[] myImages;

        private StereotypeImageDescriptor(ImageDescriptor ... images) {
            this.myImages = images;
        }

        protected void drawCompositeImage(int width, int height) {
            int ox = 0;
            int oy = 0;
            ImageDescriptor[] imageDescriptorArray = this.myImages;
            int n = this.myImages.length;
            int n2 = 0;
            while (n2 < n) {
                ImageDescriptor image = imageDescriptorArray[n2];
                ImageData imageData = image.getImageData();
                this.drawImage(imageData, ox, oy);
                ox += imageData.width;
                ++n2;
            }
        }

        protected Point getSize() {
            int ox = 0;
            int oy = 0;
            ImageDescriptor[] imageDescriptorArray = this.myImages;
            int n = this.myImages.length;
            int n2 = 0;
            while (n2 < n) {
                ImageDescriptor image = imageDescriptorArray[n2];
                ImageData imageData = image.getImageData();
                ox += imageData.width;
                oy = Math.max(oy, imageData.height);
                ++n2;
            }
            return new Point(ox, oy);
        }
    }
}

