/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.uml.OCL;
import org.eclipse.uml2.diagram.common.constraint.ConstraintUtils;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;

public class OCLFromStereoConstraint
extends AbstractModelConstraint {
    private final OCL myOCL = OCL.newInstance();

    public IStatus validate(IValidationContext ctx) {
        Element selected = (Element)ctx.getTarget();
        OCL.Helper oclHelper = this.myOCL.createOCLHelper();
        for (Stereotype stereo : selected.getApplicableStereotypes()) {
            oclHelper.setContext((Object)stereo);
            for (Constraint c : OCLFromStereoConstraint.getConstraints((EObject)stereo)) {
                try {
                    boolean success = this.runConstraintOn(oclHelper, selected, c);
                    if (success) continue;
                    String name = selected instanceof NamedElement ? ((NamedElement)selected).getName() : "";
                    return ctx.createFailureStatus(new Object[]{name, stereo.getName(), c.getName()});
                }
                catch (ParserException e) {
                    e.printStackTrace();
                }
            }
        }
        return ctx.createSuccessStatus();
    }

    private boolean runConstraintOn(OCL.Helper oclHelper, Element selected, Constraint umlConstraint) throws ParserException {
        String body = ConstraintUtils.getOCLConstraintBody(umlConstraint);
        if (body == null) {
            return true;
        }
        Constraint constraint = (Constraint)oclHelper.createInvariant(body);
        return this.myOCL.check((Object)selected, (Object)constraint);
    }

    private static final List<Constraint> getConstraints(EObject stereotype) {
        LinkedList<Constraint> result = new LinkedList<Constraint>();
        for (EObject next : OCLFromStereoConstraint.getReferencingObjects(stereotype)) {
            if (!OCLFromStereoConstraint.isConstraintFor(next, stereotype)) continue;
            result.add((Constraint)next);
        }
        return result;
    }

    private static boolean isConstraintFor(EObject constraint, EObject constrainedElement) {
        return constraint instanceof Constraint && ((Constraint)constraint).getConstrainedElements().contains((Object)constrainedElement);
    }

    private static final List<EObject> getReferencingObjects(EObject target) {
        LinkedList<EObject> result = new LinkedList<EObject>();
        Collection settings = (Collection)EcoreUtil.CrossReferencer.find((Collection)target.eResource().getContents()).get(target);
        if (settings == null) {
            return Collections.emptyList();
        }
        for (EStructuralFeature.Setting setting : settings) {
            result.add(setting.getEObject());
        }
        return result;
    }
}

