/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.anchor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.uml2.diagram.sequence.anchor.AnchorProcessorInput;
import org.eclipse.uml2.diagram.sequence.anchor.ConstraintsProcessor;
import org.eclipse.uml2.diagram.sequence.anchor.EvaluatingException;
import org.eclipse.uml2.diagram.sequence.anchor.LifelineElementTraceable;
import org.eclipse.uml2.diagram.sequence.anchor.LifelineSatisfyCondition;
import org.eclipse.uml2.diagram.sequence.anchor.PasteRange;
import org.eclipse.uml2.diagram.sequence.anchor.UnknownElementException;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineElement;
import org.eclipse.uml2.diagram.sequence.model.edit.SDAnchor;

public class AnchorResolver {
    public ArrayList<PasteRange> getPasteRanges(AnchorProcessorInput anchorProcessorInputImpl, SDAnchor initialCreateTarget) throws EvaluatingException, UnknownElementException {
        return this.getPasteRanges(anchorProcessorInputImpl, Collections.singletonList(initialCreateTarget));
    }

    public ArrayList<PasteRange> getPasteRanges(AnchorProcessorInput anchorProcessorInputImpl, List<SDAnchor> controlCreateTargets) throws UnknownElementException, EvaluatingException {
        List<LifeLine> lifeLinesList = anchorProcessorInputImpl.lifeLinesList();
        LifeLine[] lifeLinesArray = new LifeLine[lifeLinesList.size()];
        lifeLinesList.toArray(lifeLinesArray);
        ConstraintsProcessor constraintsProcessor = new ConstraintsProcessor(lifeLinesArray);
        ArrayList<LifeLineElement> controlElementList = new ArrayList<LifeLineElement>(controlCreateTargets.size());
        for (SDAnchor createTarget : controlCreateTargets) {
            controlElementList.add(anchorProcessorInputImpl.getLifeLineElementBeforePoint(createTarget));
        }
        ConstraintsProcessor.MultipleElementsProcessor multipleElementsProcessor = new ConstraintsProcessor.MultipleElementsProcessor(constraintsProcessor, controlElementList);
        multipleElementsProcessor.processTo();
        ArrayList<LifeLineElement> pasteRangeUpper = new ArrayList<LifeLineElement>(constraintsProcessor.getCurrentState());
        multipleElementsProcessor.processHolding();
        ArrayList<LifeLineElement> pasteRangeLower = new ArrayList<LifeLineElement>(constraintsProcessor.getCurrentState());
        ArrayList<PasteRange> result = new ArrayList<PasteRange>(pasteRangeUpper.size());
        LifelineElementTraceable[] creationTops = anchorProcessorInputImpl.getLifelineCreationTops();
        LifelineElementTraceable[] destructionBottoms = anchorProcessorInputImpl.getLifelineDestructionBottoms();
        int i = 0;
        while (i < pasteRangeUpper.size()) {
            LifelineElementTraceable rangeUpperElement = (LifelineElementTraceable)pasteRangeUpper.get(i);
            LifelineElementTraceable rangeLowerElement = (LifelineElementTraceable)pasteRangeLower.get(i);
            if (creationTops[i] != null && rangeUpperElement.getNumber() < creationTops[i].getNumber()) {
                rangeUpperElement = creationTops[i];
            }
            if (destructionBottoms[i] != null && destructionBottoms[i].getNumber() <= rangeLowerElement.getNumber()) {
                rangeLowerElement = destructionBottoms[i];
            }
            if (rangeUpperElement.getNumber() > rangeLowerElement.getNumber()) {
                rangeUpperElement = rangeLowerElement;
            }
            PasteRange pasteRange = new PasteRange(rangeUpperElement, rangeLowerElement, anchorProcessorInputImpl);
            result.add(pasteRange);
            ++i;
        }
        return result;
    }

    public GetCreateTargetsResult getCreateTargets(AnchorProcessorInput anchorProcessorInputImpl, List<SDAnchor> controlCreateTargets, LifelineSatisfyCondition[] lifelineSatisfyConditions) throws UnknownElementException, EvaluatingException {
        List<LifeLine> lifeLinesList = anchorProcessorInputImpl.lifeLinesList();
        LifeLine[] lifeLinesArray = new LifeLine[lifeLinesList.size()];
        lifeLinesList.toArray(lifeLinesArray);
        ConstraintsProcessor constraintsProcessor = new ConstraintsProcessor(lifeLinesArray);
        ArrayList<LifeLineElement> controlElementList = new ArrayList<LifeLineElement>(controlCreateTargets.size());
        for (SDAnchor createTarget : controlCreateTargets) {
            controlElementList.add(anchorProcessorInputImpl.getLifeLineElementBeforePoint(createTarget));
        }
        ConstraintsProcessor.MultipleElementsProcessor multipleElementsProcessor = new ConstraintsProcessor.MultipleElementsProcessor(constraintsProcessor, controlElementList);
        ConstraintsProcessor constraintsProcessor2 = constraintsProcessor;
        constraintsProcessor2.getClass();
        ConstraintsProcessor.SatisfyCondition satisfyCondition = new ConstraintsProcessor.SatisfyCondition(constraintsProcessor2, lifelineSatisfyConditions);
        multipleElementsProcessor.processTo(satisfyCondition);
        ArrayList<SDAnchor> result = new ArrayList<SDAnchor>(lifeLinesArray.length);
        int i = 0;
        while (i < lifeLinesArray.length) {
            LifeLineElement lifeLineElement = constraintsProcessor.getCurrentState().get(i);
            SDAnchor createTarget = anchorProcessorInputImpl.getCreateTargetAfterPoint(lifeLineElement);
            result.add(createTarget);
            ++i;
        }
        return new GetCreateTargetsResult(anchorProcessorInputImpl, constraintsProcessor, result);
    }

    private ArrayList<SDAnchor> getAsynchTargets(AnchorProcessorInput anchorProcessorInputImpl, ConstraintsProcessor constraintsProcessor, LifelineSatisfyCondition[] lifelineSatisfyConditions) throws UnknownElementException, EvaluatingException {
        ConstraintsProcessor constraintsProcessor2 = constraintsProcessor;
        constraintsProcessor2.getClass();
        ConstraintsProcessor.SatisfyCondition satisfyCondition = new ConstraintsProcessor.SatisfyCondition(constraintsProcessor2, lifelineSatisfyConditions);
        ConstraintsProcessor.MultipleElementsProcessor multipleElementsProcessor = new ConstraintsProcessor.MultipleElementsProcessor(constraintsProcessor, Collections.<LifeLineElement>emptyList());
        multipleElementsProcessor.processTo(satisfyCondition);
        int size = constraintsProcessor.getCurrentState().size();
        ArrayList<SDAnchor> result = new ArrayList<SDAnchor>(size);
        int i = 0;
        while (i < size) {
            LifeLineElement lifeLineElement = constraintsProcessor.getCurrentState().get(i);
            SDAnchor createTarget = anchorProcessorInputImpl.getCreateTargetAfterPoint(lifeLineElement);
            result.add(createTarget);
            ++i;
        }
        return result;
    }

    public class GetCreateTargetsResult {
        private final ConstraintsProcessor myConstraintsProcessor;
        private final ArrayList<SDAnchor> myCreateTargetsList;
        private final AnchorProcessorInput myAnchorProcessorInputImpl;

        private GetCreateTargetsResult(AnchorProcessorInput anchorProcessorInputImpl, ConstraintsProcessor constraintsProcessor, ArrayList<SDAnchor> createTargetsList) {
            this.myAnchorProcessorInputImpl = anchorProcessorInputImpl;
            this.myConstraintsProcessor = constraintsProcessor;
            this.myCreateTargetsList = createTargetsList;
        }

        public ArrayList<SDAnchor> getCreateTargetsList() {
            return this.myCreateTargetsList;
        }

        public ArrayList<SDAnchor> calculateAsynchTargets(LifelineSatisfyCondition[] satisfyingContainers) throws UnknownElementException, EvaluatingException {
            return AnchorResolver.this.getAsynchTargets(this.myAnchorProcessorInputImpl, this.myConstraintsProcessor, satisfyingContainers);
        }
    }
}

