/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.anchor;

import org.eclipse.osgi.util.NLS;
import org.eclipse.uml2.diagram.sequence.anchor.LifelineElementTraceable;
import org.eclipse.uml2.diagram.sequence.anchor.LifelineSatisfyCondition;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLine;

public class CompositeLifelineSatisfyCondition
implements LifelineSatisfyCondition {
    private final LifelineSatisfyCondition myFirstCondition;
    private final LifelineSatisfyCondition mySecondCondition;

    public CompositeLifelineSatisfyCondition(LifelineSatisfyCondition firstCondition, LifelineSatisfyCondition secondCondition) {
        this.myFirstCondition = firstCondition;
        this.mySecondCondition = secondCondition;
        if (this.myFirstCondition.getLifeline() != this.mySecondCondition.getLifeline()) {
            throw new IllegalArgumentException("Incompatible lifelines");
        }
    }

    @Override
    public boolean isSatisfied(LifelineElementTraceable elementTraceable) {
        return this.myFirstCondition.isSatisfied(elementTraceable) && this.mySecondCondition.isSatisfied(elementTraceable);
    }

    @Override
    public LifeLine getLifeline() {
        return this.myFirstCondition.getLifeline();
    }

    public String toString() {
        return NLS.bind((String)"Comp: {0} + {1}", (Object[])new Object[]{this.myFirstCondition, this.mySecondCondition});
    }

    public static LifelineSatisfyCondition add(LifelineSatisfyCondition first, LifelineSatisfyCondition second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return new CompositeLifelineSatisfyCondition(first, second);
    }

    public static LifelineSatisfyCondition[] add(LifelineSatisfyCondition[] first, LifelineSatisfyCondition[] second) {
        if (first.length != second.length) {
            throw new IllegalArgumentException();
        }
        LifelineSatisfyCondition[] result = new LifelineSatisfyCondition[first.length];
        int i = 0;
        while (i < first.length) {
            result[i] = CompositeLifelineSatisfyCondition.add(first[i], second[i]);
            ++i;
        }
        return result;
    }
}

