/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.anchor;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.uml2.diagram.sequence.anchor.CannotAlignElementsException;
import org.eclipse.uml2.diagram.sequence.anchor.EvaluatingException;
import org.eclipse.uml2.diagram.sequence.anchor.LifelineElementTraceable;
import org.eclipse.uml2.diagram.sequence.anchor.LifelineSatisfyCondition;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineIterator;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.OrderingConstraint;

class ConstraintsProcessor {
    private static final boolean loggable = false;
    private final Map<LifeLine, LifelineData> myLifeLine2lifeLineData = new HashMap<LifeLine, LifelineData>();
    private final List<LifelineData> myLifelineDataList;
    private final List<LifeLineElement> myCurrentState;

    ConstraintsProcessor(final LifeLine[] lifeLines) {
        this.myLifelineDataList = new ArrayList<LifelineData>(lifeLines.length);
        int i = 0;
        while (i < lifeLines.length) {
            LifelineData lifeLineData = new LifelineData(lifeLines[i]);
            this.myLifeLine2lifeLineData.put(lifeLines[i], lifeLineData);
            this.myLifelineDataList.add(lifeLineData);
            ++i;
        }
        this.myCurrentState = new AbstractList<LifeLineElement>(){

            @Override
            public LifeLineElement get(int pos) {
                LifelineData lifeLineData = (LifelineData)ConstraintsProcessor.this.myLifelineDataList.get(pos);
                return lifeLineData.getCurrentElement();
            }

            @Override
            public int size() {
                return lifeLines.length;
            }
        };
        new ArrayList<LifeLineElement>(this.myCurrentState);
    }

    private void processLifeLines(ProcessingDriver processingDriver) throws EvaluatingException {
        ProcessingDriver.Todo todo;
        ProcessLifeLineSession processLifeLineSession = new ProcessLifeLineSession();
        while ((todo = processingDriver.chooseTodo()) != null) {
            LifelineData lifeLineData = todo.getLifeLineData();
            StopSignal stopSignal = processLifeLineSession.processLifeLine(processingDriver, lifeLineData, null);
            todo.saveProcessingResult(stopSignal);
        }
    }

    List<LifeLineElement> getCurrentState() {
        return this.myCurrentState;
    }

    private LifelineData getLifeLineData(LifeLine lifeLine) {
        LifelineData result = this.myLifeLine2lifeLineData.get(lifeLine);
        if (result == null) {
            throw new RuntimeException(NLS.bind((String)"Cannot find lifeline data for {0}", (Object[])new Object[]{lifeLine}));
        }
        return result;
    }

    private static class LifelineData {
        private final LifeLine myLifeLine;
        private final LifeLineIterator myLifeLineIterator;
        private final Set<OrderingConstraint> myFoundAfterConstraintSet = new HashSet<OrderingConstraint>(5);
        private LifeLineElement myCurrentElement;

        LifelineData(LifeLine lifeLine) {
            this.myLifeLine = lifeLine;
            this.myLifeLineIterator = lifeLine.iterator();
        }

        LifeLineElement getCurrentElement() {
            return this.myCurrentElement;
        }

        LifeLineElement nextElement() {
            this.myCurrentElement = this.myLifeLineIterator.nextElement();
            return this.myCurrentElement;
        }

        boolean hasNext() {
            return this.myLifeLineIterator.hasNext();
        }

        LifeLine getLifeLine() {
            return this.myLifeLine;
        }

        public String toString() {
            return "LLData:" + this.myLifeLine;
        }

        Set<OrderingConstraint> getFoundAfterConstraintSet() {
            return this.myFoundAfterConstraintSet;
        }
    }

    static class MultipleElementsProcessor {
        private final Set<LifeLineElement> myUnreachedLifelineElements;
        private final Set<LifeLineElement> myLifelineElements;
        private final Set<LifelineData> myMovableLifelineDatas;
        private final ConstraintsProcessor myConstraintsProcessor;
        private static final StopSignal OTHER_LIFELINE_FIXED_SIGNAL = new SingleInstanceStopSignal("OTHER_LIFELINE_FIXED_SIGNAL");
        private static final StopSignal ELEMENT_REACHED_SIGNAL = new SingleInstanceStopSignal("ELEMENT_REACHED_SIGNAL");

        MultipleElementsProcessor(ConstraintsProcessor constraintsProcessor, Collection<LifeLineElement> controlLifelineElementList) {
            this.myConstraintsProcessor = constraintsProcessor;
            this.myLifelineElements = new HashSet<LifeLineElement>(controlLifelineElementList.size());
            this.myMovableLifelineDatas = new HashSet(this.myConstraintsProcessor.myLifeLine2lifeLineData.values());
            HashSet<LifeLine> constraintedLifelines = new HashSet<LifeLine>(controlLifelineElementList.size());
            for (LifeLineElement lifeLineElement : controlLifelineElementList) {
                this.myLifelineElements.add(lifeLineElement);
                boolean res = constraintedLifelines.add(lifeLineElement.getLifeLine());
                if (res) continue;
                throw new RuntimeException(NLS.bind((String)"Lifeline is constrained twice: {0}", (Object[])new Object[]{lifeLineElement.getLifeLine()}));
            }
            this.myUnreachedLifelineElements = new HashSet<LifeLineElement>(this.myLifelineElements);
        }

        void processTo() throws EvaluatingException {
            ProcessToDriver processingDriver = new ProcessToDriver();
            this.myConstraintsProcessor.processLifeLines(processingDriver);
        }

        void processHolding() throws EvaluatingException {
            ProcessHoldingDriver processingDriver = new ProcessHoldingDriver();
            this.myConstraintsProcessor.processLifeLines(processingDriver);
            for (LifeLineElement element : this.myLifelineElements) {
                LifelineData data = this.myConstraintsProcessor.getLifeLineData(element.getLifeLine());
                data.nextElement();
            }
        }

        void processTo(SatisfyCondition satisfyCondition) throws EvaluatingException {
            ProcessToDriver processingDriver = new ProcessToDriver();
            this.myConstraintsProcessor.processLifeLines(processingDriver);
            ProcessSatisfyingDriver processSatisfyingDriver = new ProcessSatisfyingDriver(satisfyCondition);
            this.myConstraintsProcessor.processLifeLines(processSatisfyingDriver);
        }

        private abstract class DriverBase
        implements ProcessingDriver {
            private LifeLine myActiveLifeline;

            private DriverBase() {
            }

            @Override
            public StopSignal shouldResolveConstraintForElement(LifeLineElement constraintedElement, LifelineData initialLifeLineData) {
                LifelineData data = MultipleElementsProcessor.this.myConstraintsProcessor.getLifeLineData(constraintedElement.getLifeLine());
                if (MultipleElementsProcessor.this.myMovableLifelineDatas.contains(data)) {
                    return null;
                }
                return OTHER_LIFELINE_FIXED_SIGNAL;
            }

            @Override
            public StopSignal shouldProcessAfterElement(LifeLineElement element) {
                if (MultipleElementsProcessor.this.myLifelineElements.contains(element)) {
                    LifeLine lifeline = element.getLifeLine();
                    if (lifeline == this.myActiveLifeline) {
                        return ELEMENT_REACHED_SIGNAL;
                    }
                    return OTHER_LIFELINE_FIXED_SIGNAL;
                }
                return null;
            }

            @Override
            public void elementFound(LifeLineElement element, LifelineData lifeLineData) {
                boolean res = MultipleElementsProcessor.this.myUnreachedLifelineElements.remove(element);
                if (res) {
                    MultipleElementsProcessor.this.myMovableLifelineDatas.remove(lifeLineData);
                }
            }

            protected void setActiveLifeline(LifeLine activeLifeline) {
                this.myActiveLifeline = activeLifeline;
            }
        }

        private class ProcessHoldingDriver
        extends DriverBase {
            private ProcessHoldingDriver() {
            }

            @Override
            public void lifeLineFinished(LifelineData lifeLineData) throws EvaluatingException {
            }

            @Override
            public void lifelineStopped(LifelineData lifelineData, StopSignal stopSignal) {
                MultipleElementsProcessor.this.myMovableLifelineDatas.remove(lifelineData);
            }

            @Override
            public ProcessingDriver.Todo chooseTodo() {
                if (MultipleElementsProcessor.this.myMovableLifelineDatas.isEmpty()) {
                    return null;
                }
                final LifelineData lifeLineData = (LifelineData)MultipleElementsProcessor.this.myMovableLifelineDatas.iterator().next();
                this.setActiveLifeline(lifeLineData.getLifeLine());
                return new ProcessingDriver.Todo(){

                    @Override
                    public LifelineData getLifeLineData() {
                        return lifeLineData;
                    }

                    @Override
                    public void saveProcessingResult(StopSignal stopSignal) {
                        ProcessHoldingDriver.this.setActiveLifeline(null);
                    }
                };
            }
        }

        private class ProcessSatisfyingDriver
        extends DriverBase {
            private final SatisfyCondition mySatisfyCondition;
            private LifelineData myUnsatisfiedLifelineData;

            ProcessSatisfyingDriver(SatisfyCondition satisfyCondition) {
                this.mySatisfyCondition = satisfyCondition;
            }

            @Override
            public void lifeLineFinished(LifelineData lifeLineData) throws EvaluatingException {
                throw new EvaluatingException(NLS.bind((String)"Failed to find good location on lifeline {0}", (Object[])new Object[]{lifeLineData}));
            }

            @Override
            public void lifelineStopped(LifelineData lifelineData, StopSignal stopSignal) {
            }

            @Override
            public StopSignal shouldProcessAfterElement(LifeLineElement element) {
                StopSignal superResult = super.shouldProcessAfterElement(element);
                if (superResult != null) {
                    return superResult;
                }
                if (element.getLifeLine() == this.myUnsatisfiedLifelineData.getLifeLine()) {
                    return ELEMENT_REACHED_SIGNAL;
                }
                return null;
            }

            @Override
            public ProcessingDriver.Todo chooseTodo() throws EvaluatingException {
                int unsatisfiedLifelineIndex = this.mySatisfyCondition.whichLifelineStepDown();
                if (unsatisfiedLifelineIndex == -1) {
                    return null;
                }
                LifelineData unsatisfiedLifelineData = (LifelineData)MultipleElementsProcessor.this.myConstraintsProcessor.myLifelineDataList.get(unsatisfiedLifelineIndex);
                if (!MultipleElementsProcessor.this.myMovableLifelineDatas.contains(unsatisfiedLifelineData)) {
                    throw new EvaluatingException(NLS.bind((String)"Lifeline condition is not satisfied for {0}, but lifeline is locked by control element", (Object[])new Object[]{unsatisfiedLifelineData}));
                }
                this.myUnsatisfiedLifelineData = unsatisfiedLifelineData;
                return new ProcessingDriver.Todo(){

                    @Override
                    public LifelineData getLifeLineData() {
                        return ProcessSatisfyingDriver.this.myUnsatisfiedLifelineData;
                    }

                    @Override
                    public void saveProcessingResult(StopSignal stopSignal) throws EvaluatingException {
                        try {
                            if (stopSignal == OTHER_LIFELINE_FIXED_SIGNAL) {
                                throw new EvaluatingException(NLS.bind((String)"Failed to find good location on lifeline {0}", (Object[])new Object[]{ProcessSatisfyingDriver.this.myUnsatisfiedLifelineData}));
                            }
                        }
                        finally {
                            ProcessSatisfyingDriver.this.myUnsatisfiedLifelineData = null;
                        }
                    }
                };
            }
        }

        private class ProcessToDriver
        extends DriverBase {
            private ProcessToDriver() {
            }

            @Override
            public void lifeLineFinished(LifelineData lifeLineData) throws EvaluatingException {
                throw new EvaluatingException(NLS.bind((String)"Failed to find required element on lifeline {0}", (Object[])new Object[]{lifeLineData}));
            }

            @Override
            public void lifelineStopped(LifelineData lifelineData, StopSignal stopSignal) {
            }

            @Override
            public ProcessingDriver.Todo chooseTodo() {
                if (MultipleElementsProcessor.this.myUnreachedLifelineElements.isEmpty()) {
                    return null;
                }
                LifeLineElement nextAnchorElement = (LifeLineElement)MultipleElementsProcessor.this.myUnreachedLifelineElements.iterator().next();
                final LifelineData lifeLineData = MultipleElementsProcessor.this.myConstraintsProcessor.getLifeLineData(nextAnchorElement.getLifeLine());
                this.setActiveLifeline(lifeLineData.getLifeLine());
                return new ProcessingDriver.Todo(){

                    @Override
                    public LifelineData getLifeLineData() {
                        return lifeLineData;
                    }

                    @Override
                    public void saveProcessingResult(StopSignal stopSignal) throws CannotAlignElementsException {
                        if (stopSignal == OTHER_LIFELINE_FIXED_SIGNAL) {
                            throw new CannotAlignElementsException("Failed to keep all control points aligned");
                        }
                        ProcessToDriver.this.setActiveLifeline(null);
                    }
                };
            }
        }
    }

    private class ProcessLifeLineSession {
        private final Set<LifelineData> myLockedLifeLineDatas = new HashSet<LifelineData>();

        private ProcessLifeLineSession() {
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public StopSignal processLifeLine(ProcessingDriver processingDriver, LifelineData lifeLineData, Object requiredConstraint) throws EvaluatingException {
            if (!this.isLocked(lifeLineData)) ** GOTO lbl84
            throw new EvaluatingException("Lifeline is blocked; probably because of cyclic dependencies in constraints");
lbl-1000:
            // 1 sources

            {
                element = lifeLineData.nextElement();
                processingDriver.elementFound(element, lifeLineData);
                requiredOrderingConstraintFound = false;
                orderingConstraintEnum = element.afterConstraints();
                while (orderingConstraintEnum.hasMoreElements()) {
                    orderingConstraint = orderingConstraintEnum.nextElement();
                    if (orderingConstraint == requiredConstraint) {
                        requiredOrderingConstraintFound = true;
                        continue;
                    }
                    lifeLineData.getFoundAfterConstraintSet().add(orderingConstraint);
                }
                if (requiredOrderingConstraintFound) {
                    // empty if block
                }
                this.setLocked(lifeLineData, true);
                doNotUnlock = false;
                try {
                    stopSignal = null;
                    orderingConstraintEnum = element.beforeConstraints();
                    while (orderingConstraintEnum.hasMoreElements()) {
                        orderingConstraint = orderingConstraintEnum.nextElement();
                        constraintedElement = orderingConstraint.getBeforeElement();
                        otherLifeLine = constraintedElement.getLifeLine();
                        if (otherLifeLine == lifeLineData.getLifeLine()) {
                            res = lifeLineData.getFoundAfterConstraintSet().remove(orderingConstraint);
                            if (res) continue;
                            throw new EvaluatingException("Cannot find 'before' element of one-lifeline ordering constraint");
                        }
                        otherLifeLineData = ConstraintsProcessor.access$1(ConstraintsProcessor.this, otherLifeLine);
                        res = otherLifeLineData.getFoundAfterConstraintSet().remove(orderingConstraint);
                        if (res) continue;
                        subSignal = processingDriver.shouldResolveConstraintForElement(constraintedElement, lifeLineData);
                        if (subSignal != null) {
                            stopSignal = subSignal.addAnother(stopSignal);
                            continue;
                        }
                        subSignal = this.processLifeLine(processingDriver, otherLifeLineData, orderingConstraint);
                        if (subSignal == null) continue;
                        stopSignal = subSignal.addAnother(stopSignal);
                    }
                    horizontalConstraint = element.getHorizontalConstraint();
                    if (horizontalConstraint != null) {
                        if (horizontalConstraint == requiredConstraint) {
                            return null;
                        }
                        processedFreeLifelineDatas = new ArrayList<LifelineData>(3);
                        for (LifeLineElement constraintedElement : horizontalConstraint.getLifeLineElementsList()) {
                            if (element == constraintedElement) continue;
                            otherLifeLineData = ConstraintsProcessor.access$1(ConstraintsProcessor.this, constraintedElement.getLifeLine());
                            subSignal = processingDriver.shouldResolveConstraintForElement(constraintedElement, lifeLineData);
                            if (subSignal != null) {
                                stopSignal = subSignal.addAnother(stopSignal);
                                continue;
                            }
                            subSignal = this.processLifeLine(processingDriver, otherLifeLineData, horizontalConstraint);
                            if (subSignal != null) {
                                stopSignal = subSignal.addAnother(stopSignal);
                                continue;
                            }
                            processedFreeLifelineDatas.add(otherLifeLineData);
                        }
                        if (stopSignal != null) {
                            i = 0;
                            while (i < processedFreeLifelineDatas.size()) {
                                freeLifeLineData = (LifelineData)processedFreeLifelineDatas.get(i);
                                processingDriver.lifelineStopped(freeLifeLineData, stopSignal);
                                ++i;
                            }
                        }
                    }
                    if (stopSignal != null) {
                        doNotUnlock = true;
                        processingDriver.lifelineStopped(lifeLineData, stopSignal);
                        var16_20 = stopSignal;
                        return var16_20;
                    }
                    if (requiredOrderingConstraintFound) {
                        return null;
                    }
                }
                finally {
                    if (!doNotUnlock) {
                        this.setLocked(lifeLineData, false);
                    }
                }
                stopSignal = processingDriver.shouldProcessAfterElement(element);
                if (stopSignal == null) continue;
                return stopSignal;
lbl84:
                // 2 sources

                ** while (lifeLineData.hasNext())
            }
lbl85:
            // 1 sources

            processingDriver.lifeLineFinished(lifeLineData);
            return null;
        }

        private void setLocked(LifelineData lifeLineData, boolean lock) {
            if (lock) {
                if (!this.myLockedLifeLineDatas.add(lifeLineData)) {
                    throw new RuntimeException("LifeLineData is already locked");
                }
            } else {
                this.myLockedLifeLineDatas.remove(lifeLineData);
            }
        }

        private boolean isLocked(LifelineData lifeLineData) {
            return this.myLockedLifeLineDatas.contains(lifeLineData);
        }
    }

    private static interface ProcessingDriver {
        public StopSignal shouldResolveConstraintForElement(LifeLineElement var1, LifelineData var2);

        public StopSignal shouldProcessAfterElement(LifeLineElement var1);

        public void lifelineStopped(LifelineData var1, StopSignal var2);

        public void lifeLineFinished(LifelineData var1) throws EvaluatingException;

        public Todo chooseTodo() throws EvaluatingException;

        public void elementFound(LifeLineElement var1, LifelineData var2);

        public static interface Todo {
            public LifelineData getLifeLineData();

            public void saveProcessingResult(StopSignal var1) throws EvaluatingException;
        }
    }

    class SatisfyCondition {
        private int myLastCheckedMemory = -1;
        private final LifelineSatisfyCondition[] myLifelineSatisfyConditions;

        SatisfyCondition(LifelineSatisfyCondition[] lifelineSatisfyConitions) {
            this.myLifelineSatisfyConditions = lifelineSatisfyConitions;
            int i = 0;
            while (i < lifelineSatisfyConitions.length) {
                LifelineData data;
                if (lifelineSatisfyConitions[i] != null && (data = (LifelineData)ConstraintsProcessor.this.myLifelineDataList.get(i)).getLifeLine() != lifelineSatisfyConitions[i].getLifeline()) {
                    throw new IllegalArgumentException("Wrong Lifeline of satisfy condition");
                }
                ++i;
            }
        }

        int whichLifelineStepDown() {
            if (this.myLastCheckedMemory != -1 && !this.checkLifelineSatisfying(this.myLastCheckedMemory)) {
                return this.myLastCheckedMemory;
            }
            int i = 0;
            while (i < this.myLifelineSatisfyConditions.length) {
                if (!this.checkLifelineSatisfying(i)) {
                    this.myLastCheckedMemory = i;
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public String toString() {
            return NLS.bind((String)"SatisfyCondition for {0}", (Object[])new Object[]{Arrays.asList(this.myLifelineSatisfyConditions)});
        }

        private boolean checkLifelineSatisfying(int index) {
            LifelineSatisfyCondition lifelineCondition = this.myLifelineSatisfyConditions[index];
            if (lifelineCondition == null) {
                return true;
            }
            LifelineElementTraceable traceableElement = (LifelineElementTraceable)ConstraintsProcessor.this.getCurrentState().get(index);
            if (traceableElement == null) {
                return false;
            }
            boolean res = lifelineCondition.isSatisfied(traceableElement);
            return res;
        }
    }

    private static class SingleInstanceStopSignal
    implements StopSignal {
        private final String myTag;

        SingleInstanceStopSignal(String tag) {
            this.myTag = tag;
        }

        @Override
        public StopSignal addAnother(StopSignal stopSignal) {
            if (stopSignal != null && stopSignal != this) {
                throw new RuntimeException("Inconsistent stop signal");
            }
            return this;
        }

        public String toString() {
            return this.myTag;
        }
    }

    private static interface StopSignal {
        public StopSignal addAnother(StopSignal var1);
    }

    static class UnsatisfiedDependencyException
    extends EvaluatingException {
        private static final long serialVersionUID = 1L;

        protected UnsatisfiedDependencyException() {
        }

        protected UnsatisfiedDependencyException(String message) {
            super(message);
        }

        protected UnsatisfiedDependencyException(String message, Throwable cause) {
            super(message, cause);
        }

        protected UnsatisfiedDependencyException(Throwable cause) {
            super(cause);
        }
    }
}

