/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.anchor;

import org.eclipse.uml2.diagram.sequence.anchor.AnchorProcessorInput;
import org.eclipse.uml2.diagram.sequence.anchor.LifelineElementTraceable;
import org.eclipse.uml2.diagram.sequence.anchor.LifelineSatisfyCondition;
import org.eclipse.uml2.diagram.sequence.anchor.SDModelUtil;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLine;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDLifeLine;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDLifeLineElement;

public class InEntityNeighbourhoodSatisfyCondition
implements LifelineSatisfyCondition {
    private final SDLifeLineElement myLifeLineElement;
    private final LifeLine myLifeLine;
    private final boolean myIsBeforeOk;
    private final boolean myIsInsideOk;
    private final boolean myIsAfterOk;

    public InEntityNeighbourhoodSatisfyCondition(SDLifeLineElement entity, AnchorProcessorInput anchorProcessorInput, boolean isBeforeOk, boolean isInsideOk, boolean isAfterOk) throws SDModelUtil.AlienElementException {
        this.myLifeLineElement = entity;
        SDLifeLine lifelineEntity = SDModelUtil.findEnclosingLifeline2(this.myLifeLineElement);
        int lifelinePos = anchorProcessorInput.getLifelineIndex(lifelineEntity);
        this.myLifeLine = anchorProcessorInput.lifeLinesList().get(lifelinePos);
        this.myIsBeforeOk = isBeforeOk;
        this.myIsInsideOk = isInsideOk;
        this.myIsAfterOk = isAfterOk;
    }

    @Override
    public boolean isSatisfied(LifelineElementTraceable elementTraceable) {
        if (this.myIsInsideOk && this.myLifeLineElement == elementTraceable.getEntityAfterElement()) {
            return true;
        }
        if (this.myIsAfterOk && !elementTraceable.isTopNotBottom() && elementTraceable.getPreviousElement().getEntityAfterElement() == this.myLifeLineElement) {
            return true;
        }
        LifelineElementTraceable nextTraceable = elementTraceable.getNextElement();
        return this.myIsBeforeOk && nextTraceable != null && nextTraceable.isTopNotBottom() && nextTraceable.getEntityAfterElement() == this.myLifeLineElement;
    }

    @Override
    public LifeLine getLifeline() {
        return this.myLifeLine;
    }

    public String toString() {
        return "InEntityNeighboudhoodSatisfyCondition for " + this.myLifeLineElement;
    }
}

