/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.anchor;

import org.eclipse.uml2.diagram.sequence.anchor.AnchorProcessorInput;
import org.eclipse.uml2.diagram.sequence.anchor.LifelineElementTraceable;
import org.eclipse.uml2.diagram.sequence.anchor.LifelineSatisfyCondition;
import org.eclipse.uml2.diagram.sequence.anchor.SDModelUtil;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLine;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDLifeLine;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDLifeLineElement;

public class InEntitySatisfyCondition
implements LifelineSatisfyCondition {
    private final SDLifeLineElement myEntity;
    private final LifeLine myLifeLine;

    public InEntitySatisfyCondition(SDLifeLineElement entity, AnchorProcessorInput anchorProcessorInput) throws SDModelUtil.AlienElementException {
        this.myEntity = entity;
        SDLifeLine lifelineEntity = SDModelUtil.findEnclosingLifeline2(this.myEntity);
        int lifelinePos = anchorProcessorInput.getLifelineIndex(lifelineEntity);
        this.myLifeLine = anchorProcessorInput.lifeLinesList().get(lifelinePos);
    }

    public InEntitySatisfyCondition(SDLifeLineElement entity, LifeLine lifeLine) {
        this.myEntity = entity;
        this.myLifeLine = lifeLine;
    }

    @Override
    public boolean isSatisfied(LifelineElementTraceable elementTraceable) {
        return this.myEntity == elementTraceable.getEntityAfterElement();
    }

    @Override
    public LifeLine getLifeline() {
        return this.myLifeLine;
    }

    public String toString() {
        return "InEntitySatisfyCondition-" + this.myEntity;
    }
}

