/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.edit.create;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.diagram.common.editpolicies.U2TCreateParameters;
import org.eclipse.uml2.diagram.common.editpolicies.U2TCreateParametersImpl;
import org.eclipse.uml2.diagram.sequence.anchor.SDModelUtil;
import org.eclipse.uml2.diagram.sequence.edit.create.AbstractCreateSDElementEditPolicy;
import org.eclipse.uml2.diagram.sequence.edit.create.ChooseOperatorDialog;
import org.eclipse.uml2.diagram.sequence.edit.create.CreateCombinedFragmentRequest;
import org.eclipse.uml2.diagram.sequence.edit.create.CreateInteractionUseRequest;
import org.eclipse.uml2.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.uml2.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.uml2.diagram.sequence.edit.policies.InteractionNestedLayoutRequest;
import org.eclipse.uml2.diagram.sequence.edit.policies.OrderedLayoutEditPolicy;
import org.eclipse.uml2.diagram.sequence.model.SDModelAccess;
import org.eclipse.uml2.diagram.sequence.model.edit.CreateCombinedFragment;
import org.eclipse.uml2.diagram.sequence.model.edit.SDAnchor;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDBehaviorSpec;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDBracket;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDBracketContainer;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDCombinedFragment;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDFrame;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDInteractionOperand;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDLifeLine;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDModel;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDMountingRegion;
import org.eclipse.uml2.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.BehaviorExecutionSpecification;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;

public class CreateCombinedFragmentEditPolicy
extends AbstractCreateSDElementEditPolicy {
    public void activate() {
        super.activate();
    }

    public boolean understandsRequest(Request req) {
        if (req instanceof CreateInteractionUseRequest) {
            return true;
        }
        if (req instanceof CreateCombinedFragmentRequest) {
            return true;
        }
        return super.understandsRequest(req);
    }

    public Command getCommand(Request request) {
        if (request instanceof CreateCombinedFragmentRequest) {
            return this.createCombinedFragment((CreateCombinedFragmentRequest)request);
        }
        return super.getCommand(request);
    }

    private SDBracketContainer findHostBracketContainer(SDModel sdModel) {
        Element umlHost = (Element)this.getHostImpl().getNotationView().getElement();
        if (umlHost instanceof BehaviorExecutionSpecification) {
            return sdModel.getUMLTracing().findBehaviorSpec((ExecutionSpecification)((BehaviorExecutionSpecification)umlHost));
        }
        if (umlHost instanceof Lifeline) {
            return sdModel.getUMLTracing().findLifeLine((Lifeline)umlHost);
        }
        if (umlHost instanceof InteractionOperand) {
            SDInteractionOperand sdFrame = sdModel.getUMLTracing().findInteractionOperand((InteractionOperand)umlHost);
            Lifeline onLifeline = (Lifeline)this.findLifeLineEditPart((EditPart)this.getHostImpl()).resolveSemanticElement();
            return sdFrame.findRegionForUmlLifeLine(onLifeline);
        }
        throw new IllegalStateException("EditPolicy " + (Object)((Object)this) + " is not expected to be registered for host : " + umlHost);
    }

    private Command createCombinedFragment(final CreateCombinedFragmentRequest request) {
        LifelineEditPart lifeLineEP = this.findLifeLineEditPart((EditPart)this.getHostImpl());
        final Lifeline umlLifeline = (Lifeline)lifeLineEP.resolveSemanticElement();
        final SDModel sdModel = SDModelAccess.findSDModel(this.getHostImpl().getNotationView());
        final SDBracketContainer sdHost = this.findHostBracketContainer(sdModel);
        GraphicalEditPart frameContainerEP = this.findFrameContainerEditPart(sdHost);
        U2TCreateParametersImpl createParams = U2TCreateParametersImpl.createFor((IGraphicalEditPart)this.getHostImpl(), (CreateRequest)request);
        final OrderedLayoutEditPolicy.AnchoredSibling diagramAnchor = this.computeAnchoredSibling((U2TCreateParameters)createParams);
        final SDAnchor sdAnchor = diagramAnchor == null || diagramAnchor.isBeforeNotAfterAnchor() ? SDAnchor.firstChildFor((SDBracketContainer)sdHost) : this.createSDAfterAnchor(diagramAnchor, sdModel, umlLifeline);
        final AbstractCreateSDElementEditPolicy.Helper2 helper2 = new AbstractCreateSDElementEditPolicy.Helper2(request.getPreferencesHint());
        final ShowDialogCommand dialog_ = request.isTieRequest() ? null : new ShowDialogCommand(this.getEditingDomain());
        AbstractTransactionalCommand doTheJob = new AbstractTransactionalCommand(this.getEditingDomain(), "", Collections.emptyList(), (U2TCreateParameters)createParams, (IGraphicalEditPart)frameContainerEP){
            private final /* synthetic */ U2TCreateParameters val$createParams;
            private final /* synthetic */ IGraphicalEditPart val$frameContainerEP;
            {
                this.val$createParams = u2TCreateParameters;
                this.val$frameContainerEP = iGraphicalEditPart;
                super($anonymous0, $anonymous1, $anonymous2);
            }

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                SDCombinedFragment result;
                if (request.isTieRequest()) {
                    CreateCombinedFragment creator = new CreateCombinedFragment(sdModel);
                    creator.tieCombinedFragment(request.getFragmentToTie(), sdHost, sdAnchor);
                    result = request.getFragmentToTie();
                } else {
                    ChooseOperatorDialog.OperatorProperties config = dialog_.getOperatorProperties();
                    if (config == null) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    CreateCombinedFragment creator = new CreateCombinedFragment(sdModel);
                    result = creator.createCombinedFragment(sdHost, sdAnchor, config.getOperatorKind(), config.getNumberOfOperands());
                }
                if (result == null) {
                    return CommandResult.newErrorCommandResult((String)"Failed to created combined fragment in SDModel");
                }
                CombinedFragment umlResult = result.getUmlCombinedFragment();
                SDMountingRegion combinedMounter = result.findRegionForUmlLifeLine(umlLifeline);
                Node combinedMounterView = helper2.createNode(CreateCombinedFragmentEditPolicy.this.getHostImpl().getNotationView(), (Element)umlResult, 3010, diagramAnchor);
                if (combinedMounterView == null) {
                    throw new IllegalStateException("Can't create combined mounter view for sd-mounter: " + combinedMounter);
                }
                if (this.val$createParams.getRelativeLocation() != null) {
                    Point relativeLocation = this.val$createParams.getRelativeLocation();
                    ViewUtil.setStructuralFeatureValue((View)combinedMounterView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)relativeLocation.y);
                }
                if (request.getSize() != null) {
                    ViewUtil.setStructuralFeatureValue((View)combinedMounterView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height(), (Object)request.getSize().height);
                    ViewUtil.setStructuralFeatureValue((View)combinedMounterView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width(), (Object)request.getSize().width);
                }
                Node combinedFrameView_ = request.isTieRequest() ? request.getFragmentToTieView() : helper2.createNode(this.val$frameContainerEP.getNotationView(), (Element)umlResult, 3008, null);
                Edge combinedMountingLink = helper2.createMountingLink((View)combinedMounterView, (View)combinedFrameView_);
                for (SDBracket nextOperandMounter : combinedMounter.getBrackets()) {
                    if (!(nextOperandMounter instanceof SDMountingRegion)) continue;
                    Node nextOperandMounterView = helper2.createNode((View)combinedMounterView, (Element)nextOperandMounter.getUmlFragment(), 3011, null);
                    if (nextOperandMounterView == null) {
                        throw new IllegalStateException("Can't create operand mounter view for sd-mounter: " + nextOperandMounter);
                    }
                    Node nextOperandFrameView = request.isTieRequest() ? this.findChildNodeByVisualIdAndSemanticElement(combinedFrameView_, 3009, (EObject)nextOperandMounter.getUmlFragment()) : helper2.createNode((View)combinedFrameView_, (Element)nextOperandMounter.getUmlFragment(), 3009, null);
                    if (nextOperandFrameView == null) {
                        throw new IllegalStateException("Can't create operand frame view for sd-mounter: " + nextOperandMounter);
                    }
                    Edge edge = helper2.createMountingLink((View)nextOperandMounterView, (View)nextOperandFrameView);
                }
                return CommandResult.newOKCommandResult();
            }

            private Node findChildNodeByVisualIdAndSemanticElement(Node node, int visualId, EObject semantic) {
                for (Object next : node.getChildren()) {
                    Node nextNode;
                    if (!(next instanceof Node) || UMLVisualIDRegistry.getVisualID((View)(nextNode = (Node)next)) != visualId || semantic != nextNode.getElement()) continue;
                    return nextNode;
                }
                return null;
            }
        };
        InteractionNestedLayoutRequest layoutRequest = new InteractionNestedLayoutRequest();
        layoutRequest.requestTotalLayout();
        Command layoutCommand = this.getLayoutCommand(layoutRequest);
        AbstractCreateSDElementEditPolicy.GEFAwareCompositeCommand result = new AbstractCreateSDElementEditPolicy.GEFAwareCompositeCommand(this.getHostImpl().getEditingDomain(), "Creating Combined Fragment");
        if (dialog_ != null) {
            result.add((IUndoableOperation)dialog_);
        }
        result.add((IUndoableOperation)doTheJob);
        ICommandProxy main = new ICommandProxy((ICommand)result);
        return this.postScheduleLayout((Command)main, layoutCommand);
    }

    private GraphicalEditPart findFrameContainerEditPart(SDBracketContainer sdHost) {
        InteractionEditPart interactionEP = (InteractionEditPart)this.findLifeLineEditPart((EditPart)this.getHostImpl()).getParent();
        if (sdHost instanceof SDLifeLine) {
            return interactionEP;
        }
        if (sdHost instanceof SDMountingRegion) {
            SDMountingRegion mounter = (SDMountingRegion)sdHost;
            SDFrame sdFrame = mounter.getFrame();
            return CreateCombinedFragmentEditPolicy.findFrameEditPart(interactionEP, sdFrame);
        }
        throw new IllegalStateException("Unknown SDBracketContainer: " + sdHost);
    }

    private static GraphicalEditPart findFrameEditPart(InteractionEditPart interactionEP, SDFrame sdFrame) {
        List<SDFrame> frames;
        if (sdFrame == null) {
            return interactionEP;
        }
        InteractionEditPart nextEP = interactionEP;
        try {
            frames = SDModelUtil.collectEnclosingFrames(sdFrame, new ArrayList<SDFrame>());
            Collections.reverse(frames);
        }
        catch (SDModelUtil.AlienElementException e) {
            throw new IllegalStateException(e);
        }
        for (SDFrame nextFrame : frames) {
            if ((nextEP = (GraphicalEditPart)nextEP.findEditPart(null, (EObject)nextFrame.getUmlFragment())) != null) continue;
            throw new IllegalStateException("Can't find frame editpart for SDFrame: " + nextFrame + ", while searching for deep frame: " + sdFrame);
        }
        return nextEP;
    }

    private OrderedLayoutEditPolicy.AnchoredSibling computeAnchoredSibling(U2TCreateParameters createParams) {
        Point relativeLocation = createParams.getRelativeLocation();
        if (relativeLocation != null && this.getHost().getEditPolicy((Object)"LayoutEditPolicy") instanceof OrderedLayoutEditPolicy) {
            OrderedLayoutEditPolicy layout = (OrderedLayoutEditPolicy)this.getHost().getEditPolicy((Object)"LayoutEditPolicy");
            return layout.findAnchoredSibling(relativeLocation);
        }
        return null;
    }

    private SDAnchor createSDAfterAnchor(OrderedLayoutEditPolicy.AnchoredSibling anchor, SDModel sdModel, Lifeline onUmlLifeline) {
        SDBehaviorSpec sdAnchor;
        if (anchor.isBeforeNotAfterAnchor()) {
            throw new IllegalArgumentException("I am for 'after' anchors only");
        }
        View notationAnchor = anchor.getSiblingView();
        switch (UMLVisualIDRegistry.getVisualID(notationAnchor)) {
            case 3004: {
                BehaviorExecutionSpecification umlSpec = (BehaviorExecutionSpecification)notationAnchor.getElement();
                sdAnchor = sdModel.getUMLTracing().findBehaviorSpec((ExecutionSpecification)umlSpec);
                break;
            }
            case 3010: {
                CombinedFragment umlFrame = (CombinedFragment)notationAnchor.getElement();
                SDCombinedFragment sdFrame = sdModel.getUMLTracing().findCombinedFragment(umlFrame);
                sdAnchor = sdFrame.findRegionForUmlLifeLine(onUmlLifeline);
                break;
            }
            case 3002: 
            case 3003: 
            case 3006: {
                throw new UnsupportedOperationException("Not yet implemented");
            }
            default: {
                throw new IllegalStateException("Unknown/unexpected anchor view found: " + notationAnchor);
            }
        }
        return SDAnchor.after((SDBracket)sdAnchor);
    }

    private static class ShowDialogCommand
    extends AbstractTransactionalCommand {
        private ChooseOperatorDialog.OperatorProperties myProperties;

        public ShowDialogCommand(TransactionalEditingDomain domain) {
            super(domain, "Select", Collections.emptyList());
        }

        public ChooseOperatorDialog.OperatorProperties getOperatorProperties() {
            return this.myProperties;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ChooseOperatorDialog dialog = new ChooseOperatorDialog(Display.getCurrent().getActiveShell());
            if (dialog.open() == 0) {
                this.myProperties = dialog.getResult();
                return CommandResult.newOKCommandResult();
            }
            return CommandResult.newCancelledCommandResult();
        }
    }
}

