/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.NodeListener;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.uml2.diagram.sequence.edit.parts.BehaviorExecutionSpecification2EditPart;
import org.eclipse.uml2.diagram.sequence.edit.parts.MessageEditPart;
import org.eclipse.uml2.diagram.sequence.figures.ExecutionSpecificationShape;
import org.eclipse.uml2.diagram.sequence.internal.missed.MissedMethods;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.UMLPackage;

public class BehaviorExecutionColorVisualEffect2
extends AbstractEditPolicy
implements NodeListener,
NotificationListener {
    private final Set<Message> myMessagesToListen = new HashSet<Message>();

    public void activate() {
        super.activate();
        this.refreshEffect();
        this.getHostImpl().addNodeListener(this);
        for (Object next : this.getHostImpl().getTargetConnections()) {
            this.hookConnection((ConnectionEditPart)next);
        }
    }

    public void deactivate() {
        this.getHostImpl().removeNodeListener(this);
        ArrayList<Message> messages = new ArrayList<Message>(this.myMessagesToListen);
        for (Message next : messages) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)next, (NotificationListener)this);
        }
        this.myMessagesToListen.clear();
        super.deactivate();
    }

    public void refreshEffect() {
        this.refreshEffect(null);
    }

    public void refreshEffect(ConnectionEditPart toBeRemoved) {
        this.refreshColorScheme_(toBeRemoved);
        this.refreshCross();
    }

    private void refreshCross() {
        boolean isDestruction = MissedMethods._executionSpecification().isDestruction(this.getHostImpl().getNotationView());
        this.getHostFigure().setCrossVisible(isDestruction);
    }

    private void refreshColorScheme_(ConnectionEditPart toBeRemoved) {
        boolean isRoot = this.hasOutgoingMessages(toBeRemoved) && !this.hasIncomingMessages(toBeRemoved);
        BehaviorExecutionSpecification2EditPart.BehaviorExecutionFigure figure = this.getHostImpl().getPrimaryShape();
        if (isRoot) {
            figure.setBackgroundColor(ColorConstants.lightGray);
            figure.setForegroundColor(ColorConstants.darkGray);
        } else {
            figure.setBackgroundColor(ColorConstants.white);
            figure.setForegroundColor(ColorConstants.black);
        }
    }

    private BehaviorExecutionSpecification2EditPart getHostImpl() {
        return (BehaviorExecutionSpecification2EditPart)this.getHost();
    }

    private boolean hasIncomingMessages(ConnectionEditPart toBeRemoved) {
        BehaviorExecutionSpecification2EditPart host = this.getHostImpl();
        List targetConnections = host.getTargetConnections();
        return this.containsMessageEditParts(targetConnections, toBeRemoved);
    }

    private boolean hasOutgoingMessages(ConnectionEditPart toBeRemoved) {
        BehaviorExecutionSpecification2EditPart host = this.getHostImpl();
        List sourceConnections = host.getSourceConnections();
        return this.containsMessageEditParts(sourceConnections, toBeRemoved);
    }

    private boolean containsMessageEditParts(List<?> connections, ConnectionEditPart toBeRemoved) {
        for (Object next : connections) {
            MessageEditPart nextMessageEditPart;
            Message message;
            if (next == toBeRemoved || !(next instanceof MessageEditPart) || (message = (Message)(nextMessageEditPart = (MessageEditPart)((Object)next)).resolveSemanticElement()) == null || message.getMessageSort() == MessageSort.REPLY_LITERAL) continue;
            return true;
        }
        return false;
    }

    public void removingSourceConnection(ConnectionEditPart connection, int index) {
        this.refreshEffect(connection);
    }

    public void removingTargetConnection(ConnectionEditPart connection, int index) {
        this.refreshEffect(connection);
        this.unhookConnection(connection);
    }

    public void sourceConnectionAdded(ConnectionEditPart connection, int index) {
        this.refreshEffect(null);
    }

    public void targetConnectionAdded(ConnectionEditPart connection, int index) {
        this.refreshEffect(null);
        this.hookConnection(connection);
    }

    private ExecutionSpecificationShape getHostFigure() {
        return this.getHostImpl().getPrimaryShape();
    }

    private void hookConnection(ConnectionEditPart ep) {
        MessageEditPart messageEP;
        Message message;
        if (ep instanceof MessageEditPart && !this.myMessagesToListen.contains(message = (Message)(messageEP = (MessageEditPart)ep).resolveSemanticElement())) {
            this.getDiagramEventBroker().addNotificationListener((EObject)message, (EStructuralFeature)UMLPackage.eINSTANCE.getMessage_MessageSort(), (NotificationListener)this);
            this.myMessagesToListen.add(message);
        }
    }

    private void unhookConnection(ConnectionEditPart ep) {
        if (ep instanceof MessageEditPart) {
            MessageEditPart messageEP = (MessageEditPart)ep;
            Message message = (Message)messageEP.resolveSemanticElement();
            this.getDiagramEventBroker().removeNotificationListener((EObject)message, (NotificationListener)this);
            this.myMessagesToListen.remove(message);
        }
    }

    public void notifyChanged(Notification notification) {
        if (notification.getFeature() == UMLPackage.eINSTANCE.getMessage_MessageSort()) {
            this.refreshCross();
        }
    }

    private DiagramEventBroker getDiagramEventBroker() {
        return DiagramEventBroker.getInstance((TransactionalEditingDomain)this.getHostImpl().getEditingDomain());
    }
}

