/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.edit.policies;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Request;
import org.eclipse.gef.handles.RelativeHandleLocator;
import org.eclipse.gef.handles.ResizableHandleKit;
import org.eclipse.gef.handles.ResizeHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.diagram.sequence.edit.policies.ExpandFrameDragTracker;
import org.eclipse.uml2.diagram.sequence.edit.policies.SDResizableShapeEditPolicy;
import org.eclipse.uml2.diagram.sequence.edit.policies.TieFrameRequest;
import org.eclipse.uml2.diagram.sequence.part.UMLDiagramEditorPlugin;

public class TieFrameEditPolicy
extends SDResizableShapeEditPolicy {
    protected List<?> createSelectionHandles() {
        this.setResizeDirections(29);
        LinkedList<Object> result = new LinkedList<Object>();
        this.addResizeCornerHandles((GraphicalEditPart)this.getHost(), result);
        return result;
    }

    private void addResizeCornerHandles(GraphicalEditPart part, List<Object> output) {
        ResizableHandleKit.addMoveHandle((org.eclipse.gef.GraphicalEditPart)((GraphicalEditPart)this.getHost()), output);
        output.add(this.createExpandFrameHandle(part, 16));
        ResizableHandleKit.addHandle((org.eclipse.gef.GraphicalEditPart)part, output, (int)16);
        ResizableHandleKit.addHandle((org.eclipse.gef.GraphicalEditPart)part, output, (int)20);
        ResizableHandleKit.addHandle((org.eclipse.gef.GraphicalEditPart)part, output, (int)4);
        ResizableHandleKit.addHandle((org.eclipse.gef.GraphicalEditPart)part, output, (int)12);
        output.add(this.createExpandFrameHandle(part, 8));
        ResizableHandleKit.addHandle((org.eclipse.gef.GraphicalEditPart)part, output, (int)8);
        ResizableHandleKit.addHandle((org.eclipse.gef.GraphicalEditPart)part, output, (int)9);
        ResizableHandleKit.addHandle((org.eclipse.gef.GraphicalEditPart)part, output, (int)1);
        ResizableHandleKit.addHandle((org.eclipse.gef.GraphicalEditPart)part, output, (int)17);
    }

    protected IFigure createDragSourceFeedbackFigure() {
        Rectangle bounds = this.getInitialFeedbackBounds();
        StretchHorizontallyRectangle feedback = new StretchHorizontallyRectangle(bounds);
        FigureUtilities.makeGhostShape((Shape)feedback);
        feedback.setLineStyle(3);
        feedback.setForegroundColor(ColorConstants.white);
        this.addFeedback((IFigure)feedback);
        return feedback;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        if (request instanceof TieFrameRequest) {
            StretchHorizontallyRectangle feedback = (StretchHorizontallyRectangle)this.getDragSourceFeedbackFigure();
            PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
            this.getHostFigure().translateToAbsolute((Translatable)rect);
            feedback.translateToRelative((Translatable)rect);
            feedback.setBounds((Rectangle)rect);
            Point location = request.getLocation().getCopy();
            feedback.translateToRelative((Translatable)location);
            switch (request.getResizeDirection()) {
                case 8: {
                    feedback.setLeftCorner(location);
                    break;
                }
                case 16: {
                    feedback.setRightCorner(location);
                }
            }
        } else {
            super.showChangeBoundsFeedback(request);
        }
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof TieFrameRequest) {
            this.showChangeBoundsFeedback((TieFrameRequest)request);
        } else {
            super.showSourceFeedback(request);
        }
    }

    public void eraseSourceFeedback(Request request) {
        if (request instanceof TieFrameRequest) {
            this.eraseChangeBoundsFeedback((TieFrameRequest)request);
        } else {
            super.eraseSourceFeedback(request);
        }
    }

    public boolean understandsRequest(Request request) {
        if (request instanceof TieFrameRequest) {
            return true;
        }
        return super.understandsRequest(request);
    }

    private ResizeHandle createExpandFrameHandle(GraphicalEditPart owner, int direction) {
        TieFrameImageHandle handle = new TieFrameImageHandle(owner, direction, 3);
        handle.setCursor(Cursors.ARROW);
        handle.setDragTracker((DragTracker)new ExpandFrameDragTracker(owner, direction, (IFigure)handle));
        return handle;
    }

    private static class GdeRelativeHandleLocator
    extends RelativeHandleLocator {
        protected int myLocation;
        private int myShift;

        public GdeRelativeHandleLocator(IFigure reference, int location, int shift) {
            super(reference, location);
            this.myLocation = location;
            this.myShift = shift;
        }

        public void relocate(IFigure target) {
            super.relocate(target);
            target.getBounds().x += GdeRelativeHandleLocator.getXGuide(this.myLocation) * this.myShift;
            target.getBounds().y += GdeRelativeHandleLocator.getYGuide(this.myLocation) * this.myShift;
        }

        private static int getXGuide(int dir) {
            switch (dir & 0x18) {
                case 8: {
                    return -1;
                }
                case 16: {
                    return 1;
                }
            }
            return 0;
        }

        private static int getYGuide(int dir) {
            switch (dir & 5) {
                case 1: {
                    return -1;
                }
                case 4: {
                    return 1;
                }
            }
            return 0;
        }
    }

    static class StretchHorizontallyRectangle
    extends Polygon {
        static final int BIT_HEIGHT = 5;

        StretchHorizontallyRectangle(Rectangle rectangle) {
            this.setBounds(rectangle);
        }

        public void setLeftCorner(Point location) {
            this.setPoint(location.getTranslated(0, 5), 1);
            this.setPoint(location.getTranslated(0, -5), 2);
        }

        public void setRightCorner(Point location) {
            this.setPoint(location.getTranslated(0, -5), 5);
            this.setPoint(location.getTranslated(0, 5), 6);
        }

        public void setBounds(Rectangle rectangle) {
            PointList points = new PointList(9);
            rectangle = rectangle.getResized(-1, -1);
            points.setSize(9);
            points.setPoint(rectangle.getBottomLeft(), 0);
            points.setPoint(rectangle.getTopLeft(), 1);
            points.setPoint(rectangle.getTopLeft(), 2);
            points.setPoint(rectangle.getTopLeft(), 3);
            points.setPoint(rectangle.getTopRight(), 4);
            points.setPoint(rectangle.getTopRight(), 5);
            points.setPoint(rectangle.getTopRight(), 6);
            points.setPoint(rectangle.getBottomRight(), 7);
            points.setPoint(rectangle.getBottomLeft(), 8);
            this.setPoints(points);
        }
    }

    private static class TieFrameImageHandle
    extends ResizeHandle {
        private final int myResizeDirection;

        public TieFrameImageHandle(GraphicalEditPart owner, int direction, int shift) {
            super((org.eclipse.gef.GraphicalEditPart)owner, (Locator)new GdeRelativeHandleLocator(owner.getFigure(), direction, shift), Cursors.getDirectionalCursor((int)direction));
            assert (direction == 16 || direction == 8);
            this.myResizeDirection = direction;
        }

        protected void init() {
            Rectangle imageBounds = new Rectangle(TieFrameImageHandle.getHandleImage().getBounds());
            imageBounds.expand(imageBounds.width, 0);
            this.setPreferredSize(imageBounds.getSize());
        }

        public void paintFigure(Graphics g) {
            Rectangle r = this.getBounds().getCopy();
            r.shrink(1, 1);
            int shiftFactor = this.myResizeDirection == 16 ? 1 : -1;
            g.setForegroundColor(this.getFillColor());
            g.setLineWidth(1);
            g.setLineStyle(3);
            g.drawLine(r.getCenter(), r.getCenter().translate(shiftFactor * r.width / 4, 0));
            if (this.myResizeDirection == 16) {
                r.x += r.width / 4 * 3;
            }
            g.drawImage(UMLDiagramEditorPlugin.getInstance().getBundledImage("icons/shape-anchor.gif"), r.x, r.y);
        }

        private static Image getHandleImage() {
            return UMLDiagramEditorPlugin.getInstance().getBundledImage("icons/shape-anchor.gif");
        }
    }
}

