/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.figures;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.uml2.diagram.common.draw2d.PileLayout;
import org.eclipse.uml2.diagram.sequence.draw2d.shadow.ShadowStealth;
import org.eclipse.uml2.diagram.sequence.figures.InvisibleRectangle;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLine;
import org.eclipse.uml2.diagram.sequence.part.UMLDiagramEditorPlugin;

public class LifelineViewMap {

    public static class LifelineHeadShape
    extends RectangleFigure {
        private static final Border HEAD_TEXT_MARGIN = new MarginBorder(5, 5, 0, 5);
        private Label myStereotypesLabel;
        private Label myLifelineIdentLabel;
        private Label myDecomposedAsLabel;
        private Label myRefLabel;
        private IFigure myDecomposedAsPanel;

        public LifelineHeadShape(IFigure lifeLineShape) {
            this.setLineWidth(1);
            this.setLifelineHeadText((IFigure)this);
            assert (this.getLayoutManager() instanceof PileLayout);
            if (this.getLayoutManager() == null) {
                this.setLayoutManager((LayoutManager)new PileLayout());
            }
            this.setBorder((Border)new MarginBorder(0, 0, 10, 0));
            this.setMinimumSize(new Dimension(60, 60));
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            Dimension d = super.getPreferredSize(wHint, hHint);
            return d.union(this.minSize);
        }

        public Label getLifelineStereotypesLabel() {
            return this.myStereotypesLabel;
        }

        public Label getLifelineIdentLabel() {
            return this.myLifelineIdentLabel;
        }

        public Label getLifelineDecomposedAsLabel() {
            return this.myDecomposedAsLabel;
        }

        public Label getLifelineRefLabel() {
            return this.myRefLabel;
        }

        public IFigure getLifelineDecomposedAsPanel() {
            return this.myDecomposedAsPanel;
        }

        private void setLifelineHeadText(IFigure headFigure) {
            headFigure.setLayoutManager((LayoutManager)new PileLayout());
            this.myStereotypesLabel = new Label();
            this.add((IFigure)this.myStereotypesLabel);
            this.myLifelineIdentLabel = new Label();
            this.myLifelineIdentLabel.setLabelAlignment(2);
            this.myLifelineIdentLabel.setForegroundColor(ColorConstants.black);
            this.myLifelineIdentLabel.setFont(UMLDiagramEditorPlugin.getInstance().getDefaultFont());
            this.myLifelineIdentLabel.setBorder(HEAD_TEXT_MARGIN);
            Figure centeredLabel = new Figure();
            centeredLabel.setLayoutManager((LayoutManager)new BorderLayout());
            centeredLabel.add((IFigure)this.myLifelineIdentLabel, (Object)BorderLayout.CENTER);
            headFigure.add((IFigure)centeredLabel, (Object)PileLayout.ALIGN_CENTER);
            this.myDecomposedAsPanel = new InvisibleRectangle();
            this.myDecomposedAsPanel.setLayoutManager((LayoutManager)new FlowLayout(true));
            this.myRefLabel = new Label("ref  ");
            this.myRefLabel.setFont(UMLDiagramEditorPlugin.getInstance().getDefaultBoldFont());
            this.myDecomposedAsPanel.add((IFigure)this.myRefLabel);
            this.myDecomposedAsLabel = new Label();
            this.myDecomposedAsPanel.add((IFigure)this.myDecomposedAsLabel);
            this.myDecomposedAsPanel.setBorder(HEAD_TEXT_MARGIN);
            Figure centeredContainer = new Figure();
            centeredContainer.setLayoutManager((LayoutManager)new BorderLayout());
            centeredContainer.add(this.myDecomposedAsPanel, (Object)BorderLayout.CENTER);
            headFigure.add((IFigure)centeredContainer, (Object)PileLayout.ALIGN_CENTER);
        }
    }

    private static class LifelineLayout
    extends AbstractLayout
    implements LMLifeLine.DetailsLayouter {
        private IFigure myHead;
        private LifelineTailShape myTail;
        private int myCenterRelativePos;
        private int myHeadHalfWidth;

        private LifelineLayout() {
        }

        @Override
        public int getHeadPreferredWidth() {
            return this.myHead.getPreferredSize().width;
        }

        @Override
        public int getHeadPreferredHeight() {
            return this.myHead.getPreferredSize().height;
        }

        @Override
        public int getHeadTopPos() {
            return this.myHead.getBounds().y;
        }

        @Override
        public void setHorizontalPositions(int centerRelativePos, int headHalfWidth) {
            this.myCenterRelativePos = centerRelativePos;
            this.myHeadHalfWidth = headHalfWidth;
            this.myHead.revalidate();
            this.myTail.setLineRelativeX(centerRelativePos);
            this.myTail.revalidate();
        }

        @Override
        public int getCenterRelativePos() {
            return this.myCenterRelativePos;
        }

        @Override
        public int getHeadHalfWidth() {
            return this.myHeadHalfWidth;
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            int minWHint = 0;
            int minHHint = 0;
            if (wHint < 0) {
                minWHint = -1;
            }
            if (hHint < 0) {
                minHHint = -1;
            }
            Insets border = container.getInsets();
            wHint = Math.max(minWHint, wHint - border.getWidth());
            hHint = Math.max(minHHint, hHint - border.getHeight());
            Dimension prefSize = new Dimension();
            Dimension headSize = this.myHead.getPreferredSize(wHint, hHint);
            hHint = Math.max(minHHint, hHint - headSize.height);
            prefSize.setSize(headSize);
            Dimension tailSize = this.myTail.getPreferredSize(wHint, hHint);
            prefSize.height += tailSize.height;
            prefSize.width = Math.max(prefSize.width, tailSize.width);
            return prefSize.expand(border.getWidth(), border.getHeight());
        }

        public void layout(IFigure container) {
            Rectangle area = container.getClientArea();
            Rectangle headBounds = new Rectangle(area);
            headBounds.translate(this.myCenterRelativePos - this.myHeadHalfWidth, 0);
            headBounds.width = 2 * this.myHeadHalfWidth;
            Dimension headPreferredSize = this.myHead.getPreferredSize(headBounds.width, -1);
            headBounds.height = headPreferredSize.height;
            this.myHead.setBounds(headBounds);
            area.y += headBounds.height;
            area.height -= headBounds.height;
            this.myTail.setBounds(area);
        }

        public void setConstraint(IFigure child, Object constraint) {
            if (child instanceof LifelineHeadShape) {
                this.myHead = child;
            } else if (child instanceof LifelineTailShape) {
                this.myTail = (LifelineTailShape)child;
            } else {
                throw new IllegalArgumentException();
            }
            super.setConstraint(child, constraint);
        }
    }

    public static class LifelineShape
    extends InvisibleRectangle {
        private final LifelineTailShape myTail;
        private final LifelineHeadShape myHead;
        private final LifelineLayout myLifelineLayout;

        public LifelineShape() {
            this.setOutline(false);
            this.setFill(false);
            this.myLifelineLayout = new LifelineLayout();
            this.setLayoutManager((LayoutManager)this.myLifelineLayout);
            this.myHead = new LifelineHeadShape((IFigure)this);
            this.add((IFigure)this.myHead);
            this.myTail = new LifelineTailShape(this);
            this.add((IFigure)this.myTail);
            this.myLifelineLayout.setHorizontalPositions(30, 30);
        }

        public LMLifeLine.DetailsLayouter getLifelineLayout() {
            return this.myLifelineLayout;
        }

        public LifelineHeadShape getHead() {
            return this.myHead;
        }

        public LifelineTailShape getTail() {
            return this.myTail;
        }

        public IFigure findFigureAt(int x, int y, TreeSearch search) {
            IFigure result = super.findFigureAt(x, y, search);
            return result == this ? null : result;
        }

        public Label getLifelineStereotypesLabel() {
            return this.getHead().getLifelineStereotypesLabel();
        }

        public Label getLifelineIdentLabel() {
            return this.getHead().getLifelineIdentLabel();
        }

        public Label getLifelineDecomposedAsLabel() {
            return this.getHead().getLifelineDecomposedAsLabel();
        }

        public Label getLifelineRefLabel() {
            return this.getHead().getLifelineRefLabel();
        }

        public void setDecomposedAsBlockVisible(boolean visible) {
            this.getHead().getLifelineDecomposedAsPanel().setVisible(visible);
        }
    }

    public static class LifelineTailShape
    extends RectangleFigure
    implements ShadowStealth {
        private int myLineRelativeX;
        private static final int SELECTABLE_WIDTH = 10;

        public LifelineTailShape(final LifelineShape lifelineShape) {
            this.setOpaque(false);
            this.setFill(false);
            this.setLineStyle(2);
            this.setMinimumSize(new Dimension());
            this.setLayoutManager((LayoutManager)new XYLayout(){

                public Point getOrigin(IFigure parent) {
                    if (parent == LifelineTailShape.this) {
                        return lifelineShape.getClientArea().getLocation();
                    }
                    return super.getOrigin(parent);
                }
            });
        }

        public IFigure findFigureAt(int x, int y, TreeSearch search) {
            int distToLine;
            IFigure result = super.findFigureAt(x, y, search);
            if (result == this && (distToLine = Math.abs(this.getLineAbsoluteX() - x)) >= this.getLineWidth() + 10) {
                result = null;
            }
            return result;
        }

        protected void outlineShape(Graphics graphics) {
            Rectangle bounds = this.getBounds();
            graphics.drawLine(this.getLineAbsoluteX(), bounds.y, this.getLineAbsoluteX(), bounds.y + bounds.height);
        }

        private int getLineAbsoluteX() {
            return this.bounds.x + this.myLineRelativeX;
        }

        void setLineRelativeX(int x) {
            this.myLineRelativeX = x;
        }
    }
}

