/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.diagram.sequence.draw2d.layouts.FillingBorderLayout;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMVisibleFrameWithPentagon;
import org.eclipse.uml2.diagram.sequence.part.UMLDiagramEditorPlugin;

public class Pentagon
extends Shape
implements LMVisibleFrameWithPentagon.PentagonLayouter {
    public static final int BIT_SIZE = 5;
    private boolean myEnablePentagonLayouter = true;

    public Pentagon() {
        this.setLineWidth(1);
        this.setFont(UMLDiagramEditorPlugin.getInstance().getDefaultFont());
        this.setLayoutManager((LayoutManager)new FillingBorderLayout());
    }

    public void setEnablePentagonLayouter(boolean enablePentagonLayouter) {
        this.myEnablePentagonLayouter = enablePentagonLayouter;
    }

    protected void fillShape(Graphics graphics) {
        graphics.fillPolygon(this.getPoints(Pentagon.getOutlineBounds(this)));
    }

    protected void outlineShape(Graphics graphics) {
        graphics.drawPolygon(this.getPoints(Pentagon.getOutlineBounds(this)));
    }

    public void setContent(IFigure content) {
        content.setBorder((Border)new MarginBorder(0, 5, 2, 5));
        this.add(content, FillingBorderLayout.CENTER);
        this.updateToPreferredSize();
    }

    public void updateToPreferredSize() {
        this.setSize(this.getPreferredSize());
    }

    protected PointList getPoints(Rectangle rect) {
        PointList points = new PointList(6);
        points.addPoint(rect.x, rect.y);
        points.addPoint(rect.x + rect.width, rect.y);
        if (5 > rect.height || 5 > rect.width) {
            points.addPoint(rect.x + rect.width, rect.y + rect.height);
        } else {
            points.addPoint(rect.x + rect.width, rect.y + rect.height - 5);
            points.addPoint(rect.x + rect.width - 5, rect.y + rect.height);
        }
        points.addPoint(rect.x, rect.y + rect.height);
        points.addPoint(rect.x, rect.y);
        return points;
    }

    @Override
    public int getPreferredWidth() {
        return this.getPreferredSize().width;
    }

    @Override
    public int getPreferredHeight() {
        return this.getPreferredSize().height;
    }

    @Override
    public void setX(int x) {
        if (this.myEnablePentagonLayouter) {
            Rectangle bounds = this.getBounds().getCopy();
            bounds.x = x;
            this.setBounds(bounds);
        }
    }

    @Override
    public void setY(int y) {
        if (this.myEnablePentagonLayouter) {
            Rectangle bounds = this.getBounds().getCopy();
            bounds.y = y;
            this.setBounds(bounds);
        }
    }

    public Label createPentagonLabel() {
        return new Label(){

            public void setText(String s) {
                super.setText(s);
                Pentagon.this.updateToPreferredSize();
            }

            public void setIcon(Image image) {
                super.setIcon(image);
                Pentagon.this.updateToPreferredSize();
            }
        };
    }

    public static Rectangle getOutlineBounds(Shape shape) {
        Rectangle b = new Rectangle(shape.getBounds());
        int lineWidth = shape.getLineWidth();
        int lineOffset = lineWidth / 2;
        b.x += lineOffset;
        b.y += lineOffset;
        b.width -= lineWidth;
        b.height -= lineWidth;
        return b;
    }
}

