/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.gef;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.gef.AbsDiagramGef;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.gef.AbsElementGef;
import org.eclipse.uml2.diagram.sequence.internal.missed.MissedMethods;

public class AbsLinkGef
extends AbsElementGef
implements AbsLink {
    private final ConnectionEditPart myModelLinkEditPart;
    private AbsElement mySource;
    private AbsElement myDestination;

    AbsLinkGef(ConnectionEditPart modelLinkEditPart, AbsDiagramGef diagram) {
        super((IGraphicalEditPart)modelLinkEditPart, diagram);
        this.myModelLinkEditPart = modelLinkEditPart;
    }

    @Override
    public void setLinkPoints(java.awt.Point[] points) {
        ArrayList<Point> bendpoints;
        int size = points.length;
        Point sourcePoint = AbsLinkGef.toGefPoint(points[0]);
        if (size > 2) {
            bendpoints = new ArrayList<Point>(size - 2);
            int i = 1;
            while (i < size - 1) {
                bendpoints.add(AbsLinkGef.toGefPoint(points[i]));
                ++i;
            }
        } else {
            bendpoints = Collections.EMPTY_LIST;
        }
        Point destinationPoint = AbsLinkGef.toGefPoint(points[size - 1]);
        if (!(sourcePoint.equals((Object)MissedMethods._connectionEditPart().getSourcePoint(this.myModelLinkEditPart)) && destinationPoint.equals((Object)MissedMethods._connectionEditPart().getTargetPoint(this.myModelLinkEditPart)) && bendpoints.equals(MissedMethods._connectionEditPart().getBendpoints(this.myModelLinkEditPart)))) {
            this.pointsAreChanged();
        }
        MissedMethods._connectionEditPart().setupBendpoints(this.myModelLinkEditPart, sourcePoint, destinationPoint, bendpoints);
    }

    public void pointsAreChanged() {
        AbsDiagramGef.ChangePositionWatcher changePositionWatcher = this.getAbsDiagramGef().getChangePositionWatcher();
        changePositionWatcher.linkPointsAreChanged(this);
    }

    @Override
    public java.awt.Point[] getLinkPoints() {
        List bendpoints = MissedMethods._connectionEditPart().getBendpoints(this.myModelLinkEditPart);
        int size = bendpoints.size() + 2;
        java.awt.Point[] result = new java.awt.Point[size];
        result[0] = AbsLinkGef.toAwtPoint(MissedMethods._connectionEditPart().getSourcePoint(this.myModelLinkEditPart));
        int j = 0;
        while (j < bendpoints.size()) {
            result[j + 1] = AbsLinkGef.toAwtPoint((Point)((AbsoluteBendpoint)bendpoints.get(j)));
            ++j;
        }
        result[size - 1] = AbsLinkGef.toAwtPoint(MissedMethods._connectionEditPart().getTargetPoint(this.myModelLinkEditPart));
        return result;
    }

    @Override
    public AbsElement getSource() {
        if (this.mySource == null) {
            EditPart source = this.myModelLinkEditPart.getSource();
            if (source instanceof ConnectionEditPart) {
                this.mySource = this.getAbsElementFactory().createAbsLink((ConnectionEditPart)source);
            } else if (source instanceof GraphicalEditPart) {
                this.mySource = this.getAbsElementFactory().createAbsNode((GraphicalEditPart)source);
            }
        }
        return this.mySource;
    }

    @Override
    public AbsElement getDestination() {
        if (this.myDestination == null) {
            EditPart destination = this.myModelLinkEditPart.getTarget();
            if (destination instanceof ConnectionEditPart) {
                this.myDestination = this.getAbsElementFactory().createAbsLink((ConnectionEditPart)destination);
            } else if (destination instanceof GraphicalEditPart) {
                this.myDestination = this.getAbsElementFactory().createAbsNode((GraphicalEditPart)destination);
            }
        }
        return this.myDestination;
    }

    private static java.awt.Point toAwtPoint(Point gefPoint) {
        return new java.awt.Point(gefPoint.x, gefPoint.y);
    }

    private static Point toGefPoint(java.awt.Point awtPoint) {
        return new AbsoluteBendpoint(awtPoint.x, awtPoint.y);
    }
}

