/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.gef;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class WeakValueHashMap
implements Map {
    private final HashMap myHashMap = new HashMap();
    private final ReferenceQueue myQueue = new ReferenceQueue();

    WeakValueHashMap() {
    }

    @Override
    public int size() {
        this.cleanRefs();
        return this.myHashMap.size();
    }

    @Override
    public boolean isEmpty() {
        this.cleanRefs();
        return this.myHashMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.cleanRefs();
        return this.myHashMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object val) {
        throw new UnsupportedOperationException();
    }

    public Object get(Object key) {
        this.cleanRefs();
        RefWithUin ref = (RefWithUin)this.myHashMap.get(key);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    public Object put(Object key, Object value) {
        this.cleanRefs();
        RefWithUin ref = new RefWithUin(value, key);
        RefWithUin oldRef = this.myHashMap.put(key, ref);
        if (oldRef == null) {
            return null;
        }
        return oldRef.get();
    }

    public Object remove(Object key) {
        this.cleanRefs();
        RefWithUin oldRef = (RefWithUin)this.myHashMap.remove(key);
        if (oldRef == null) {
            return null;
        }
        return oldRef.get();
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.myHashMap.clear();
    }

    public Set keySet() {
        this.cleanRefs();
        return this.myHashMap.keySet();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    protected void cleanRefs() {
        RefWithUin ref = (RefWithUin)this.myQueue.poll();
        while (ref != null) {
            Object value = this.myHashMap.get(ref.getKey());
            if (value == ref) {
                this.myHashMap.remove(ref.getKey());
            }
            ref = (RefWithUin)this.myQueue.poll();
        }
    }

    private class RefWithUin
    extends WeakReference {
        private final Object myKey;

        public RefWithUin(Object obj, Object key) {
            super(obj, WeakValueHashMap.this.myQueue);
            this.myKey = key;
        }

        public Object getKey() {
            return this.myKey;
        }
    }
}

