/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.horizontal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.horizontal.ComparableVerticalElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.horizontal.FramesManager;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMExecutionOccurence;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLineBracket;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMountingLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMountingRegion;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMSendMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMSimpleLifeLineBracket;

class LifeLineHorizontalLayouter
implements ComparableVerticalElement {
    private final LMLifeLine myLMLifeLine;

    LifeLineHorizontalLayouter(LMLifeLine lifeLine) {
        this.myLMLifeLine = lifeLine;
    }

    @Override
    public int getX() {
        return this.myLMLifeLine.getGdeNode().getX();
    }

    @Override
    public int getWidth() {
        return this.myLMLifeLine.getGdeNode().getWidth();
    }

    @Override
    public boolean hasNoBounds() {
        return !this.myLMLifeLine.getGdeNode().isUserResized();
    }

    LMLifeLine getLmLifeline() {
        return this.myLMLifeLine;
    }

    PreparedLayout scanAndPrepareLayout(FramesManager frameManager, Collection messagesCollection) {
        PerLifeLineSession perLifeLineSession = new PerLifeLineSession(frameManager, messagesCollection);
        return perLifeLineSession.go();
    }

    private static class CenteredBracketInfo {
        private final LMSimpleLifeLineBracket mySimpleLifeLineBracket;
        private final int myOffset;

        CenteredBracketInfo(LMSimpleLifeLineBracket simpleLifeLineBracket, int offset) {
            this.mySimpleLifeLineBracket = simpleLifeLineBracket;
            this.myOffset = offset;
        }

        public int getLeftBorderPos() {
            return this.myOffset - this.getWidth() / 2;
        }

        public int getRightBorderPos() {
            return this.myOffset + this.getWidth() / 2;
        }

        int getWidth() {
            return this.mySimpleLifeLineBracket.getPreferedWidth();
        }

        int getOffset() {
            return this.myOffset;
        }

        LMSimpleLifeLineBracket getBracket() {
            return this.mySimpleLifeLineBracket;
        }
    }

    private class PerLifeLineSession {
        private final FramesManager myFrameManager;
        private final Collection myMessagesCollection;
        private final List myShiftedBracketInfoList = new ArrayList();
        private final List myCenteredBracketInfoList = new ArrayList();
        private int myLeftHalfWidth = 0;
        private int myRightHalfWidth = 0;

        PerLifeLineSession(FramesManager frameManager, Collection messagesCollection) {
            this.myFrameManager = frameManager;
            this.myMessagesCollection = messagesCollection;
        }

        PreparedLayout go() {
            ShiftedBracketInfo lifeLineBracketInfo = new ShiftedBracketInfo(null, null, 0);
            this.processBracketList(LifeLineHorizontalLayouter.this.myLMLifeLine.getChildBracketsList().getListView(), 0, false, lifeLineBracketInfo, null);
            this.adjustRigthHalfWidth(lifeLineBracketInfo.getMaxRightPos());
            final int headHalfWidth = LifeLineHorizontalLayouter.this.myLMLifeLine.getHeadNameWidth() / 2;
            this.adjustLeftHalfWidth(headHalfWidth);
            this.adjustRigthHalfWidth(headHalfWidth);
            return new PreparedLayout(){

                @Override
                public int getLeftHalfWidth() {
                    return PerLifeLineSession.this.myLeftHalfWidth;
                }

                @Override
                public int getRightHalfWidth() {
                    return PerLifeLineSession.this.myRightHalfWidth;
                }

                @Override
                public int getCurrentCenterPos() {
                    return LifeLineHorizontalLayouter.this.myLMLifeLine.getGdeNode().getX() + PerLifeLineSession.this.myLeftHalfWidth;
                }

                @Override
                public void layout(int centerLinePos) {
                    LifeLineHorizontalLayouter.this.myLMLifeLine.setHorizontalPos(centerLinePos, PerLifeLineSession.this.myLeftHalfWidth, PerLifeLineSession.this.myRightHalfWidth, headHalfWidth);
                    int i = 0;
                    while (i < PerLifeLineSession.this.myShiftedBracketInfoList.size()) {
                        ShiftedBracketInfo bracketInfo = (ShiftedBracketInfo)PerLifeLineSession.this.myShiftedBracketInfoList.get(i);
                        LMLifeLineBracket lifeLineBracket = bracketInfo.getBracket();
                        int newPos = centerLinePos + bracketInfo.getOffset() - 10;
                        int width = bracketInfo.getWidth();
                        int paintableWidth = 20;
                        lifeLineBracket.getBracketHorizontalLayouter().setHorizontalPositions(newPos, paintableWidth, width);
                        lifeLineBracket.setHorizontalPosition(newPos);
                        ++i;
                    }
                    i = 0;
                    while (i < PerLifeLineSession.this.myCenteredBracketInfoList.size()) {
                        CenteredBracketInfo centeredBracketInfo = (CenteredBracketInfo)PerLifeLineSession.this.myCenteredBracketInfoList.get(i);
                        int width = centeredBracketInfo.getWidth();
                        if (width < 20) {
                            width = 20;
                        }
                        int x = centeredBracketInfo.getOffset() + centerLinePos - width / 2;
                        AbsNode gdeNode = centeredBracketInfo.getBracket().getGdeNode();
                        gdeNode.setX(x);
                        gdeNode.setWidth(width);
                        ++i;
                    }
                }
            };
        }

        private void processBracketList(List subbrackets, int offset, boolean shouldShiftRight, ShiftedBracketInfo parentBracketInfo, FramesManager.FrameInfo currentFrameInfo) {
            int maxRightPos = 0;
            int maxLeftCentered = 0;
            int maxRightCentered = 0;
            for (LMLifeLineBracket subBracket1 : subbrackets) {
                if (subBracket1 instanceof LMSimpleLifeLineBracket) {
                    CenteredBracketInfo centeredBracketInfo = this.processSimpleBracket((LMSimpleLifeLineBracket)subBracket1, parentBracketInfo);
                    maxLeftCentered = StrictMath.max(maxLeftCentered, -centeredBracketInfo.getLeftBorderPos());
                    maxRightCentered = StrictMath.max(maxRightCentered, centeredBracketInfo.getRightBorderPos());
                } else {
                    ShiftedBracketInfo subBracketInfo = this.processBracket(subBracket1, offset, shouldShiftRight, parentBracketInfo);
                    if (subBracketInfo.getMaxRightPos() > maxRightPos) {
                        maxRightPos = subBracketInfo.getMaxRightPos();
                    }
                }
                subBracket1.updateBracketConsistentState();
            }
            if (currentFrameInfo != null) {
                int maxRightProminence = Math.max(parentBracketInfo.getMaxRightPos(), Math.max(maxRightPos, maxRightCentered));
                int maxLeftProminence = Math.max(10, maxLeftCentered);
                if (currentFrameInfo.getLMFrame().getGdeNode().getY() <= LifeLineHorizontalLayouter.this.myLMLifeLine.getGdeNode().getY() && LifeLineHorizontalLayouter.this.myLMLifeLine.getHeadHeight() <= currentFrameInfo.getLMFrame().getGdeNode().getHeight()) {
                    int headHalfWidth = LifeLineHorizontalLayouter.this.myLMLifeLine.getHeadNameWidth() / 2;
                    maxLeftProminence = Math.max(maxLeftProminence, headHalfWidth);
                    maxRightProminence = Math.max(maxLeftProminence, headHalfWidth);
                }
                currentFrameInfo.setMaxBracketPos(this.myFrameManager.getLifeLineIndex(), maxLeftProminence, maxRightProminence);
            }
            this.adjustLeftHalfWidth(maxLeftCentered);
            this.adjustRigthHalfWidth(maxRightCentered);
            parentBracketInfo.adjustMaxRightPos(maxRightPos);
        }

        private CenteredBracketInfo processSimpleBracket(LMSimpleLifeLineBracket bracket, ShiftedBracketInfo parentBracketInfo) {
            CenteredBracketInfo centeredBracketInfo = new CenteredBracketInfo(bracket, parentBracketInfo.getOffset());
            this.addCenteredBracketInfo(centeredBracketInfo);
            return centeredBracketInfo;
        }

        private ShiftedBracketInfo processBracket(LMLifeLineBracket bracket, int offset, boolean shouldShiftRight, ShiftedBracketInfo parentBracketInfo) {
            LMMountingRegion mountingRegion;
            LMMountingLink mountingLink;
            if (bracket instanceof LMExecutionOccurence) {
                if (shouldShiftRight && !((LMExecutionOccurence)bracket).hasNoDuration()) {
                    offset += 10;
                }
                shouldShiftRight = !((LMExecutionOccurence)bracket).hasNoDuration();
            }
            ShiftedBracketInfo shiftedBracketInfo = new ShiftedBracketInfo(bracket, parentBracketInfo, offset);
            shiftedBracketInfo.adjustMaxRightPos(offset - 10 + 20);
            this.addShiftedBracketInfo(shiftedBracketInfo);
            if (bracket instanceof LMSendMessageEnd) {
                LMSendMessageEnd sendMessageEnd = (LMSendMessageEnd)((Object)bracket);
                this.collectLMMessages(sendMessageEnd);
            }
            LMFrame mountedFrame = null;
            if (bracket instanceof LMMountingRegion && (mountingLink = (mountingRegion = (LMMountingRegion)bracket).getMountingLink()) != null) {
                mountedFrame = mountingLink.getFrame();
            }
            FramesManager.FrameInfo frameInfo = null;
            if (mountedFrame != null) {
                frameInfo = this.myFrameManager.frameReferenceStarted(mountedFrame);
            }
            try {
                this.processBracketList(bracket.getChildBracketsList().getListView(), offset, shouldShiftRight, shiftedBracketInfo, frameInfo);
            }
            finally {
                if (mountedFrame != null) {
                    this.myFrameManager.frameReferenceFinished(mountedFrame);
                }
            }
            return shiftedBracketInfo;
        }

        private void collectLMMessages(LMSendMessageEnd sendMessageEnd) {
            Collection outgoingMessages = sendMessageEnd.getOutgoingLMMessages();
            this.myMessagesCollection.addAll(outgoingMessages);
        }

        private void addShiftedBracketInfo(ShiftedBracketInfo shiftedBracketInfo) {
            this.myShiftedBracketInfoList.add(shiftedBracketInfo);
        }

        private void addCenteredBracketInfo(CenteredBracketInfo centeredBracketInfo) {
            this.myCenteredBracketInfoList.add(centeredBracketInfo);
        }

        private void adjustLeftHalfWidth(int leftHalfWidth) {
            if (this.myLeftHalfWidth < leftHalfWidth) {
                this.myLeftHalfWidth = leftHalfWidth;
            }
        }

        private void adjustRigthHalfWidth(int rigthHalfWidth) {
            if (this.myRightHalfWidth < rigthHalfWidth) {
                this.myRightHalfWidth = rigthHalfWidth;
            }
        }
    }

    static interface PreparedLayout {
        public int getLeftHalfWidth();

        public int getRightHalfWidth();

        public int getCurrentCenterPos();

        public void layout(int var1);
    }

    private static class ShiftedBracketInfo {
        private final LMLifeLineBracket myBracket;
        private final ShiftedBracketInfo myParentBracketInfo;
        private final int myOffset;
        private int myMaxRightPos;

        ShiftedBracketInfo(LMLifeLineBracket lmLifeLineBracket, ShiftedBracketInfo parentBracketInfo, int offset) {
            this.myBracket = lmLifeLineBracket;
            this.myParentBracketInfo = parentBracketInfo;
            this.myMaxRightPos = 0;
            this.myOffset = offset;
        }

        public ShiftedBracketInfo getParentBracketInfo() {
            return this.myParentBracketInfo;
        }

        public LMLifeLineBracket getBracket() {
            return this.myBracket;
        }

        int getOffset() {
            return this.myOffset;
        }

        int getWidth() {
            return this.myMaxRightPos - (this.myOffset - 10);
        }

        int getMaxRightPos() {
            return this.myMaxRightPos;
        }

        void adjustMaxRightPos(int rightPos) {
            if (this.myMaxRightPos < rightPos) {
                this.myMaxRightPos = rightPos;
            }
        }
    }
}

