/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.horizontal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLine;

public class LifelineCoveringFramesCache {
    private final Map myLifelineAbsNodeToCoveringLmFrames = new HashMap();

    public LifelineCoveringFramesMover getLifelineCoveringFramesMover(AbsNode lifelineAbsNode) {
        return (LifelineCoveringFramesMover)this.myLifelineAbsNodeToCoveringLmFrames.get(lifelineAbsNode);
    }

    void setFrameOutermostLifelines(LMFrame lmFrame, LMLifeLine leftmost, LMLifeLine rightmost) {
        CoveringFramesMoverImpl leftListener = this.getOrCreateCoveringFramesMover(leftmost);
        leftListener.setLeftmostFor(lmFrame);
        CoveringFramesMoverImpl rightListener = this.getOrCreateCoveringFramesMover(rightmost);
        rightListener.setRightmostFor(lmFrame);
    }

    private CoveringFramesMoverImpl getOrCreateCoveringFramesMover(LMLifeLine lifeline) {
        AbsNode key = lifeline.getGdeNode();
        CoveringFramesMoverImpl result = (CoveringFramesMoverImpl)this.myLifelineAbsNodeToCoveringLmFrames.get(key);
        if (result == null) {
            result = new CoveringFramesMoverImpl();
            this.myLifelineAbsNodeToCoveringLmFrames.put(key, result);
        }
        return result;
    }

    private static class CoveringFramesMoverImpl
    implements LifelineCoveringFramesMover {
        private List myLeft;
        private List myRight;

        private CoveringFramesMoverImpl() {
        }

        @Override
        public void lifelineMoved(int horizontalDelta) {
            block5: {
                block4: {
                    if (horizontalDelta >= 0) break block4;
                    if (this.myRight == null) {
                        return;
                    }
                    int i = 0;
                    while (i < this.myRight.size()) {
                        LMFrame next = (LMFrame)this.myRight.get(i);
                        int newPos = next.getGdeNode().getX() + next.getGdeNode().getWidth() + horizontalDelta;
                        next.setRightBorderPosByTool(newPos);
                        ++i;
                    }
                    break block5;
                }
                if (horizontalDelta <= 0) break block5;
                if (this.myLeft == null) {
                    return;
                }
                int i = 0;
                while (i < this.myLeft.size()) {
                    LMFrame next = (LMFrame)this.myLeft.get(i);
                    int newPos = next.getGdeNode().getX() + horizontalDelta;
                    next.setLeftBorderPosByTool(newPos);
                    ++i;
                }
            }
        }

        void setLeftmostFor(LMFrame lmFrame) {
            if (this.myLeft == null) {
                this.myLeft = new ArrayList();
            }
            this.myLeft.add(lmFrame);
        }

        void setRightmostFor(LMFrame lmFrame) {
            if (this.myRight == null) {
                this.myRight = new ArrayList();
            }
            this.myRight.add(lmFrame);
        }
    }

    public static interface LifelineCoveringFramesMover {
        public void lifelineMoved(int var1);
    }
}

