/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.manage;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNodeEnumeration;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SdLayoutModelAddRemoveProcessor;

class ElementsAddRemoveOrderChecker
implements SdLayoutModelAddRemoveProcessor {
    final Set myLinks = new HashSet();
    final Set myNodes = new HashSet();

    ElementsAddRemoveOrderChecker() {
    }

    @Override
    public boolean processAddedGdeNode(AbsNode gdeNode) {
        this.myNodes.add(gdeNode);
        return true;
    }

    @Override
    public boolean processRemovedGdeNode(AbsNode gdeNode) {
        this.myNodes.remove(gdeNode);
        List children = this.findChildren(gdeNode);
        if (!children.isEmpty()) {
            throw new RuntimeException();
        }
        return true;
    }

    @Override
    public boolean processAddedGdeLink(AbsLink absLink) {
        if (!this.myNodes.contains(absLink.getSource())) {
            throw new RuntimeException();
        }
        if (!this.myNodes.contains(absLink.getDestination())) {
            throw new RuntimeException();
        }
        this.myLinks.add(absLink);
        return true;
    }

    @Override
    public boolean processRemovedGdeLink(AbsLink absLink) {
        this.myLinks.remove(absLink);
        return true;
    }

    @Override
    public void finish() {
    }

    List findChildren(AbsNode node) {
        ArrayList<AbsElement> result = new ArrayList<AbsElement>();
        AbsNodeEnumeration subnodes = node.subnodes();
        while (subnodes.hasMoreElements()) {
            AbsElement next = subnodes.nextGdeNode();
            if (!this.myNodes.contains(next)) continue;
            result.add(next);
        }
        for (AbsElement next : this.myLinks) {
            if (next.getSource() != node && next.getDestination() != node) continue;
            result.add(next);
        }
        return result;
    }
}

