/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.manage;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.gef.AbsDiagramGef;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.gef.AbsElementGef;
import org.eclipse.uml2.diagram.sequence.internal.layout.horizontal.SDHorizontalLayout;
import org.eclipse.uml2.diagram.sequence.internal.layout.manage.UpdateEventAccumulator;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.JustReshapedState;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmAlienElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmObjectsResolver;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmReshapable;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SDLayoutModel;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SdLayoutModelAccess;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.SDVerticalLayout;

public class SdGdeLayoutManager {
    private final AbsDiagramGef myAbsDiagramGef;
    private final LmAlienElement.Factory myAlienElementfactory = new LmAlienElement.Factory(){

        @Override
        public LmAlienElement createAlienNode(AbsNode gdeNode) {
            return new LmAlienElement(){

                @Override
                public void dispose() {
                }
            };
        }

        @Override
        public LmAlienElement createAlienLink(AbsLink gdeLink) {
            return new LmAlienElement(){

                @Override
                public void dispose() {
                }
            };
        }
    };
    private final LayoutModelHolder myLayoutModelHolder;
    private final SDHorizontalLayout myHorizontalLayout;
    private final SDVerticalLayout myVerticalLayout;
    final UpdateEventAccumulator myEvents;
    private final ReshapeServerImpl myServer = new ReshapeServerImpl();

    SdGdeLayoutManager(EditPartViewer diagram) {
        this.myAbsDiagramGef = new AbsDiagramGef(null);
        this.myEvents = new UpdateEventAccumulator(this.myAbsDiagramGef.getAbsElementFactory(), diagram.getContents());
        this.myLayoutModelHolder = new LayoutModelHolder();
        this.myHorizontalLayout = new SDHorizontalLayout(this.myLayoutModelHolder);
        SDVerticalLayout.Config verticalLayoutConfig = new SDVerticalLayout.Config(){};
        this.myVerticalLayout = new SDVerticalLayout(this.myLayoutModelHolder, verticalLayoutConfig);
    }

    public Collection initialLayout() {
        this.processUpdates();
        return Collections.EMPTY_LIST;
    }

    public Collection fullLayout(boolean forPrinting, Dimension gridDimension, Collection except) {
        this.applyLayoutConstraints();
        return Collections.EMPTY_LIST;
    }

    public Collection innerLayout(GraphicalEditPart subdiagram) {
        return null;
    }

    public Collection elementsReshaped(Collection elements) {
        this.myServer.incrementCode();
        JustReshapedState justReshapedState = new JustReshapedState(this.myServer);
        LmObjectsResolver resolver = this.myLayoutModelHolder.getLayoutModel().getLmObjectsResolver();
        for (IGraphicalEditPart editPart : elements) {
            Object lmObject = resolver.getLmObject(this.myAbsDiagramGef.getAbsElementFactory().createAbsElement(editPart));
            if (!(lmObject instanceof LmReshapable)) continue;
            ((LmReshapable)lmObject).setJustReshaped(justReshapedState);
        }
        this.applyLayoutConstraints();
        return elements;
    }

    public void elementsProperlyReshaped(Collection elements) {
    }

    public void elementAdded(IGraphicalEditPart element) {
        this.myEvents.elementAdded(element);
    }

    public void elementRemoved(ConnectionEditPart element) {
        this.myEvents.elementRemoved((IGraphicalEditPart)element);
    }

    public void processUpdates() {
        try {
            this.myEvents.accept(this.myLayoutModelHolder.getLayoutModel().newAddRemoveProcessor());
            this.applyLayoutConstraints();
        }
        finally {
            this.myEvents.clear();
        }
    }

    private void applyLayoutConstraints() {
        this.applyLayoutConstraintsImpl();
        assert (this.assertLayoutDoesntMoveElementsNow());
    }

    private boolean assertLayoutDoesntMoveElementsNow() {
        AbsDiagramGef.ChangePositionWatcher.ChangePositionListener nonexpectingChangePositionListener = new AbsDiagramGef.ChangePositionWatcher.ChangePositionListener(){

            @Override
            public void positionIsChanged(AbsElementGef absElement, int coordCode) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Positions are different second time");
                }
            }
        };
        this.myAbsDiagramGef.getChangePositionWatcher().setListener(nonexpectingChangePositionListener);
        try {
            this.applyLayoutConstraintsImpl();
        }
        finally {
            this.myAbsDiagramGef.getChangePositionWatcher().setListener(null);
        }
        return true;
    }

    private void applyLayoutConstraintsImpl() {
        this.myVerticalLayout.doLayout(false, 0);
        this.myHorizontalLayout.applyConstraints(0, false);
    }

    private class LayoutModelHolder
    implements SdLayoutModelAccess {
        private SDLayoutModel myLayoutModel;

        LayoutModelHolder() {
            this.createNewModelImpl(true);
        }

        @Override
        public SDLayoutModel getLayoutModel() {
            return this.myLayoutModel;
        }

        void createAnotherModel() {
            this.createNewModelImpl(true);
        }

        private void createNewModelImpl(boolean secondary) {
            this.myLayoutModel = new SDLayoutModel(SdGdeLayoutManager.this.myAbsDiagramGef, secondary, SdGdeLayoutManager.this.myAlienElementfactory, new SDLayoutModel.Config(){}, null);
        }
    }

    static class ReshapeServerImpl
    implements JustReshapedState.Server {
        private int myReshapeCode = 0;

        ReshapeServerImpl() {
        }

        @Override
        public int getCurrentReshapeCode() {
            return this.myReshapeCode;
        }

        void incrementCode() {
            ++this.myReshapeCode;
        }
    }
}

