/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.manage;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsElementPropertyAccess;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.gef.AbsDiagramGef;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.gef.AbsElementGef;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.gef.AbsNodeGef;
import org.eclipse.uml2.diagram.sequence.internal.layout.alien.AlienElementFactoryImpl;
import org.eclipse.uml2.diagram.sequence.internal.layout.alien.DummyAlienElementsLayout;
import org.eclipse.uml2.diagram.sequence.internal.layout.alien.IAlienElementsLayout;
import org.eclipse.uml2.diagram.sequence.internal.layout.horizontal.LifelineCoveringFramesCache;
import org.eclipse.uml2.diagram.sequence.internal.layout.horizontal.SDHorizontalLayout;
import org.eclipse.uml2.diagram.sequence.internal.layout.manage.AlienElementProcessor;
import org.eclipse.uml2.diagram.sequence.internal.layout.manage.InteractionLayouter;
import org.eclipse.uml2.diagram.sequence.internal.layout.manage.InteractionLinksProvider;
import org.eclipse.uml2.diagram.sequence.internal.layout.manage.LifelineMotionListener;
import org.eclipse.uml2.diagram.sequence.internal.layout.manage.UpdateEventAccumulator;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.JustReshapedState;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmAlienElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmObjectsResolver;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmReshapable;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SDLayoutModel;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SdLayoutModelAccess;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.SDVerticalLayout;
import org.eclipse.uml2.uml.Interaction;

public class SdLayoutAsInnerLayout
implements LifelineMotionListener {
    private final InteractionLinksProviderImpl myInteractionLinksProvider = new InteractionLinksProviderImpl();
    private final AbsDiagramGef myAbsDiagramWithRootNode;
    private final LmAlienElement.Factory myAlienElementfactory = new AlienElementFactoryImpl();
    private final LayoutModelHolder myLayoutModelHolder;
    private final SDHorizontalLayout myHorizontalLayout;
    private final SDVerticalLayout myVerticalLayout;
    private final UpdateEventAccumulator myEvents;
    private final ReshapeServerImpl myServer = new ReshapeServerImpl();
    private final Interaction myInteractionEntity;
    private final View myInteractionView;
    private AlienElementProcessor myAlienElementProcessor = new AlienElementProcessor();
    private final IAlienElementsLayout myAlienElementsLayout;
    private final Collection myAdditionalReshapeElements = new HashSet();
    private final AbsDiagramGef.ChangePositionWatcher.ChangePositionListener myAdditionalReshapeListener = new AbsDiagramGef.ChangePositionWatcher.ChangePositionListener(){

        @Override
        public void positionIsChanged(AbsElementGef absElement, int coordCode) {
            SdLayoutAsInnerLayout.this.myAdditionalReshapeElements.add(absElement.getEditPart());
        }
    };
    private static final boolean ourNeedAsserter;

    static {
        boolean b = false;
        if (!$assertionsDisabled) {
            b = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ourNeedAsserter = b;
    }

    public SdLayoutAsInnerLayout(InteractionEditPart modelNodeEditPart) {
        this(modelNodeEditPart, (Interaction)modelNodeEditPart.resolveSemanticElement());
    }

    public SdLayoutAsInnerLayout(InteractionEditPart modelNodeEditPart, Interaction interactionEntity) {
        this.myAbsDiagramWithRootNode = new AbsDiagramGef(modelNodeEditPart);
        this.myInteractionEntity = interactionEntity;
        this.myInteractionView = modelNodeEditPart.getNotationView();
        this.myEvents = new UpdateEventAccumulator(this.myAbsDiagramWithRootNode.getAbsElementFactory(), (EditPart)modelNodeEditPart);
        this.myLayoutModelHolder = new LayoutModelHolder(false);
        this.myHorizontalLayout = new SDHorizontalLayout(this.myLayoutModelHolder);
        SDVerticalLayout.Config verticalLayoutConfig = new SDVerticalLayout.Config(){};
        this.myVerticalLayout = new SDVerticalLayout(this.myLayoutModelHolder, verticalLayoutConfig);
        this.myAlienElementsLayout = new DummyAlienElementsLayout();
    }

    private void elementAdded(IGraphicalEditPart element) {
        this.myEvents.elementAdded(element);
    }

    private void elementRemoved(IGraphicalEditPart element) {
        this.myEvents.elementRemoved(element);
    }

    public void nodeAdded(GraphicalEditPart modelNodeEditPart) {
        this.elementAdded((IGraphicalEditPart)modelNodeEditPart);
    }

    public void nodeRemoved(GraphicalEditPart modelNodeEditPart) {
        this.elementRemoved((IGraphicalEditPart)modelNodeEditPart);
    }

    public void linkAdded(ConnectionEditPart modelLinkEditPart) {
        this.elementAdded((IGraphicalEditPart)modelLinkEditPart);
        this.myInteractionLinksProvider.add(modelLinkEditPart);
    }

    public void linkRemoved(ConnectionEditPart modelLinkEditPart) {
        this.elementRemoved((IGraphicalEditPart)modelLinkEditPart);
        this.myInteractionLinksProvider.remove(modelLinkEditPart);
    }

    public void elementReshaped(IGraphicalEditPart modelElementEditPart) {
        JustReshapedState justReshapedState = new JustReshapedState(this.myServer);
        AbsElementGef absElement = this.myAbsDiagramWithRootNode.getAbsElementFactory().createAbsElement(modelElementEditPart);
        this.myAlienElementProcessor.elementReshaped(absElement);
        LmObjectsResolver resolver = this.myLayoutModelHolder.getLayoutModel().getLmObjectsResolver();
        Object lmObject = resolver.getLmObject(absElement);
        if (lmObject instanceof LmReshapable) {
            this.startAdditionalReshapingListening();
            try {
                ((LmReshapable)lmObject).setJustReshaped(justReshapedState);
            }
            finally {
                this.stopAdditionalReshapingListening();
            }
        }
    }

    public Collection performLayout() {
        Collection result = this.performLayout(false);
        result.addAll(this.myAdditionalReshapeElements);
        this.myAdditionalReshapeElements.clear();
        return result;
    }

    public Collection performFullLayout() {
        if (!this.myAdditionalReshapeElements.isEmpty()) {
            throw new IllegalStateException();
        }
        return this.performLayout(true);
    }

    @Override
    public void lifelineMoved(int horizontalDelta, GraphicalEditPart lifelineEditPart) {
        LifelineCoveringFramesCache cache = this.myHorizontalLayout.getLifelineCoveringFramesCache();
        if (cache == null) {
            assert (false);
            return;
        }
        LifelineCoveringFramesCache.LifelineCoveringFramesMover mover = cache.getLifelineCoveringFramesMover(this.myAbsDiagramWithRootNode.getAbsElementFactory().createAbsNode(lifelineEditPart));
        if (mover != null) {
            this.startAdditionalReshapingListening();
            try {
                mover.lifelineMoved(horizontalDelta);
            }
            finally {
                this.stopAdditionalReshapingListening();
            }
        }
    }

    public InteractionLinksProvider getInteractionLilnksProvider() {
        return this.myInteractionLinksProvider;
    }

    private Collection performLayout(boolean fullLayout) {
        Collection result;
        try {
            this.myEvents.accept(this.myLayoutModelHolder.getLayoutModel().newAddRemoveProcessor());
            this.myEvents.accept(this.myAlienElementProcessor);
            result = this.performSdLayout(fullLayout);
        }
        finally {
            this.myEvents.clear();
            this.myAlienElementProcessor = new AlienElementProcessor();
        }
        this.myServer.incrementCode();
        return result;
    }

    private Collection performSdLayout(boolean fullLayout) {
        final HashSet result = new HashSet();
        final DebugPositionWatcherGate positionWatcher = ourNeedAsserter ? new DebugPositionWatcher() : DebugPositionWatcherGate.TRIVIAL;
        AbsDiagramGef.ChangePositionWatcher.ChangePositionListener changePositionListener = new AbsDiagramGef.ChangePositionWatcher.ChangePositionListener(){

            @Override
            public void positionIsChanged(AbsElementGef absElement, int coordCode) {
                result.add(absElement.getEditPart());
                positionWatcher.positionIsChanged(absElement, coordCode);
            }
        };
        this.myAbsDiagramWithRootNode.getChangePositionWatcher().setListener(changePositionListener);
        try {
            this.performSdLayoutImpl(fullLayout);
        }
        finally {
            this.myAbsDiagramWithRootNode.getChangePositionWatcher().setListener(null);
        }
        positionWatcher.finish();
        assert (this.assertLayoutDoesntMoveElementsNow(fullLayout));
        return result;
    }

    private boolean assertLayoutDoesntMoveElementsNow(boolean fullLayout) {
        AbsDiagramGef.ChangePositionWatcher.ChangePositionListener nonexpectingChangePositionListener = new AbsDiagramGef.ChangePositionWatcher.ChangePositionListener(){

            @Override
            public void positionIsChanged(AbsElementGef absElement, int coordCode) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Positions are different second time");
                }
            }
        };
        this.myAbsDiagramWithRootNode.getChangePositionWatcher().setListener(nonexpectingChangePositionListener);
        try {
            this.performSdLayoutImpl(fullLayout);
        }
        finally {
            this.myAbsDiagramWithRootNode.getChangePositionWatcher().setListener(null);
        }
        return true;
    }

    private void performSdLayoutImpl(boolean fullLayout) {
        AbsNode interactionNode = this.myAbsDiagramWithRootNode.getInteractionAbsNode();
        InteractionLayouter interactionLayouter = AbsElementPropertyAccess.getInstance().getInteractionLayouter(interactionNode);
        int pentagonHeight = interactionLayouter.getPentagonPreferredHeight();
        int clientAreaTop = interactionNode.getY() + pentagonHeight;
        int clientAreaLeft = interactionNode.getX() + 10;
        Dimension nativeElementsArea = this.performNativeLayoutImpl(clientAreaLeft, clientAreaTop, fullLayout);
        Dimension commonClientArea = this.performAlienLayoutImpl(clientAreaLeft, clientAreaTop, nativeElementsArea, fullLayout);
        if (interactionLayouter.isFullScreen()) {
            return;
        }
        int clientAreaWidth = commonClientArea.width;
        int clientAreaHeight = commonClientArea.height;
        clientAreaWidth = Math.max(clientAreaWidth, interactionLayouter.getPentagonPreferredWidth());
        int interactionWidth = 10 + clientAreaWidth + 10;
        int interactionHeight = pentagonHeight + clientAreaHeight + 10;
        if (interactionNode.getWidth() < interactionWidth) {
            interactionNode.setWidth(interactionWidth);
        }
        if (interactionNode.getHeight() < interactionHeight) {
            interactionNode.setHeight(interactionHeight);
        }
    }

    private Dimension performNativeLayoutImpl(int clientAreaLeft, int clientAreaTop, boolean fullLayout) {
        int bottomPos = this.myVerticalLayout.doLayout(fullLayout, clientAreaTop);
        int rightPos = this.myHorizontalLayout.applyConstraints(clientAreaLeft, fullLayout);
        int width = rightPos - clientAreaLeft;
        int height = bottomPos - clientAreaTop;
        return new Dimension(width, height);
    }

    private Dimension performAlienLayoutImpl(int clientAreaLeft, int clientAreaTop, Dimension nativeElementsArea, boolean fullLayout) {
        Dimension alienElementsArea;
        if (fullLayout) {
            int alienElementsAreaLeft = clientAreaLeft + nativeElementsArea.width;
            int alienElementsAreaTop = clientAreaTop + 10;
            alienElementsArea = this.myAlienElementsLayout.fullLayout(alienElementsAreaLeft, alienElementsAreaTop);
            alienElementsArea.width += nativeElementsArea.width;
        } else {
            Collection reshapedElements = this.myAlienElementProcessor.getReshapedGdeElements();
            alienElementsArea = this.myAlienElementsLayout.layoutReshaped(reshapedElements, clientAreaLeft, clientAreaTop);
        }
        alienElementsArea.width = Math.max(alienElementsArea.width, nativeElementsArea.width);
        alienElementsArea.height = Math.max(alienElementsArea.height, nativeElementsArea.height);
        return alienElementsArea;
    }

    private void startAdditionalReshapingListening() {
        this.myAbsDiagramWithRootNode.getChangePositionWatcher().setListener(this.myAdditionalReshapeListener);
    }

    private void stopAdditionalReshapingListening() {
        this.myAbsDiagramWithRootNode.getChangePositionWatcher().setListener(null);
    }

    private static class DebugPositionWatcher
    extends DebugPositionWatcherGate {
        private final List myHolders = new ArrayList();

        private DebugPositionWatcher() {
        }

        @Override
        void positionIsChanged(AbsElementGef absElement, int coordCode) {
            PositionHolder holder;
            this.validateAll();
            if (coordCode == 0) {
                return;
            }
            final AbsNodeGef node = (AbsNodeGef)absElement;
            switch (coordCode) {
                case 3: {
                    holder = new PositionHolder(){
                        int myX;
                        {
                            this.myX = absNodeGef.getX();
                        }

                        @Override
                        void validate() {
                            if (!$assertionsDisabled && node.getX() != this.myX) {
                                throw new AssertionError();
                            }
                        }
                    };
                    break;
                }
                case 1: {
                    holder = new PositionHolder(){
                        int myY;
                        {
                            this.myY = absNodeGef.getY();
                        }

                        @Override
                        void validate() {
                            if (!$assertionsDisabled && node.getY() != this.myY) {
                                throw new AssertionError();
                            }
                        }
                    };
                    break;
                }
                case 4: {
                    holder = new PositionHolder(){
                        int myWidth;
                        {
                            this.myWidth = absNodeGef.getWidth();
                        }

                        @Override
                        void validate() {
                            if (node.getWidth() != this.myWidth) {
                                throw new RuntimeException("Wrong width", this.getTrace());
                            }
                        }
                    };
                    break;
                }
                case 2: {
                    holder = new PositionHolder(){
                        int myHeight;
                        {
                            this.myHeight = absNodeGef.getHeight();
                        }

                        @Override
                        void validate() {
                            if (node.getHeight() != this.myHeight) {
                                throw new RuntimeException("Wrong height", this.getTrace());
                            }
                        }
                    };
                    break;
                }
                case 5: {
                    return;
                }
                default: {
                    throw new RuntimeException("Unknown coord code");
                }
            }
            this.myHolders.add(holder);
            holder.validate();
        }

        @Override
        void finish() {
            this.validateAll();
        }

        private void validateAll() {
            for (PositionHolder holder : this.myHolders) {
                holder.validate();
            }
        }

        abstract class PositionHolder {
            private final Exception myTrace = new Exception();

            PositionHolder() {
            }

            abstract void validate();

            Exception getTrace() {
                return this.myTrace;
            }
        }
    }

    private static abstract class DebugPositionWatcherGate {
        static final DebugPositionWatcherGate TRIVIAL = new DebugPositionWatcherGate(){

            @Override
            void positionIsChanged(AbsElementGef absElement, int coordCode) {
            }

            @Override
            void finish() {
            }
        };

        private DebugPositionWatcherGate() {
        }

        abstract void positionIsChanged(AbsElementGef var1, int var2);

        abstract void finish();
    }

    private static class InteractionLinksProviderImpl
    implements InteractionLinksProvider {
        private final Set myLinkEditParts = new HashSet();

        private InteractionLinksProviderImpl() {
        }

        @Override
        public Iterator linkEditParts() {
            return this.myLinkEditParts.iterator();
        }

        void add(ConnectionEditPart linkEditPart) {
            assert (!this.myLinkEditParts.contains(linkEditPart));
            this.myLinkEditParts.add(linkEditPart);
        }

        void remove(ConnectionEditPart linkEditPart) {
            assert (this.myLinkEditParts.contains(linkEditPart));
            this.myLinkEditParts.remove(linkEditPart);
        }
    }

    private class LayoutModelHolder
    implements SdLayoutModelAccess {
        private SDLayoutModel myLayoutModel;

        LayoutModelHolder(boolean readInitialState) {
            this.createNewModelImpl(readInitialState);
        }

        @Override
        public SDLayoutModel getLayoutModel() {
            return this.myLayoutModel;
        }

        void createAnotherModel() {
            this.createNewModelImpl(true);
        }

        private void createNewModelImpl(boolean secondary) {
            SDLayoutModel.RootElementsGetter interactionEntityGetter = new SDLayoutModel.RootElementsGetter(){
                private final AbsNode myRootNode;
                {
                    this.myRootNode = SdLayoutAsInnerLayout.this.myAbsDiagramWithRootNode.getInteractionAbsNode();
                }

                @Override
                public Interaction getInteractionEntity() {
                    return SdLayoutAsInnerLayout.this.myInteractionEntity;
                }

                @Override
                public View getInteractionView() {
                    return SdLayoutAsInnerLayout.this.myInteractionView;
                }

                @Override
                public AbsNode getRootNode() {
                    return this.myRootNode;
                }
            };
            this.myLayoutModel = new SDLayoutModel(SdLayoutAsInnerLayout.this.myAbsDiagramWithRootNode, secondary, SdLayoutAsInnerLayout.this.myAlienElementfactory, new SDLayoutModel.Config(){}, interactionEntityGetter);
        }
    }

    static class ReshapeServerImpl
    implements JustReshapedState.Server {
        private int myReshapeCode = 0;

        ReshapeServerImpl() {
        }

        @Override
        public int getCurrentReshapeCode() {
            return this.myReshapeCode;
        }

        void incrementCode() {
            ++this.myReshapeCode;
        }
    }
}

