/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNodeEnumeration;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.JustReshapedState;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMGenCallOccurence;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLineBracket;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmBracketsList;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmOwner;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmReshapable;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SDVerticalLayoutInputImpl;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SdLayoutUtil;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SelfReorderable;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineElement;
import org.eclipse.uml2.diagram.sequence.internal.missed.MissedMethods;

public abstract class LMBracketContainer
implements LmReshapable,
SelfReorderable {
    private JustReshapedState myJustReshapedState = null;
    private final AbsNode myGdeNode;
    private final LmOwner myLmOwner;

    LMBracketContainer(AbsNode gdeNode, LmOwner lmOwner) {
        this.myGdeNode = gdeNode;
        this.myLmOwner = lmOwner;
    }

    public abstract LmBracketsList getChildBracketsList();

    public AbsNode getGdeNode() {
        return this.myGdeNode;
    }

    abstract LMLifeLine getLifeLine();

    abstract LMFrame getContainingFrame();

    abstract LMGenCallOccurence getContainingCallOccurence();

    abstract LMLifeLineBracket getCreationCandidate();

    abstract LMLifeLineBracket getDestructionCandidate();

    abstract LMLifeLineBracket createChildBracketInstance(AbsNode var1, View var2);

    protected abstract Integer getClueValue();

    void assertChildBracketsInCorrectOrder() {
        if (this.myLmOwner.reorderAgainstModelNotGde()) {
            this.assertLmOrderAgainstModel();
        } else {
            this.assertGdeOrderAgainstModel();
            this.assertLmOrderAgainstGde();
        }
    }

    private void assertGdeOrderAgainstModel() {
        EObject entity = this.getGdeNode().getModelEntity();
        if (entity == null) {
            return;
        }
        List<EObject> modelChildren = MissedMethods._arcasMetamodelSpecific().getArcasMetamodelChildren(this.getGdeNode().getReference());
        HashSet<EObject> modelChildrenSet = new HashSet<EObject>(modelChildren);
        ArrayList<EObject> gdeOrderOfModelChildren = new ArrayList<EObject>();
        AbsNodeEnumeration gdeNodeEnum = this.getGdeNode().subnodes();
        while (gdeNodeEnum.hasMoreElements()) {
            AbsNode node1 = gdeNodeEnum.nextGdeNode();
            EObject nodeEntity1 = node1.getModelEntity();
            if (!modelChildrenSet.contains(nodeEntity1)) continue;
            gdeOrderOfModelChildren.add(nodeEntity1);
        }
        try {
            SdLayoutUtil.assertCorrectSubList(modelChildren, gdeOrderOfModelChildren);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Problem asserting order gde-model (updater-gde problem, probably)", e);
        }
    }

    private void assertLmOrderAgainstModel() {
        EObject entity = this.getGdeNode().getModelEntity();
        if (entity == null) {
            return;
        }
        ArrayList<EObject> entities = new ArrayList<EObject>();
        Iterator it = this.getChildBracketsList().iterator();
        while (it.hasNext()) {
            LMLifeLineBracket bracket1 = (LMLifeLineBracket)it.next();
            AbsNode node1 = bracket1.getGdeNode();
            EObject nodeEntity1 = node1.getModelEntity();
            if (nodeEntity1 == null) continue;
            entities.add(nodeEntity1);
        }
        List<EObject> realEntitiesList = MissedMethods._arcasMetamodelSpecific().getArcasMetamodelChildren(this.getGdeNode().getReference());
        try {
            SdLayoutUtil.assertCorrectSubList(realEntitiesList, entities);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Problem asserting order against model (lm reorder problem, probably)", e);
        }
    }

    private void assertLmOrderAgainstGde() {
        ArrayList<AbsNode> gdeNodes = new ArrayList<AbsNode>();
        Iterator it = this.getChildBracketsList().iterator();
        while (it.hasNext()) {
            LMLifeLineBracket bracket1 = (LMLifeLineBracket)it.next();
            AbsNode node1 = bracket1.getGdeNode();
            gdeNodes.add(node1);
        }
        try {
            SdLayoutUtil.assertCorrectSubList(Collections.list(this.getGdeNode().subnodes()), gdeNodes);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Problem asserting order against gde (our problem, probably)", e);
        }
    }

    @Override
    public void reorderChildElements() {
        if (this.myLmOwner.reorderAgainstModelNotGde()) {
            LinkedHashMap<EObject, Integer> entity2bracketIndex = new LinkedHashMap<EObject, Integer>();
            ArrayList<AbsNode> oldGdeOrder = new ArrayList<AbsNode>();
            int index = 0;
            Iterator it = this.getChildBracketsList().iterator();
            while (it.hasNext()) {
                LMLifeLineBracket bracket1 = (LMLifeLineBracket)it.next();
                AbsNode node1 = bracket1.getGdeNode();
                oldGdeOrder.add(node1);
                EObject nodeEntity1 = node1.getModelEntity();
                Integer anotherBracketIndex = entity2bracketIndex.put(nodeEntity1, new Integer(index));
                if (anotherBracketIndex != null) {
                    throw new RuntimeException("In container 2 brackets are associated with one entity");
                }
                ++index;
            }
            ArrayList<Integer> oldIndexList = new ArrayList<Integer>(this.getChildBracketsList().size());
            View reference = this.getGdeNode().getReference();
            for (EObject nextEntity : MissedMethods._arcasMetamodelSpecific().getArcasMetamodelChildren(reference)) {
                Integer oldIndex = (Integer)entity2bracketIndex.remove(nextEntity);
                if (oldIndex == null) continue;
                oldIndexList.add(oldIndex);
            }
            oldIndexList.addAll(entity2bracketIndex.values());
            this.getChildBracketsList().reorderList(oldIndexList);
        } else {
            LinkedHashMap<AbsNode, Integer> gdeNode2bracketIndex = new LinkedHashMap<AbsNode, Integer>();
            int index = 0;
            Iterator it = this.getChildBracketsList().iterator();
            while (it.hasNext()) {
                LMLifeLineBracket bracket1 = (LMLifeLineBracket)it.next();
                AbsNode node1 = bracket1.getGdeNode();
                Integer anotherBracketIndex = gdeNode2bracketIndex.put(node1, new Integer(index));
                if (anotherBracketIndex != null) {
                    throw new RuntimeException("In container 2 brackets are associated with one gde node");
                }
                ++index;
            }
            ArrayList<Integer> oldIndexList = new ArrayList<Integer>(this.getChildBracketsList().size());
            AbsNodeEnumeration gdeNodeEnum = this.getGdeNode().subnodes();
            while (gdeNodeEnum.hasMoreElements()) {
                AbsNode gdeNode1 = gdeNodeEnum.nextGdeNode();
                Integer oldIndex = (Integer)gdeNode2bracketIndex.remove(gdeNode1);
                if (oldIndex == null) continue;
                oldIndexList.add(oldIndex);
            }
            oldIndexList.addAll(gdeNode2bracketIndex.values());
            this.getChildBracketsList().reorderList(oldIndexList);
        }
    }

    public void reorderAfterReading() {
        if (this.myLmOwner.reorderAgainstModelNotGde()) {
            this.reorderChildElements();
        }
    }

    @Override
    public void setJustReshaped(JustReshapedState justReshapedState) {
        this.myJustReshapedState = justReshapedState;
    }

    protected boolean isJustReshaped() {
        if (this.myJustReshapedState == null) {
            return false;
        }
        return this.myJustReshapedState.isStillJustReshaped();
    }

    protected void setBracketTopPos(int pos) {
        this.getGdeNode().setY(pos);
    }

    protected void setBracketBottomPos(int pos) {
        this.getGdeNode().setHeight(pos - this.getGdeNode().getY());
    }

    protected int getBracketTopPos() {
        return this.getGdeNode().getY();
    }

    protected int getBracketBottomPos() {
        return this.getGdeNode().getY() + this.getGdeNode().getHeight();
    }

    protected LmOwner getLmOwner() {
        return this.myLmOwner;
    }

    protected class BracketBottomPosition
    implements LifeLineElement.Position {
        protected BracketBottomPosition() {
        }

        @Override
        public int getPositionValue() {
            return LMBracketContainer.this.getBracketBottomPos();
        }

        @Override
        public void setPositionValue(int pos) {
            LMBracketContainer.this.setBracketBottomPos(pos);
        }

        @Override
        public boolean isVirtual() {
            return false;
        }

        @Override
        public boolean isFirstPrioritedPosition() {
            return false;
        }

        @Override
        public boolean isLastPrioritedPosition() {
            return LMBracketContainer.this.isJustReshaped();
        }
    }

    protected class BracketTopPosition
    implements LifeLineElement.Position {
        protected BracketTopPosition() {
        }

        @Override
        public int getPositionValue() {
            return LMBracketContainer.this.getBracketTopPos();
        }

        @Override
        public void setPositionValue(int pos) {
            LMBracketContainer.this.setBracketTopPos(pos);
        }

        @Override
        public boolean isVirtual() {
            return false;
        }

        @Override
        public boolean isFirstPrioritedPosition() {
            return LMBracketContainer.this.isJustReshaped();
        }

        @Override
        public boolean isLastPrioritedPosition() {
            return false;
        }
    }

    protected class ChildBracketsNFIterator
    implements SDVerticalLayoutInputImpl.NullFreeIterator {
        private final Iterator myIterator;

        protected ChildBracketsNFIterator() {
            this.myIterator = LMBracketContainer.this.getChildBracketsList().iterator();
        }

        @Override
        public Object next() {
            if (!this.myIterator.hasNext()) {
                return null;
            }
            LMLifeLineBracket bracket1 = (LMLifeLineBracket)this.myIterator.next();
            return bracket1.verticalLayoutElements();
        }
    }
}

