/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.util.AbstractList;
import java.util.List;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMCallMessage;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMReturnMessage;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMSendMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.HorizontalConstraint;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineElement;

public class LMCallMessageSynch
extends LMCallMessage {
    private HorizontalConstraintImpl myTopHorizontalConstraint;
    private HorizontalConstraintImpl myBottomHorizontalConstraint;

    public LMCallMessageSynch(AbsLink gdeLink) {
        super(gdeLink);
    }

    HorizontalConstraintImpl getTopHorizontalConstraint() {
        return this.myTopHorizontalConstraint;
    }

    HorizontalConstraintImpl getBottomHorizontalConstraint() {
        return this.myBottomHorizontalConstraint;
    }

    @Override
    void becomeLayoutConstraint(boolean on) {
        if (on) {
            if (this.getReceiveVerticalPositioning().canSetMessageAsHorizontalConstraint(this) && this.getSendVerticalPositioning().canSetMessageAsHorizontalConstraint(this)) {
                this.switchOnTopHorizontalConstraint(this.getSendVerticalPositioning(), this.getReceiveVerticalPositioning());
                this.getSendVerticalPositioning().setMessageAsHorizontalConstraint(this, true);
                this.getReceiveVerticalPositioning().setMessageAsHorizontalConstraint(this, true);
                LifeLineElement sendBottomLifeLineElement = this.getSendVerticalPositioning().getBottomLifeLineElement();
                LifeLineElement receiveBottomLifeLineElement = this.getReceiveVerticalPositioning().getBottomLifeLineElement();
                if (sendBottomLifeLineElement != null && receiveBottomLifeLineElement != null) {
                    this.switchOnBottomHorizontalConstraint(sendBottomLifeLineElement, receiveBottomLifeLineElement);
                }
            } else {
                this.setVerticalConstraintViolationState(true);
                LMSendMessageEnd sendMessageEnd = this.getSendMessageEnd();
                if (sendMessageEnd == null) {
                    return;
                }
                LMReturnMessage returnMessage = sendMessageEnd.findReturnMessage(this);
                if (returnMessage != null) {
                    returnMessage.setVerticalConstraintViolationState(true);
                }
            }
        } else {
            this.switchOffBottomHorizontalConstraint();
            this.switchOffTopHorizontalConstraint();
            this.getSendVerticalPositioning().setMessageAsHorizontalConstraint(this, false);
            this.getReceiveVerticalPositioning().setMessageAsHorizontalConstraint(this, false);
        }
    }

    @Override
    boolean isLayoutConstraint() {
        return this.myTopHorizontalConstraint != null;
    }

    private void switchOnTopHorizontalConstraint(LMMessageEnd.VerticalConstraintedPositioning sendEndPositioning, LMMessageEnd.VerticalConstraintedPositioning receiveEndPositioning) {
        if (this.myTopHorizontalConstraint != null) {
            throw new RuntimeException("Top constraint already created");
        }
        this.myTopHorizontalConstraint = new HorizontalConstraintImpl(){

            @Override
            protected void setLMMessageViolationState(boolean violated) {
                LMCallMessageSynch.this.setVerticalConstraintViolationState(violated);
            }
        };
        this.myTopHorizontalConstraint.getConstratintedLifeLineElements().setSendLifeLineElement(sendEndPositioning.getTopLifeLineElement());
        this.myTopHorizontalConstraint.getConstratintedLifeLineElements().setReceiveLifeLineElement(receiveEndPositioning.getTopLifeLineElement());
    }

    private void switchOffTopHorizontalConstraint() {
        this.myTopHorizontalConstraint = null;
    }

    private void switchOnBottomHorizontalConstraint(LifeLineElement sendLifeLineElement, LifeLineElement receiveLifeLineElement) {
        if (this.myBottomHorizontalConstraint != null) {
            throw new RuntimeException("Bottom constraint already created");
        }
        this.myBottomHorizontalConstraint = new HorizontalConstraintImpl(){

            @Override
            protected void setLMMessageViolationState(boolean violated) {
                LMSendMessageEnd sendMessageEnd = LMCallMessageSynch.this.getSendMessageEnd();
                if (sendMessageEnd == null) {
                    return;
                }
                LMReturnMessage returnMessage = sendMessageEnd.findReturnMessage(LMCallMessageSynch.this);
                if (returnMessage != null) {
                    returnMessage.setVerticalConstraintViolationState(violated);
                }
            }
        };
        this.myBottomHorizontalConstraint.getConstratintedLifeLineElements().setSendLifeLineElement(sendLifeLineElement);
        this.myBottomHorizontalConstraint.getConstratintedLifeLineElements().setReceiveLifeLineElement(receiveLifeLineElement);
    }

    private void switchOffBottomHorizontalConstraint() {
        this.myBottomHorizontalConstraint = null;
    }

    private static class ConstratintedLifeLineElements
    extends AbstractList {
        private LifeLineElement myExecutionLifeLineElement;
        private LifeLineElement myInvocationLifeLineElement;

        private ConstratintedLifeLineElements() {
        }

        @Override
        public Object get(int pos) {
            switch (pos) {
                case 0: {
                    return this.getExecutionLifeLineElement();
                }
                case 1: {
                    return this.getInvocationLifeLineElement();
                }
            }
            throw new IndexOutOfBoundsException(String.valueOf(pos) + ", size=2");
        }

        @Override
        public int size() {
            return 2;
        }

        LifeLineElement getExecutionLifeLineElement() {
            return this.myExecutionLifeLineElement;
        }

        void setReceiveLifeLineElement(LifeLineElement executionLifeLineElement) {
            this.myExecutionLifeLineElement = executionLifeLineElement;
        }

        LifeLineElement getInvocationLifeLineElement() {
            return this.myInvocationLifeLineElement;
        }

        void setSendLifeLineElement(LifeLineElement invocationLifeLineElement) {
            this.myInvocationLifeLineElement = invocationLifeLineElement;
        }

        void setLifeLineElement(LifeLineElement lifeLineElement, boolean invocationNotExecution) {
            if (invocationNotExecution) {
                this.setSendLifeLineElement(lifeLineElement);
            } else {
                this.setReceiveLifeLineElement(lifeLineElement);
            }
        }
    }

    private abstract class HorizontalConstraintImpl
    implements HorizontalConstraint {
        private ConstratintedLifeLineElements myConstraintedElements = new ConstratintedLifeLineElements();
        private boolean myExecutionViolated = false;
        private boolean myInteractionViolated = false;

        private HorizontalConstraintImpl() {
        }

        @Override
        public void elementIsResolved(LifeLineElement lifeLineElement) {
            if (lifeLineElement == this.myConstraintedElements.getExecutionLifeLineElement()) {
                this.myExecutionViolated = false;
            } else {
                this.myInteractionViolated = false;
            }
            this.updateViolationState();
        }

        @Override
        public void elementIsViolated(LifeLineElement lifeLineElement) {
            if (lifeLineElement == this.myConstraintedElements.getExecutionLifeLineElement()) {
                this.myExecutionViolated = true;
            } else {
                this.myInteractionViolated = true;
            }
            this.updateViolationState();
        }

        public List getLifeLineElementsList() {
            return this.myConstraintedElements;
        }

        ConstratintedLifeLineElements getConstratintedLifeLineElements() {
            return this.myConstraintedElements;
        }

        private void updateViolationState() {
            boolean violatedNow = this.myExecutionViolated || this.myInteractionViolated;
            this.setLMMessageViolationState(violatedNow);
        }

        protected abstract void setLMMessageViolationState(boolean var1);
    }
}

