/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.BracketMetaObject;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMGenCallOccurence;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMInvocationOccurence;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLineBracket;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMessage;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMReceiveMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMReturnMessage;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMSelfMessage;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMSendMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmOwner;
import org.eclipse.uml2.diagram.sequence.internal.missed.MissedMethods;

public class LMExecutionOccurence
extends LMGenCallOccurence
implements LMReceiveMessageEnd {
    private final PositioningImpl myPositioningImpl = new PositioningImpl();
    private final boolean myIsFoundMessageHidden;
    private final boolean myIsCreationInModel;
    private final boolean myIsDestructionInModel;
    private LMLifeLine myCreatedLifeline;
    private LMLifeLine myDestructedLifeline;

    LMExecutionOccurence(AbsNode gdeBracketNode, BracketMetaObject bracketMetaObject, LmOwner lmOwner) {
        super(gdeBracketNode, bracketMetaObject, lmOwner);
        this.myIsFoundMessageHidden = LMExecutionOccurence.isHideFoundMessage(gdeBracketNode);
        this.myIsCreationInModel = LMExecutionOccurence.isCreation(gdeBracketNode);
        this.myIsDestructionInModel = LMExecutionOccurence.isDestruction(gdeBracketNode);
    }

    boolean isCreationInModel() {
        return this.myIsCreationInModel;
    }

    boolean isDestructionInModel() {
        return this.myIsDestructionInModel;
    }

    @Override
    LMLifeLineBracket getDestructionCandidateInCallOccurence() {
        if (this.isDestructionInModel()) {
            return this;
        }
        return super.getDestructionCandidateInCallOccurence();
    }

    @Override
    public LMMessageEnd.Positioning getPositioning() {
        return this.myPositioningImpl;
    }

    @Override
    protected boolean getLMMessageEndSourceNotDestination(LMMessage lmMessage) {
        return !lmMessage.isFromSendToReceive();
    }

    @Override
    protected int getTopOutSpace() {
        if (this.isCreationInLayout()) {
            return super.getTopOutSpace() + this.getLifeLine().getHeadHeight() / 2;
        }
        List callMessagesList = this.getToplMessagesList();
        if (!callMessagesList.isEmpty() && callMessagesList.get(0) instanceof LMSelfMessage) {
            return 3;
        }
        return super.getTopOutSpace();
    }

    @Override
    protected int getTopInSpace() {
        if (this.isCreationInLayout()) {
            return super.getTopInSpace() + this.getLifeLine().getHeadHeight() / 2;
        }
        return super.getTopInSpace();
    }

    @Override
    protected void setBracketTopPos(int pos) {
        if (this.isCreationInLayout()) {
            LMLifeLine lifeLine = this.getLifeLine();
            lifeLine.setLifeLineGdeTopPos(pos - lifeLine.getHeadHeight() / 2);
            pos += lifeLine.getHeadHeight() / 2 - 1;
        }
        super.setBracketTopPos(pos);
    }

    @Override
    protected boolean isMessageTopNotBottom(LMMessage lmMessage) {
        LMSelfMessage selfMessage;
        LMReturnMessage returnMessage;
        if (lmMessage instanceof LMReturnMessage ? (returnMessage = (LMReturnMessage)lmMessage).isAsynchronous() : lmMessage instanceof LMSelfMessage && !(selfMessage = (LMSelfMessage)lmMessage).isFromSendToReceive() && selfMessage.isAsynchronous()) {
            return true;
        }
        return super.isMessageTopNotBottom(lmMessage);
    }

    @Override
    protected int getBracketTopPos() {
        int y;
        if (this.isCreationInLayout() && (y = this.getGdeNode().getY()) != 0) {
            return y - this.getLifeLine().getHeadHeight() / 2 + 1;
        }
        int result = super.getBracketTopPos();
        if (result == 0) {
            Iterator it = this.getChildBracketsList().iterator();
            while (it.hasNext()) {
                LMGenCallOccurence genCallOccurence;
                LMLifeLineBracket nextBracket = (LMLifeLineBracket)it.next();
                if (nextBracket instanceof LMGenCallOccurence && (result = (genCallOccurence = (LMGenCallOccurence)nextBracket).getBracketTopPos()) != 0) break;
            }
        }
        return result;
    }

    @Override
    protected String getDebugId() {
        EObject nodeEntity = this.getGdeNode().getModelEntity();
        return "Execution-" + nodeEntity;
    }

    @Override
    protected boolean calculateIsBracketConsistent() {
        return super.calculateIsBracketConsistent() && this.isCreationDestructionConsistent();
    }

    private boolean isCreationDestructionConsistent() {
        return this.isCreationInLayout() == this.isCreationInModel() && this.isDestructionInLayout() == this.isDestructionInModel();
    }

    @Override
    Color setErrorDisplayColor(Color color) {
        Color oldColor = this.getGdeNode().getForeground();
        this.getGdeNode().setForeground(color);
        return oldColor;
    }

    @Override
    protected boolean isIncomingOutgoingMessagesOK() {
        return this.myIsFoundMessageHidden || super.isIncomingOutgoingMessagesOK();
    }

    private boolean isCreationInLayout() {
        return this.myCreatedLifeline != null;
    }

    void setCreatedLifeline(LMLifeLine lifeLine) {
        this.myCreatedLifeline = lifeLine;
    }

    private boolean isDestructionInLayout() {
        return this.myDestructedLifeline != null;
    }

    void setDestructedLifeline(LMLifeLine lifeLine) {
        this.myDestructedLifeline = lifeLine;
    }

    private static boolean isHideFoundMessage(AbsNode absNode) {
        View reference = absNode.getReference();
        return reference != null && MissedMethods._executionSpecification().isHideFoundMessage(reference);
    }

    private static boolean isDestruction(AbsNode absNode) {
        View reference = absNode.getReference();
        return reference != null && MissedMethods._executionSpecification().isDestruction(reference);
    }

    private static boolean isCreation(AbsNode absNode) {
        View reference = absNode.getReference();
        return reference != null && MissedMethods._executionSpecification().isCreation(reference);
    }

    private class PositioningImpl
    extends LMGenCallOccurence.PositioningGen
    implements LMReceiveMessageEnd.HorizontalPositioning {
        private PositioningImpl() {
            super(LMExecutionOccurence.this);
        }

        @Override
        public int getReceiveMiddleXPos() {
            return LMExecutionOccurence.this.getGdeNode().getX() + 20;
        }

        @Override
        public int getReceiveEndXPos(boolean toRightNotLeft) {
            if (LMExecutionOccurence.this.isCreationInLayout()) {
                return this.getLifeLine().getCreationReceiveEndXPos(toRightNotLeft);
            }
            int x = LMExecutionOccurence.this.getGdeNode().getX();
            if (LMExecutionOccurence.this.hasNoDuration()) {
                LMMessage callMessage;
                LMInvocationOccurence invocation;
                LMGenCallOccurence containingCallOccurence = LMExecutionOccurence.this.getContainer().getContainingCallOccurence();
                if (containingCallOccurence == null) {
                    return x + 10;
                }
                if (containingCallOccurence instanceof LMInvocationOccurence && !(invocation = (LMInvocationOccurence)containingCallOccurence).getToplMessagesList().isEmpty() && (callMessage = (LMMessage)invocation.getToplMessagesList().get(0)).getReceiveMessageEnd() == LMExecutionOccurence.this) {
                    LMSendMessageEnd.HorizontalPositioning sendPositioning = (LMSendMessageEnd.HorizontalPositioning)invocation.getPositioning();
                    return sendPositioning.getSendEndXPos(toRightNotLeft);
                }
            }
            if (toRightNotLeft) {
                return x + 20;
            }
            return x;
        }

        @Override
        public int getReceiveEndXPosForSynchReturnNotCallLink(boolean toRightNotLeft) {
            if (LMExecutionOccurence.this.isCreationInLayout() && !LMExecutionOccurence.this.hasNoDuration()) {
                int pos = LMExecutionOccurence.this.getGdeNode().getX();
                if (toRightNotLeft) {
                    pos += 20;
                }
                return pos;
            }
            return this.getReceiveEndXPos(toRightNotLeft);
        }
    }
}

