/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFoundInvocationOccurence;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMVisibleFrameWithPentagon;

public class LMFrameContainer {
    private ContainerFriendly mySelfFriendly = new ContainerFriendly(){

        @Override
        public void childRemove(LMFrame lmFrame) {
            boolean result = LMFrameContainer.this.myChildFrames.remove(lmFrame);
            if (!result) {
                throw new RuntimeException("Can't remove child");
            }
        }

        @Override
        public void childRemove(LMFoundInvocationOccurence lmFoundInvocationOccurence) {
            boolean result = LMFrameContainer.this.myChildFoundInvocations.remove(lmFoundInvocationOccurence);
            if (!result) {
                throw new RuntimeException("Can't remove child");
            }
        }

        @Override
        public LMFrameContainer getLMFrameContainer() {
            return LMFrameContainer.this;
        }
    };
    private final List myChildFrames = new ArrayList(3);
    private List myUnmodifiableChildList = null;
    private final List myChildFoundInvocations = new ArrayList(3);
    private List myUnmodifiableFoundInvocationsList = null;

    void addChildFrame(LMFrame childFrame) {
        childFrame.setContainer(this.mySelfFriendly);
        this.myChildFrames.add(childFrame);
    }

    public List getChildList() {
        if (this.myUnmodifiableChildList == null) {
            this.myUnmodifiableChildList = Collections.unmodifiableList(this.myChildFrames);
        }
        return this.myUnmodifiableChildList;
    }

    void addChildFoundInvocation(LMFoundInvocationOccurence foundInvocationOccurence) {
        foundInvocationOccurence.setContainer(this.mySelfFriendly);
        this.myChildFoundInvocations.add(foundInvocationOccurence);
    }

    public List getFoundInvocationsList() {
        if (this.myUnmodifiableFoundInvocationsList == null) {
            this.myUnmodifiableFoundInvocationsList = Collections.unmodifiableList(this.myChildFoundInvocations);
        }
        return this.myUnmodifiableFoundInvocationsList;
    }

    public void layoutVerticallyUtiedFrames(int y) {
        int i = 0;
        while (i < this.myChildFrames.size()) {
            LMFrame frame1 = (LMFrame)this.myChildFrames.get(i);
            if (!frame1.hasAnyMountingLinks()) {
                y += UntiedFrameVerticalLayouter.layoutAndReturnHeight(frame1, y) + 10;
            }
            ++i;
        }
    }

    static interface ContainerFriendly {
        public void childRemove(LMFrame var1);

        public void childRemove(LMFoundInvocationOccurence var1);

        public LMFrameContainer getLMFrameContainer();
    }

    private static class UntiedFrameVerticalLayouter {
        private UntiedFrameVerticalLayouter() {
        }

        static int layoutAndReturnHeight(LMFrame lmFrame, int y) {
            lmFrame.setTopBorderPos(y);
            int yPos = y + lmFrame.getTopInnerPadding();
            List childList = lmFrame.getChildList();
            int i = 0;
            while (i < childList.size()) {
                LMFrame childFrame = (LMFrame)childList.get(i);
                int childHeight = UntiedFrameVerticalLayouter.layoutAndReturnHeight(childFrame, yPos += childFrame.getOuterHorizontalPadding());
                yPos += childHeight;
                yPos += childFrame.getOuterHorizontalPadding();
                ++i;
            }
            yPos += lmFrame.getBottomInnerPadding();
            int minHeight = 10;
            if (lmFrame instanceof LMVisibleFrameWithPentagon && childList.isEmpty()) {
                LMVisibleFrameWithPentagon visibleFrameWithPentagon = (LMVisibleFrameWithPentagon)lmFrame;
                minHeight = Math.max(minHeight, visibleFrameWithPentagon.getPreferredHeight());
            }
            if (yPos < y + minHeight) {
                yPos = y + minHeight;
            }
            lmFrame.setBottomBorderPos(yPos);
            return yPos - y;
        }
    }
}

