/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.BracketMetaObject;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.JustReshapedState;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMBracketContainer;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMCallMessageSynch;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLineBracket;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMessage;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmBracketsList;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmBracketsListSimple;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmOwner;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SDVerticalLayoutInputImpl;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.HorizontalConstraint;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.OrderingConstraint;

public abstract class LMGenCallOccurence
extends LMLifeLineBracket
implements LMMessageEnd {
    private final BoundaryLifeLineElement myTopLifeLineElement;
    private final BoundaryLifeLineElement myBottomLifeLineElement;
    private final LmBracketsList myChildBracketsList = new LmBracketsListSimple();
    private LMCallMessageSynch myHorizontalConstraintCallMessage = null;
    private LMLifeLine myLifelineToProvideBottomPos;

    LMGenCallOccurence(AbsNode gdeBracketNode, BracketMetaObject bracketMetaObject, LmOwner lmOwner) {
        super(gdeBracketNode, bracketMetaObject, lmOwner);
        this.myTopLifeLineElement = new BoundaryLifeLineElement(new LMBracketContainer.BracketTopPosition(), bracketMetaObject.getTopOutSpace(), bracketMetaObject.getTopOutSpace() + bracketMetaObject.getTopInSpace()){

            @Override
            public HorizontalConstraint getHorizontalConstraint() {
                if (LMGenCallOccurence.this.myHorizontalConstraintCallMessage == null) {
                    return null;
                }
                LMCallMessageSynch.HorizontalConstraintImpl result = LMGenCallOccurence.this.myHorizontalConstraintCallMessage.getTopHorizontalConstraint();
                return result;
            }

            @Override
            public int getSize() {
                return LMGenCallOccurence.this.getTopOutSpace() + LMGenCallOccurence.this.getTopInSpace();
            }

            @Override
            public int getPointOffset() {
                return LMGenCallOccurence.this.getTopOutSpace();
            }

            @Override
            int getMessagesVerticalPosOffset() {
                return 0;
            }

            public String toString() {
                return String.valueOf(LMGenCallOccurence.this.getDebugId()) + "-Top";
            }
        };
        this.myBottomLifeLineElement = new BoundaryLifeLineElement(new LMBracketContainer.BracketBottomPosition(), bracketMetaObject.getBottomInSpace(), bracketMetaObject.getBottomInSpace() + bracketMetaObject.getBottomOutSpace()){

            @Override
            public HorizontalConstraint getHorizontalConstraint() {
                if (LMGenCallOccurence.this.myHorizontalConstraintCallMessage == null) {
                    return null;
                }
                LMCallMessageSynch.HorizontalConstraintImpl result = LMGenCallOccurence.this.myHorizontalConstraintCallMessage.getBottomHorizontalConstraint();
                return result;
            }

            @Override
            protected void setPositionValue(int pos, boolean doNotReshapeMessages) {
                if (LMGenCallOccurence.this.hasNoDuration()) {
                    pos = LMGenCallOccurence.this.myTopLifeLineElement.getPositionValue() + LMGenCallOccurence.this.getBracketMetaObject().getTopInSpace() + LMGenCallOccurence.this.getBracketMetaObject().getBottomInSpace();
                }
                super.setPositionValue(pos, doNotReshapeMessages);
            }

            @Override
            public boolean isVirtual() {
                return LMGenCallOccurence.this.hasNoDuration();
            }

            @Override
            int getMessagesVerticalPosOffset() {
                return -1;
            }

            public String toString() {
                return String.valueOf(LMGenCallOccurence.this.getDebugId()) + "-Bottom";
            }
        };
    }

    @Override
    LMLifeLineBracket getDestructionCandidate() {
        return this.getDestructionCandidateInCallOccurence();
    }

    @Override
    LMLifeLineBracket getDestructionCandidateInCallOccurence() {
        if (this.getChildBracketsList().isEmpty()) {
            return null;
        }
        List listView = this.getChildBracketsList().getListView();
        LMLifeLineBracket lastBracket = (LMLifeLineBracket)listView.get(listView.size() - 1);
        return lastBracket.getDestructionCandidateInCallOccurence();
    }

    void setLifelineToProvideBottomPos(LMLifeLine lifeLine) {
        this.myLifelineToProvideBottomPos = lifeLine;
    }

    @Override
    public LMFrame getContainingFrame() {
        return super.getContainingFrame();
    }

    @Override
    LMGenCallOccurence getContainingCallOccurence() {
        return this;
    }

    protected abstract String getDebugId();

    protected int getTopOutSpace() {
        return this.getBracketMetaObject().getTopOutSpace();
    }

    protected int getTopInSpace() {
        return this.getBracketMetaObject().getTopInSpace();
    }

    @Override
    public SDVerticalLayoutInputImpl.NullFreeIterator verticalLayoutElements() {
        return new SDVerticalLayoutInputImpl.NullFreeIteratorForArray(5){

            @Override
            protected Object get(int pos) {
                switch (pos) {
                    case 0: {
                        return LMGenCallOccurence.this.myTopLifeLineElement;
                    }
                    case 1: {
                        return LMGenCallOccurence.this.getClueValue();
                    }
                    case 2: {
                        return new LMBracketContainer.ChildBracketsNFIterator();
                    }
                    case 3: {
                        return LMGenCallOccurence.this.getClueValue();
                    }
                    case 4: {
                        return LMGenCallOccurence.this.myBottomLifeLineElement;
                    }
                }
                throw new IndexOutOfBoundsException();
            }
        };
    }

    @Override
    public boolean isLimitedHorizontally() {
        return true;
    }

    @Override
    protected void setBracketBottomPos(int pos) {
        if (this.myLifelineToProvideBottomPos != null) {
            this.myLifelineToProvideBottomPos.setLifeLineGdeBottomPos(pos);
        }
        super.setBracketBottomPos(pos);
    }

    @Override
    public void addMessage(LMMessage lmMessage) {
        if (this.isMessageTopNotBottom(lmMessage)) {
            this.addTopMessage(lmMessage);
        } else {
            this.addBottomMessage(lmMessage);
        }
    }

    @Override
    public void removeMessage(LMMessage lmMessage) {
        if (this.isMessageTopNotBottom(lmMessage)) {
            this.removeTopMessage(lmMessage);
        } else {
            this.removeBottomMessage(lmMessage);
        }
    }

    @Override
    public void messageIsJustReshaped(LMMessage lmMessage, JustReshapedState justReshapedState) {
        boolean sendNotReceive = lmMessage.getSendMessageEnd() == this;
        boolean topNotBottom = this.isMessageTopNotBottom(lmMessage);
        boolean sourceNotDestination = !sendNotReceive ^ topNotBottom;
        BoundaryLifeLineElement position = topNotBottom ? this.getTopBoundaryLifeLineElement() : this.getBottomBoundaryLifeLineElement();
        int pos = lmMessage.getLMMessageEndVerticalPosition(sourceNotDestination);
        position.setPositionValueFromMessage(pos);
        this.setJustReshaped(justReshapedState);
    }

    @Override
    public LmBracketsList getChildBracketsList() {
        return this.myChildBracketsList;
    }

    protected boolean isMessageTopNotBottom(LMMessage lmMessage) {
        return lmMessage.isFromSendToReceive();
    }

    public boolean hasNoDuration() {
        return this.myChildBracketsList.isEmpty() && this.getBracketMetaObject().tieBottomToTop();
    }

    private void addTopMessage(LMMessage lmCallMessage) {
        this.getTopBoundaryLifeLineElement().getLMMesssagesList().add(lmCallMessage);
    }

    private void addBottomMessage(LMMessage lmReturnMessage) {
        this.getBottomBoundaryLifeLineElement().getLMMesssagesList().add(lmReturnMessage);
    }

    private void removeTopMessage(LMMessage lmCallMessage) {
        if (this.myHorizontalConstraintCallMessage == lmCallMessage) {
            throw new IllegalArgumentException("Cannot remove lmCallMessage, before it removed from constraints");
        }
        this.getTopBoundaryLifeLineElement().getLMMesssagesList().remove(lmCallMessage);
    }

    private void removeBottomMessage(LMMessage lmReturnMessage) {
        this.getBottomBoundaryLifeLineElement().getLMMesssagesList().remove(lmReturnMessage);
    }

    List getToplMessagesList() {
        return this.getTopBoundaryLifeLineElement().getLMMesssagesList();
    }

    public BoundaryLifeLineElement getBottomBoundaryLifeLineElement() {
        return this.myBottomLifeLineElement;
    }

    public BoundaryLifeLineElement getTopBoundaryLifeLineElement() {
        return this.myTopLifeLineElement;
    }

    @Override
    protected int getBracketTopPos() {
        int result = super.getBracketTopPos();
        if (result == 0) {
            for (LMMessage lmMessage : this.getTopBoundaryLifeLineElement().getLMMesssagesList()) {
                int y;
                boolean getGdeStartNotEnd = !this.getLMMessageEndSourceNotDestination(lmMessage) ^ lmMessage.isFromSendToReceive();
                Point[] points = lmMessage.getGdeLink().getLinkPoints();
                if (points == null || points.length <= 0 || (y = getGdeStartNotEnd ? points[0].y : points[points.length - 1].y) == 0) continue;
                result = y;
                break;
            }
        }
        return result;
    }

    protected abstract boolean getLMMessageEndSourceNotDestination(LMMessage var1);

    protected void setLMMessageEndVerticalPosition(LMMessage lmMessage, int pos, int siblingNumber) {
        boolean changeGdeStartNotEnd = !this.getLMMessageEndSourceNotDestination(lmMessage) ^ lmMessage.isFromSendToReceive();
        lmMessage.setLMMessageEndVerticalPosition(pos, changeGdeStartNotEnd, siblingNumber);
    }

    @Override
    public void setHorizontalPosition(int newPos) {
    }

    @Override
    protected boolean calculateIsBracketConsistent() {
        return super.calculateIsBracketConsistent() && this.isIncomingOutgoingMessagesOK();
    }

    protected boolean isIncomingOutgoingMessagesOK() {
        List topMessages = this.getTopBoundaryLifeLineElement().getLMMesssagesList();
        List bottomMessages = this.getBottomBoundaryLifeLineElement().getLMMesssagesList();
        int sumSize = topMessages.size() + bottomMessages.size();
        if (sumSize == 0) {
            return false;
        }
        return sumSize <= 2;
    }

    protected abstract class BoundaryLifeLineElement
    extends SDVerticalLayoutInputImpl.LifeLineElementSizeAdapter
    implements LifeLineElement.Position,
    LMMessageEnd.ConnectableLifeLineElement {
        private final LifeLineElement.Position myGdeElementPosition;
        private List myLMMessages;
        private final SDVerticalLayoutInputImpl.OrderingConstraintHolder myOrderingConstraintHolder;

        public BoundaryLifeLineElement(LifeLineElement.Position gdeElementPosition, int offset, int size) {
            super(offset, size);
            this.myLMMessages = new ArrayList(1);
            this.myOrderingConstraintHolder = new SDVerticalLayoutInputImpl.OrderingConstraintHolder();
            this.myGdeElementPosition = gdeElementPosition;
        }

        @Override
        public int getPositionValue() {
            return this.myGdeElementPosition.getPositionValue();
        }

        @Override
        public void setPositionValue(int pos) {
            this.setPositionValue(pos, false);
        }

        void setPositionValueFromMessage(int messagePos) {
            int pos = messagePos - this.getMessagesVerticalPosOffset();
            this.setPositionValue(pos, true);
        }

        @Override
        public boolean isVirtual() {
            return false;
        }

        @Override
        public boolean isFirstPrioritedPosition() {
            return this.myGdeElementPosition.isFirstPrioritedPosition();
        }

        @Override
        public boolean isLastPrioritedPosition() {
            return this.myGdeElementPosition.isLastPrioritedPosition();
        }

        @Override
        public LifeLine getLifeLine() {
            LMLifeLine lmLifeLine = LMGenCallOccurence.this.getLifeLine();
            return lmLifeLine.getVerticalLayoutLifeLine();
        }

        @Override
        public LifeLineElement.Position getPosition() {
            return this;
        }

        List getLMMesssagesList() {
            return this.myLMMessages;
        }

        @Override
        public Enumeration afterConstraints() {
            return this.myOrderingConstraintHolder.afterConstraints();
        }

        @Override
        public Enumeration beforeConstraints() {
            return this.myOrderingConstraintHolder.beforeConstraints();
        }

        @Override
        public void addAfterConstraint(OrderingConstraint orderingConstraint) {
            this.myOrderingConstraintHolder.addAfterConstraint(orderingConstraint);
        }

        @Override
        public void addBeforeConstraint(OrderingConstraint orderingConstraint) {
            this.myOrderingConstraintHolder.addBeforeConstraint(orderingConstraint);
        }

        @Override
        public void removeAfterConstraint(OrderingConstraint orderingConstraint) {
            this.myOrderingConstraintHolder.removeAfterConstraint(orderingConstraint);
        }

        @Override
        public void removeBeforeConstraint(OrderingConstraint orderingConstraint) {
            this.myOrderingConstraintHolder.removeBeforeConstraint(orderingConstraint);
        }

        abstract int getMessagesVerticalPosOffset();

        protected void setPositionValue(int pos, boolean doNotReshapeMessages) {
            this.myGdeElementPosition.setPositionValue(pos);
            if (!doNotReshapeMessages) {
                int posForMessage = pos + this.getMessagesVerticalPosOffset();
                int i = 0;
                while (i < this.myLMMessages.size()) {
                    LMMessage lmMessage = (LMMessage)this.myLMMessages.get(i);
                    LMGenCallOccurence.this.setLMMessageEndVerticalPosition(lmMessage, posForMessage, i);
                    ++i;
                }
            }
        }
    }

    protected class PositioningGen
    implements LMMessageEnd.VerticalConstraintedPositioning {
        protected PositioningGen() {
        }

        @Override
        public boolean canSetMessageAsHorizontalConstraint(LMCallMessageSynch lmCallMessageSynch) {
            return LMGenCallOccurence.this.myHorizontalConstraintCallMessage == null;
        }

        @Override
        public void setMessageAsHorizontalConstraint(LMCallMessageSynch lmCallMessageSync, boolean isConstraint) {
            if (isConstraint) {
                if (LMGenCallOccurence.this.myHorizontalConstraintCallMessage != null) {
                    throw new RuntimeException("Horizontal constraint is already set");
                }
                LMGenCallOccurence.this.myHorizontalConstraintCallMessage = lmCallMessageSync;
            } else {
                if (LMGenCallOccurence.this.myHorizontalConstraintCallMessage != lmCallMessageSync) {
                    throw new RuntimeException("Cannot reset ANOTHER horizontal constraint");
                }
                LMGenCallOccurence.this.myHorizontalConstraintCallMessage = null;
            }
        }

        @Override
        public boolean hasMessageAsHorizontalConstraint(LMCallMessageSynch lmCallMessageSynch) {
            return LMGenCallOccurence.this.myHorizontalConstraintCallMessage == lmCallMessageSynch;
        }

        @Override
        public LMMessageEnd.ConnectableLifeLineElement getTopLifeLineElement() {
            return LMGenCallOccurence.this.getTopBoundaryLifeLineElement();
        }

        @Override
        public LifeLineElement getBottomLifeLineElement() {
            if (LMGenCallOccurence.this.hasNoDuration()) {
                return null;
            }
            return LMGenCallOccurence.this.getBottomBoundaryLifeLineElement();
        }

        @Override
        public LMLifeLine getLifeLine() {
            return LMGenCallOccurence.this.getLifeLine();
        }
    }
}

