/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsElementPropertyAccess;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.BracketMetaObject;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.JustReshapedState;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMBracketContainer;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMExecutionOccurence;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMGenCallOccurence;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLineBracket;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmBracketsList;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmBracketsListSimple;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmOwner;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SDVerticalLayoutInputImpl;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.VerticalClue;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineIterator;

public class LMLifeLine
extends LMBracketContainer
implements SDVerticalLayoutInputImpl.LifeLineSupply {
    private final SDVerticalLayoutInputImpl.LifeLineElementGen myFirstLifeLineElement;
    private final SDVerticalLayoutInputImpl.LifeLineElementGen myLastLifeLineElement;
    private final BracketMetaObject myPseudoMetaObject;
    private final HeadLifeLineElement myHeadLifeLineElement;
    private final DetailsLayouter myDetailsLayouter;
    private LMExecutionOccurence myCreationExecution;
    private LMExecutionOccurence myDestructionExecution;
    private LMGenCallOccurence myBottomPosControoller;
    private final LmBracketsList myChildBracketsList = new LmBracketsListSimple();
    private final LifeLine myVerticalLayoutLifeLine = new LifeLine(){

        @Override
        public LifeLineIterator iterator() {
            return new SDVerticalLayoutInputImpl.LifeLineIteratorImpl(LMLifeLine.this.verticalLayoutElements());
        }

        public String toString() {
            return "LL:" + LMLifeLine.this;
        }
    };

    LMLifeLine(AbsNode gdeLifeLine, BracketMetaObject pseudoMetaObject, LmOwner lmOwner) {
        super(gdeLifeLine, lmOwner);
        this.myPseudoMetaObject = pseudoMetaObject;
        LifeLineElement.Position topElementPosition = new LifeLineElement.Position(){

            @Override
            public int getPositionValue() {
                return LMLifeLine.this.getLifeLineGdeTopPos();
            }

            @Override
            public void setPositionValue(int pos) {
                if (this.isVirtual()) {
                    return;
                }
                LMLifeLine.this.setLifeLineGdeTopPos(pos);
            }

            @Override
            public boolean isVirtual() {
                return LMLifeLine.this.myCreationExecution != null;
            }

            @Override
            public boolean isFirstPrioritedPosition() {
                return LMLifeLine.this.isJustReshaped();
            }

            @Override
            public boolean isLastPrioritedPosition() {
                return false;
            }
        };
        this.myFirstLifeLineElement = new SDVerticalLayoutInputImpl.LifeLineElementGenAdapter(10, 10, topElementPosition, this){

            public String toString() {
                return "Lifeline(" + LMLifeLine.this + ")top";
            }
        };
        LifeLineElement.Position bottomElementPosition = new LifeLineElement.Position(){

            @Override
            public int getPositionValue() {
                return LMLifeLine.this.getLifeLineGdeBottomPos();
            }

            @Override
            public void setPositionValue(int pos) {
                if (this.isVirtual()) {
                    return;
                }
                LMLifeLine.this.setLifeLineGdeBottomPos(pos);
            }

            @Override
            public boolean isVirtual() {
                return LMLifeLine.this.myDestructionExecution != null;
            }

            @Override
            public boolean isFirstPrioritedPosition() {
                return false;
            }

            @Override
            public boolean isLastPrioritedPosition() {
                return LMLifeLine.this.isJustReshaped();
            }
        };
        this.myLastLifeLineElement = new SDVerticalLayoutInputImpl.LifeLineElementGenAdapter(20, 20, bottomElementPosition, this){

            public String toString() {
                return "Lifeline(" + LMLifeLine.this + ")bottoms";
            }
        };
        this.myDetailsLayouter = AbsElementPropertyAccess.getInstance().getLifeLineDetailsLayouter(gdeLifeLine);
        this.myHeadLifeLineElement = new HeadLifeLineElement(this.myDetailsLayouter.getHeadPreferredHeight());
    }

    @Override
    public void setJustReshaped(JustReshapedState justReshapedState) {
        super.setJustReshaped(justReshapedState);
        if (this.myBottomPosControoller != null) {
            AbsNode gdeNode = this.myBottomPosControoller.getGdeNode();
            int lifelineBottom = this.getBracketBottomPos();
            int y = gdeNode.getY();
            gdeNode.setHeight(lifelineBottom - y);
        }
    }

    void updateCreationDestruction() {
        LMExecutionOccurence e;
        LMLifeLineBracket firstBracket = this.getCreationCandidate();
        LMExecutionOccurence creationExecution = null;
        if (firstBracket instanceof LMExecutionOccurence && (e = (LMExecutionOccurence)firstBracket).isCreationInModel()) {
            creationExecution = e;
        }
        this.setCreationExecution(creationExecution);
        LMLifeLineBracket lastBracket = this.getDestructionCandidate();
        LMExecutionOccurence destructionExecution = null;
        if (lastBracket instanceof LMExecutionOccurence && (e = (LMExecutionOccurence)lastBracket).isDestructionInModel()) {
            destructionExecution = e;
        }
        this.setDestructionExecution(destructionExecution);
    }

    private void setCreationExecution(LMExecutionOccurence creationExecution) {
        if (this.myCreationExecution == creationExecution) {
            return;
        }
        if (this.myCreationExecution != null) {
            this.myCreationExecution.setCreatedLifeline(null);
        }
        this.myCreationExecution = creationExecution;
        if (this.myCreationExecution != null) {
            this.myCreationExecution.setCreatedLifeline(this);
        }
    }

    private void setDestructionExecution(LMExecutionOccurence destructionExecution) {
        if (this.myDestructionExecution == destructionExecution) {
            return;
        }
        if (this.myDestructionExecution != null) {
            assert (this.myBottomPosControoller != null);
            this.myDestructionExecution.setDestructedLifeline(null);
            this.myBottomPosControoller.setLifelineToProvideBottomPos(null);
        }
        this.myDestructionExecution = destructionExecution;
        if (this.myDestructionExecution != null) {
            this.myDestructionExecution.setDestructedLifeline(this);
            this.myBottomPosControoller = this.myDestructionExecution;
            LMGenCallOccurence callOccurence = this.myDestructionExecution;
            while (callOccurence != null) {
                this.myBottomPosControoller = callOccurence;
                callOccurence = callOccurence.getContainer().getContainingCallOccurence();
            }
            this.myBottomPosControoller.setLifelineToProvideBottomPos(this);
        }
    }

    @Override
    LMLifeLineBracket getCreationCandidate() {
        if (this.getChildBracketsList().isEmpty()) {
            return null;
        }
        LMLifeLineBracket firstBracket = (LMLifeLineBracket)this.getChildBracketsList().getListView().get(0);
        return firstBracket.getCreationCandidate();
    }

    @Override
    LMLifeLineBracket getDestructionCandidate() {
        if (this.getChildBracketsList().isEmpty()) {
            return null;
        }
        List listView = this.getChildBracketsList().getListView();
        LMLifeLineBracket lastBracket = (LMLifeLineBracket)listView.get(listView.size() - 1);
        return lastBracket.getDestructionCandidate();
    }

    @Override
    LMGenCallOccurence getContainingCallOccurence() {
        return null;
    }

    @Override
    LMFrame getContainingFrame() {
        return null;
    }

    int getCreationReceiveEndXPos(boolean toRightNotLeft) {
        int centerPos = this.getGdeNode().getX() + this.myDetailsLayouter.getCenterRelativePos();
        if (toRightNotLeft) {
            return centerPos + this.myDetailsLayouter.getHeadHalfWidth();
        }
        return centerPos - this.myDetailsLayouter.getHeadHalfWidth();
    }

    private SDVerticalLayoutInputImpl.NullFreeIterator verticalLayoutElements() {
        return new SDVerticalLayoutInputImpl.NullFreeIteratorForArray(6){

            @Override
            protected Object get(int pos) {
                switch (pos) {
                    case 0: {
                        return LMLifeLine.this.myFirstLifeLineElement;
                    }
                    case 1: {
                        return LMLifeLine.this.myHeadLifeLineElement;
                    }
                    case 2: {
                        return LMLifeLine.this.getClueValue();
                    }
                    case 3: {
                        return new LMBracketContainer.ChildBracketsNFIterator();
                    }
                    case 4: {
                        return VerticalClue.LIFE_LINE_TAIL_CLUE;
                    }
                    case 5: {
                        return LMLifeLine.this.myLastLifeLineElement;
                    }
                }
                throw new IndexOutOfBoundsException();
            }
        };
    }

    @Override
    public LifeLine getVerticalLayoutLifeLine() {
        return this.myVerticalLayoutLifeLine;
    }

    public String toString() {
        EObject nodeEntity = this.getGdeNode().getModelEntity();
        return "LmLL-" + nodeEntity;
    }

    SDVerticalLayoutInputImpl.LifeLineElementGen getFirstLifeLineElement() {
        return this.myFirstLifeLineElement;
    }

    SDVerticalLayoutInputImpl.LifeLineElementGen getLastLifeLineElement() {
        return this.myLastLifeLineElement;
    }

    @Override
    LMLifeLineBracket createChildBracketInstance(AbsNode gdeNode, View reference) {
        BracketMetaObject bracketMetaObject = this.myPseudoMetaObject.getChildBracketMetaObject(reference);
        if (bracketMetaObject == null) {
            return null;
        }
        return bracketMetaObject.createChildBracket(gdeNode, this.getLmOwner());
    }

    public int getHeadNameWidth() {
        int result = this.myDetailsLayouter.getHeadPreferredWidth();
        if (result < 60) {
            result = 60;
        }
        return result;
    }

    public int getHeadHeight() {
        return this.myDetailsLayouter.getHeadPreferredHeight();
    }

    @Override
    protected Integer getClueValue() {
        return VerticalClue.BRACKET_MAX_CLUE;
    }

    @Override
    LMLifeLine getLifeLine() {
        return this;
    }

    SDVerticalLayoutInputImpl.LifeLineElementGen getObjectHorizontalConstraint() {
        return this.myHeadLifeLineElement;
    }

    public void setHorizontalPos(int centerPos, int leftHalfWidth, int rightHalfWidth, int headHalfWidth) {
        int x = centerPos - leftHalfWidth;
        int width = leftHalfWidth + rightHalfWidth;
        this.getGdeNode().setX(x);
        this.getGdeNode().setWidth(width);
        this.getGdeNode().markUserResized();
        this.myDetailsLayouter.setHorizontalPositions(leftHalfWidth, headHalfWidth);
    }

    @Override
    public LmBracketsList getChildBracketsList() {
        return this.myChildBracketsList;
    }

    private int getLifeLineGdeTopPos() {
        return this.getGdeNode().getY();
    }

    void setLifeLineGdeTopPos(int y) {
        this.getGdeNode().setY(y);
    }

    private int getLifeLineGdeBottomPos() {
        return this.getGdeNode().getHeight() + this.getGdeNode().getY();
    }

    void setLifeLineGdeBottomPos(int y) {
        this.getGdeNode().setHeight(y - this.getGdeNode().getY());
    }

    public static interface DetailsLayouter {
        public int getHeadPreferredWidth();

        public int getHeadPreferredHeight();

        public int getHeadTopPos();

        public void setHorizontalPositions(int var1, int var2);

        public int getCenterRelativePos();

        public int getHeadHalfWidth();
    }

    private class HeadLifeLineElement
    extends SDVerticalLayoutInputImpl.LifeLineElementGen
    implements LifeLineElement.Position {
        public HeadLifeLineElement(int preferredHeight) {
            super(0, preferredHeight);
        }

        @Override
        public int getSize() {
            if (LMLifeLine.this.myCreationExecution != null) {
                return 0;
            }
            return super.getSize();
        }

        @Override
        public int getPositionValue() {
            return LMLifeLine.this.myDetailsLayouter.getHeadTopPos();
        }

        @Override
        public void setPositionValue(int pos) {
        }

        @Override
        public boolean isVirtual() {
            return true;
        }

        @Override
        public LifeLine getLifeLine() {
            return LMLifeLine.this.getVerticalLayoutLifeLine();
        }

        @Override
        public boolean isFirstPrioritedPosition() {
            return false;
        }

        @Override
        public boolean isLastPrioritedPosition() {
            return false;
        }

        @Override
        public LifeLineElement.Position getPosition() {
            return this;
        }

        public String toString() {
            return "Lifeline(" + LMLifeLine.this + ")head";
        }
    }
}

