/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.awt.Color;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsElementPropertyAccess;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.BracketMetaObject;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMBracketContainer;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMGenCallOccurence;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmOwner;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SDVerticalLayoutInputImpl;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.VerticalClue;

public abstract class LMLifeLineBracket
extends LMBracketContainer {
    private Color myHasColorBeforeViolated = null;
    private LMBracketContainer myContainer = null;
    private Integer myClueValue = null;
    private final BracketMetaObject myBracketMetaObject;
    private final EObject myEntity;
    private final LifelineBracketHorizontalLayouter myBracketHorizontalLayouter;

    LMLifeLineBracket(AbsNode gdeBracketNode, BracketMetaObject bracketMetaObject, LmOwner lmOwner) {
        super(gdeBracketNode, lmOwner);
        this.myBracketMetaObject = bracketMetaObject;
        this.myEntity = gdeBracketNode.getModelEntity();
        this.myBracketHorizontalLayouter = AbsElementPropertyAccess.getInstance().getLifelineBracketHorizontalLayouter(gdeBracketNode);
    }

    public LifelineBracketHorizontalLayouter getBracketHorizontalLayouter() {
        return this.myBracketHorizontalLayouter;
    }

    @Override
    LMLifeLineBracket getCreationCandidate() {
        return this;
    }

    LMLifeLineBracket getDestructionCandidateInCallOccurence() {
        return null;
    }

    @Override
    LMGenCallOccurence getContainingCallOccurence() {
        if (this.myContainer == null) {
            throw new RuntimeException("Has no container");
        }
        return this.myContainer.getContainingCallOccurence();
    }

    @Override
    LMFrame getContainingFrame() {
        return this.getContainer().getContainingFrame();
    }

    @Override
    LMLifeLineBracket createChildBracketInstance(AbsNode gdeNode, View reference) {
        BracketMetaObject bracketMetaObject = this.myBracketMetaObject.getChildBracketMetaObject(reference);
        if (bracketMetaObject == null) {
            return null;
        }
        return bracketMetaObject.createChildBracket(gdeNode, this.getLmOwner());
    }

    LMBracketContainer getContainer() {
        return this.myContainer;
    }

    BracketMetaObject getBracketMetaObject() {
        return this.myBracketMetaObject;
    }

    @Override
    public LMLifeLine getLifeLine() {
        if (this.myContainer == null) {
            throw new RuntimeException("Has no container");
        }
        return this.myContainer.getLifeLine();
    }

    public abstract boolean isLimitedHorizontally();

    void setContainer(LMBracketContainer container) {
        this.myContainer = container;
        if (container == null) {
            this.myClueValue = null;
        } else {
            int parentClueValue = container.getClueValue();
            int newClueValue = parentClueValue > VerticalClue.BRACKET_MIN_CLUE ? parentClueValue - 1 : parentClueValue;
            this.myClueValue = new Integer(newClueValue);
        }
    }

    public abstract SDVerticalLayoutInputImpl.NullFreeIterator verticalLayoutElements();

    public abstract void setHorizontalPosition(int var1);

    @Override
    protected Integer getClueValue() {
        return this.myClueValue;
    }

    EObject getEntity() {
        return this.myEntity;
    }

    protected boolean calculateIsBracketConsistent() {
        return true;
    }

    public void updateBracketConsistentState() {
        boolean violated;
        boolean bl = violated = !this.calculateIsBracketConsistent();
        if (this.myHasColorBeforeViolated == null && violated) {
            this.myHasColorBeforeViolated = this.setErrorDisplayColor(Color.RED);
        } else if (this.myHasColorBeforeViolated != null && !violated) {
            this.setErrorDisplayColor(this.myHasColorBeforeViolated);
            this.myHasColorBeforeViolated = null;
        }
    }

    abstract Color setErrorDisplayColor(Color var1);

    public static interface LifelineBracketHorizontalLayouter {
        public void setHorizontalPositions(int var1, int var2, int var3);
    }
}

