/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsElementPropertyAccess;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;

public abstract class LMVisibleFrameWithPentagon
extends LMFrame {
    private final PentagonLayouter myPentagonLayouter;

    LMVisibleFrameWithPentagon(AbsNode gdeNode) {
        super(gdeNode);
        this.myPentagonLayouter = AbsElementPropertyAccess.getInstance().getPentagonLayouter(gdeNode);
    }

    @Override
    boolean hasVisibleMountingLinks() {
        return true;
    }

    @Override
    public void setLeftBorderPosByTool(int pos) {
        int curX = this.getGdeNode().getX();
        int curWidth = this.getGdeNode().getWidth();
        int newX = pos;
        int newWidth = curWidth + curX - newX;
        this.setX(newX);
        this.setWidth(newWidth);
    }

    @Override
    public void setRightBorderPosByTool(int pos) {
        this.setRightBorderPosByLayout(pos);
    }

    @Override
    public void setLeftBorderPosByLayout(int pos) {
        this.setX(pos);
    }

    @Override
    public void setRightBorderPosByLayout(int pos) {
        int curX = this.getGdeNode().getX();
        int newWidth = pos - curX;
        this.setWidth(newWidth);
    }

    protected abstract int getPentagonOffset();

    @Override
    protected void setX(int x) {
        super.setX(x);
        this.myPentagonLayouter.setX(x + this.getPentagonOffset());
    }

    @Override
    protected void setWidth(int width) {
        super.setWidth(width);
    }

    @Override
    public void setTopBorderPos(int pos) {
        super.setTopBorderPos(pos);
        this.myPentagonLayouter.setY(pos + this.getPentagonOffset());
    }

    public int getMinimumWidth() {
        return this.myPentagonLayouter.getPreferredWidth();
    }

    public int getPreferredWidth() {
        return this.myPentagonLayouter.getPreferredWidth();
    }

    public int getPreferredHeight() {
        return this.myPentagonLayouter.getPreferredHeight() + 5;
    }

    final int getPentagonPreferredHeight() {
        return this.myPentagonLayouter.getPreferredHeight();
    }

    public static interface PentagonLayouter {
        public int getPreferredWidth();

        public int getPreferredHeight();

        public void setX(int var1);

        public void setY(int var1);
    }
}

