/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsDiagram;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsElementPropertyAccess;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsLinkEnumeration;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNodeEnumeration;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.BracketMetaObject;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMBadElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMBracketContainer;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMCallMessage;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMCallMessageAsynch;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMCallMessageSynch;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMCombinedFragment;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFakeLifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFoundInvocationOccurence;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFoundMessage;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrameContainer;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMGenCallOccurence;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMInteractionOccurence;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMInteractionOperand;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLineBracket;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMessage;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMountingLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMountingRegion;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMReceiveMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMReturnMessage;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMSelfMessage;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMSendMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmAlienElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmBracketsMetamodel;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmObjectsResolver;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmOwner;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SDVerticalLayoutInputImpl;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SdLayoutModelAddRemoveProcessor;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SdLayoutUtil;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SelfReorderable;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.HorizontalConstraint;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.SDVerticalLayoutInput;
import org.eclipse.uml2.diagram.sequence.internal.missed.MissedMethods;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Lifeline;

public class SDLayoutModel {
    private final Map myGdeElement2lmElement = new HashMap();
    private final Interaction myDiagramEntity;
    private final AbsDiagram myGdeDiagram;
    private final LifelinesArray myLifeLinesArray = new LifelinesArray();
    private final LMFrameContainer myRootFramesContainer = new LMFrameContainer();
    private final List myLifeLinesArrayImmutable = Collections.unmodifiableList(this.myLifeLinesArray);
    private final List myBadElements = new ArrayList();
    private final State myState = new State();
    private final LmObjectsResolver myLmObjectsResolver = new LmObjectsResolver(){

        @Override
        public Object getLmObject(AbsElement gdeElement) {
            return SDLayoutModel.this.myGdeElement2lmElement.get(gdeElement);
        }
    };
    private AddRemoveElementsProcessor myAddRemoveElementsProcessor = null;
    private final RootElementsGetter myRootElementsGetter;
    private final LmOwner myLmOwner;
    private final LmAlienElement.Factory myAlienElementfactory;
    private final HorizontalConstraintImpl myTopLineConstraint = new HorizontalConstraintImpl("topline");
    private final HorizontalConstraintImpl myBottomLineConstraint = new HorizontalConstraintImpl("bottomline");
    private static final boolean READ_GDE_CONTENT_MYSELF = false;

    public SDLayoutModel(AbsDiagram gdeDiagram, boolean readInitialData, LmAlienElement.Factory alienElementfactory, Config diagramConfig, RootElementsGetter interactionEntityGetter) {
        this.myGdeDiagram = gdeDiagram;
        this.myDiagramEntity = gdeDiagram.getInteraction();
        if (this.myDiagramEntity == null) {
            throw new RuntimeException("Cannot get diagram entity");
        }
        this.myAlienElementfactory = alienElementfactory;
        if (interactionEntityGetter == null) {
            interactionEntityGetter = new RootElementsGetter(){

                @Override
                public Interaction getInteractionEntity() {
                    return SDLayoutModel.this.myDiagramEntity;
                }

                @Override
                public View getInteractionView() {
                    return SDLayoutModel.this.myGdeDiagram.getInteractionView();
                }

                @Override
                public AbsNode getRootNode() {
                    return SDLayoutModel.this.myGdeDiagram.getRootNode();
                }
            };
        }
        this.myRootElementsGetter = interactionEntityGetter;
        this.myLmOwner = new LmOwnerImpl(diagramConfig);
        if (readInitialData) {
            this.initialFill();
        }
        LMFakeLifeLine fakeLifeLine = new LMFakeLifeLine(300);
        this.myLifeLinesArray.add(fakeLifeLine);
        this.myTopLineConstraint.getLifeLineElementsList().add(fakeLifeLine.getFirstLifeLineElement());
        fakeLifeLine.getFirstLifeLineElement().setHorizontalConstraint(this.myTopLineConstraint);
        this.myBottomLineConstraint.getLifeLineElementsList().add(fakeLifeLine.getLastLifeLineElement());
        fakeLifeLine.getLastLifeLineElement().setHorizontalConstraint(this.myBottomLineConstraint);
    }

    public LmObjectsResolver getLmObjectsResolver() {
        return this.myLmObjectsResolver;
    }

    public SdLayoutModelAddRemoveProcessor newAddRemoveProcessor() {
        if (this.myAddRemoveElementsProcessor != null) {
            throw new IllegalStateException("Previous AddRemoveProcessor hasn't finished yet");
        }
        this.myAddRemoveElementsProcessor = new AddRemoveElementsProcessor();
        return this.myAddRemoveElementsProcessor;
    }

    public SDVerticalLayoutInput getSDVerticalLayoutInput() {
        return new SDVerticalLayoutInputImpl(this);
    }

    public List getLifeLinesList() {
        return this.myLifeLinesArrayImmutable;
    }

    public LMFrameContainer getRootFrameContainer() {
        return this.myRootFramesContainer;
    }

    public List getBadElementsList() {
        return this.myBadElements;
    }

    void addBracketToContainer(LMLifeLineBracket lifeLineBracket, LMBracketContainer bracketContainer) {
        bracketContainer.getChildBracketsList().add(lifeLineBracket);
        lifeLineBracket.setContainer(bracketContainer);
    }

    public State getState() {
        return this.myState;
    }

    private void initialFill() {
        this.myState.setConstructionCompleted(false);
        try {
            AbsNode subNode1;
            SdLayoutModelAddRemoveProcessor addRemoveElementsProcessor = this.newAddRemoveProcessor();
            ArrayList allNodes = new ArrayList();
            AbsNodeEnumeration nodeEnum = this.myRootElementsGetter.getRootNode().subnodes();
            while (nodeEnum.hasMoreElements()) {
                subNode1 = nodeEnum.nextGdeNode();
                this.readNodesRecursively(subNode1, allNodes);
            }
            int i = 0;
            while (i < allNodes.size()) {
                subNode1 = (AbsNode)allNodes.get(i);
                addRemoveElementsProcessor.processAddedGdeNode(subNode1);
                ++i;
            }
            AbsLinkEnumeration linkEnum = this.myGdeDiagram.links();
            while (linkEnum.hasMoreElements()) {
                AbsLink gdeLink1 = linkEnum.nextGdeLink();
                addRemoveElementsProcessor.processAddedGdeLink(gdeLink1);
            }
            addRemoveElementsProcessor.finish();
        }
        finally {
            this.myState.setConstructionCompleted(true);
        }
    }

    private void readNodesRecursively(AbsNode absNode, Collection collection) {
        collection.add(absNode);
        AbsNodeEnumeration nodeEnum = absNode.subnodes();
        while (nodeEnum.hasMoreElements()) {
            AbsNode subNode1 = nodeEnum.nextGdeNode();
            this.readNodesRecursively(subNode1, collection);
        }
    }

    private Interaction getInteractionEntity() {
        return this.myRootElementsGetter.getInteractionEntity();
    }

    private class AddRemoveElementsProcessor
    implements SdLayoutModelAddRemoveProcessor {
        private Set<SelfReorderable> myPossibleUnorderedContainers = new HashSet<SelfReorderable>();

        private AddRemoveElementsProcessor() {
        }

        @Override
        public boolean processAddedGdeNode(AbsNode gdeNode) {
            assert (this.isProcessorActive());
            if (SDLayoutModel.this.myGdeElement2lmElement.get(gdeNode) != null) {
                return false;
            }
            EObject nodeEntity = gdeNode.getModelEntity();
            if (nodeEntity == null) {
                return this.addAlienGdeNode(gdeNode);
            }
            AbsElement parentGdeElement = gdeNode.getParentGdeElement();
            if (SDLayoutModel.this.myRootElementsGetter.getRootNode().equals(parentGdeElement)) {
                if (AbsElementPropertyAccess.getInstance().isViewmappedAsAlienShortcut(gdeNode)) {
                    this.addBadNode(gdeNode);
                    return true;
                }
                if (nodeEntity instanceof Lifeline) {
                    this.addLifeLine(gdeNode, nodeEntity);
                    return true;
                }
                if (MissedMethods._arcasMetamodelSpecific().isFrame(nodeEntity)) {
                    LMFrame lmFrame = this.addFrame(gdeNode, nodeEntity, null);
                    return lmFrame != null;
                }
                if (MissedMethods._arcasMetamodelSpecific().isFoundMessageInvocation(nodeEntity)) {
                    LMFoundInvocationOccurence lmFoundInvocationOccurence = this.addFoundInvocationOccurence(gdeNode, nodeEntity, null);
                    return lmFoundInvocationOccurence != null;
                }
                return this.addAlienGdeNode(gdeNode);
            }
            if (!(parentGdeElement instanceof AbsNode)) {
                return this.addAlienGdeNode(gdeNode);
            }
            AbsNode parentGdeNode = (AbsNode)parentGdeElement;
            Object parentLmElement = SDLayoutModel.this.myGdeElement2lmElement.get(parentGdeNode);
            if (parentLmElement == null) {
                return this.addAlienGdeNode(gdeNode);
            }
            if (parentLmElement instanceof LMBracketContainer) {
                LMBracketContainer lmBracketContainer = (LMBracketContainer)parentLmElement;
                LMLifeLineBracket lmLifeLineBracket = lmBracketContainer.createChildBracketInstance(gdeNode, gdeNode.getReference());
                if (lmLifeLineBracket == null) {
                    return false;
                }
                lmBracketContainer.getChildBracketsList().add(lmLifeLineBracket);
                this.addPossibleUnorderedContainter(lmBracketContainer);
                lmLifeLineBracket.setContainer(lmBracketContainer);
                SDLayoutModel.this.myGdeElement2lmElement.put(gdeNode, lmLifeLineBracket);
                return true;
            }
            if (parentLmElement instanceof LMFrame) {
                LMFrame parentLMFrame = (LMFrame)parentLmElement;
                return this.addChildToFrame(parentLMFrame, gdeNode, nodeEntity);
            }
            return this.addAlienGdeNode(gdeNode);
        }

        private boolean addAlienGdeNode(AbsNode gdeNode) {
            SDLayoutModel.this.myGdeElement2lmElement.put(gdeNode, SDLayoutModel.this.myAlienElementfactory.createAlienNode(gdeNode));
            return true;
        }

        private LMLifeLine addLifeLine(AbsNode lifeLineNode, EObject lifeLineEntity) {
            if (SDLayoutModel.this.myGdeElement2lmElement.get(lifeLineNode) != null) {
                throw new RuntimeException("Lifeline gde element already added to model: " + lifeLineNode);
            }
            if (lifeLineEntity.eContainer() != SDLayoutModel.this.getInteractionEntity()) {
                this.addBadNode(lifeLineNode);
                return null;
            }
            LMLifeLine lmLifeLine = new LMLifeLine(lifeLineNode, LmBracketsMetamodel.LIFE_LINE_META_OBJECT, SDLayoutModel.this.myLmOwner);
            SDLayoutModel.this.myGdeElement2lmElement.put(lifeLineNode, lmLifeLine);
            SDLayoutModel.this.myLifeLinesArray.add(lmLifeLine);
            this.addPossibleUnorderedContainter(SDLayoutModel.this.myLifeLinesArray);
            SDLayoutModel.this.myTopLineConstraint.getLifeLineElementsList().add(lmLifeLine.getFirstLifeLineElement());
            lmLifeLine.getFirstLifeLineElement().setHorizontalConstraint(SDLayoutModel.this.myTopLineConstraint);
            SDLayoutModel.this.myBottomLineConstraint.getLifeLineElementsList().add(lmLifeLine.getLastLifeLineElement());
            lmLifeLine.getLastLifeLineElement().setHorizontalConstraint(SDLayoutModel.this.myBottomLineConstraint);
            return lmLifeLine;
        }

        private boolean addChildToFrame(LMFrame parentLMFrame, AbsNode gdeNode, EObject nodeEntity) {
            if (MissedMethods._arcasMetamodelSpecific().isFrame(nodeEntity)) {
                LMFrame lmFrame = this.addFrame(gdeNode, nodeEntity, parentLMFrame);
                return lmFrame != null;
            }
            if (MissedMethods._arcasMetamodelSpecific().isFoundMessageInvocation(nodeEntity)) {
                LMFoundInvocationOccurence lmFoundInvocationOccurence = this.addFoundInvocationOccurence(gdeNode, nodeEntity, parentLMFrame);
                return lmFoundInvocationOccurence != null;
            }
            return this.addAlienGdeNode(gdeNode);
        }

        private LMFrame addFrame(AbsNode frameNode, EObject frameEntity, LMFrame parentFrame) {
            LMFrame lmFrame;
            if (SDLayoutModel.this.myGdeElement2lmElement.get(frameNode) != null) {
                throw new RuntimeException("Frame gde element already added to model: " + frameNode);
            }
            if (parentFrame == null && frameEntity.eContainer() != SDLayoutModel.this.getInteractionEntity()) {
                this.addBadNode(frameNode);
                return null;
            }
            if (frameEntity instanceof CombinedFragment) {
                lmFrame = new LMCombinedFragment(frameNode);
            } else if (frameEntity instanceof InteractionUse) {
                lmFrame = new LMInteractionOccurence(frameNode);
            } else if (frameEntity instanceof InteractionOperand) {
                lmFrame = new LMInteractionOperand(frameNode);
            } else {
                return null;
            }
            SDLayoutModel.this.myGdeElement2lmElement.put(frameNode, lmFrame);
            if (parentFrame == null) {
                SDLayoutModel.this.myRootFramesContainer.addChildFrame(lmFrame);
            } else {
                parentFrame.addChildFrame(lmFrame);
            }
            return lmFrame;
        }

        private void readFrameChildren(AbsNode frameNode, LMFrame lmFrame) {
            AbsNodeEnumeration nodeEnum = frameNode.subnodes();
            while (nodeEnum.hasMoreElements()) {
                AbsNode nextNode = nodeEnum.nextGdeNode();
                EObject nodeEntity = nextNode.getModelEntity();
                if (nodeEntity == null) continue;
                this.addChildToFrame(lmFrame, nextNode, nodeEntity);
            }
        }

        private LMFoundInvocationOccurence addFoundInvocationOccurence(AbsNode invocationNode, EObject invocationEntity, LMFrame parentFrame) {
            if (SDLayoutModel.this.myGdeElement2lmElement.get(invocationNode) != null) {
                throw new RuntimeException("Found invocation gde element already added to model: " + invocationNode);
            }
            if (parentFrame == null && invocationEntity.eContainer() != SDLayoutModel.this.getInteractionEntity()) {
                this.addBadNode(invocationNode);
                return null;
            }
            if (!MissedMethods._arcasMetamodelSpecific().isFoundMessageInvocation(invocationEntity)) {
                return null;
            }
            LMFoundInvocationOccurence lmFoundInvocationOccurence = new LMFoundInvocationOccurence(invocationNode, parentFrame);
            SDLayoutModel.this.myGdeElement2lmElement.put(invocationNode, lmFoundInvocationOccurence);
            if (parentFrame == null) {
                SDLayoutModel.this.myRootFramesContainer.addChildFoundInvocation(lmFoundInvocationOccurence);
            } else {
                parentFrame.addChildFoundInvocation(lmFoundInvocationOccurence);
            }
            return lmFoundInvocationOccurence;
        }

        LMBadElement.Node addBadNode(AbsNode gdeNode) {
            LMBadElement.Node badNode = new LMBadElement.Node(gdeNode);
            SDLayoutModel.this.myBadElements.add(badNode);
            SDLayoutModel.this.myGdeElement2lmElement.put(gdeNode, badNode);
            return badNode;
        }

        private void readBrackets(AbsNode gdeNode, LMBracketContainer bracketContainer, BracketMetaObject bracketMetaObject) {
            AbsNodeEnumeration nodeEnum = gdeNode.subnodes();
            while (nodeEnum.hasMoreElements()) {
                BracketMetaObject childMetaObject;
                AbsNode subNode1 = nodeEnum.nextGdeNode();
                View subNodeReference = subNode1.getReference();
                if (subNodeReference == null || (childMetaObject = bracketMetaObject.getChildBracketMetaObject(subNodeReference)) == null) continue;
                if (SDLayoutModel.this.myGdeElement2lmElement.get(subNode1) != null) {
                    throw new RuntimeException("GdeNode already added to model");
                }
                LMLifeLineBracket lifeLineBracket = childMetaObject.createChildBracket(subNode1, SDLayoutModel.this.myLmOwner);
                if (lifeLineBracket == null) continue;
                SDLayoutModel.this.addBracketToContainer(lifeLineBracket, bracketContainer);
                SDLayoutModel.this.myGdeElement2lmElement.put(subNode1, lifeLineBracket);
                this.readBrackets(subNode1, lifeLineBracket, childMetaObject);
            }
            bracketContainer.reorderAfterReading();
        }

        @Override
        public boolean processAddedGdeLink(AbsLink gdeLink) {
            assert (this.isProcessorActive());
            if (SDLayoutModel.this.myGdeElement2lmElement.get(gdeLink) != null) {
                return false;
            }
            if (MissedMethods._arcasMetamodelSpecific().isAlienLink(gdeLink)) {
                return this.addedAlienLink(gdeLink);
            }
            if (MissedMethods._arcasMetamodelSpecific().isMessageLink(gdeLink)) {
                LMMessage lmMessage;
                LMSendMessageEnd lmSendMessageEnd;
                LMReceiveMessageEnd lmReceiveMessageEnd;
                boolean isCallMessage;
                AbsElement gdeSource = gdeLink.getSource();
                AbsElement gdeDestination = gdeLink.getDestination();
                Object sourceLMObject = SDLayoutModel.this.myGdeElement2lmElement.get(gdeSource);
                Object destinationLMObject = SDLayoutModel.this.myGdeElement2lmElement.get(gdeDestination);
                if (destinationLMObject instanceof LMReceiveMessageEnd && sourceLMObject instanceof LMSendMessageEnd) {
                    isCallMessage = true;
                    lmReceiveMessageEnd = (LMReceiveMessageEnd)destinationLMObject;
                    lmSendMessageEnd = (LMSendMessageEnd)sourceLMObject;
                } else if (sourceLMObject instanceof LMReceiveMessageEnd && destinationLMObject instanceof LMSendMessageEnd) {
                    isCallMessage = false;
                    lmReceiveMessageEnd = (LMReceiveMessageEnd)sourceLMObject;
                    lmSendMessageEnd = (LMSendMessageEnd)destinationLMObject;
                } else {
                    return false;
                }
                LMMessageEnd.Positioning sendPositioning = lmSendMessageEnd.getPositioning();
                LMMessageEnd.Positioning receivePositioning = lmReceiveMessageEnd.getPositioning();
                if (sendPositioning instanceof LMMessageEnd.FloatingPositioning) {
                    LMMessageEnd.FloatingPositioning floatingPositioning = (LMMessageEnd.FloatingPositioning)sendPositioning;
                    if (!(receivePositioning instanceof LMReceiveMessageEnd.HorizontalPositioning)) {
                        return false;
                    }
                    LMReceiveMessageEnd.HorizontalPositioning receiveHorizontalPositioning = (LMReceiveMessageEnd.HorizontalPositioning)receivePositioning;
                    LMFoundMessage foundMessage = new LMFoundMessage(gdeLink, isCallMessage);
                    foundMessage.setSendMessageEnd(lmSendMessageEnd, floatingPositioning);
                    foundMessage.setReceiveMessageEnd(lmReceiveMessageEnd, receiveHorizontalPositioning);
                    lmMessage = foundMessage;
                } else {
                    if (!(sendPositioning instanceof LMSendMessageEnd.HorizontalPositioning)) {
                        return false;
                    }
                    if (!(receivePositioning instanceof LMReceiveMessageEnd.HorizontalPositioning)) {
                        return false;
                    }
                    boolean isAsynchronous = MissedMethods._arcasMetamodelSpecific().isAsynchonousMessage(gdeLink);
                    LMSendMessageEnd.HorizontalPositioning sendHorizontalPositioning = (LMSendMessageEnd.HorizontalPositioning)sendPositioning;
                    LMReceiveMessageEnd.HorizontalPositioning receiveHorizontalPositioning = (LMReceiveMessageEnd.HorizontalPositioning)receivePositioning;
                    if (sendHorizontalPositioning.getLifeLine() == receiveHorizontalPositioning.getLifeLine() && receiveHorizontalPositioning.getLifeLine() != null) {
                        LMSelfMessage selfMessage = new LMSelfMessage(gdeLink, isCallMessage, isAsynchronous);
                        LMMessageEnd.VerticalConstraintedPositioning sendVerticalPositioning = (LMMessageEnd.VerticalConstraintedPositioning)sendPositioning;
                        LMMessageEnd.VerticalConstraintedPositioning receiveVerticalPositioning = (LMMessageEnd.VerticalConstraintedPositioning)receivePositioning;
                        selfMessage.setSendMessageEnd(lmSendMessageEnd, sendVerticalPositioning, sendHorizontalPositioning);
                        selfMessage.setReceiveMessageEnd(lmReceiveMessageEnd, receiveVerticalPositioning, receiveHorizontalPositioning);
                        lmMessage = selfMessage;
                    } else if (isCallMessage) {
                        if (!(sendPositioning instanceof LMMessageEnd.VerticalConstraintedPositioning)) {
                            return false;
                        }
                        if (!(receivePositioning instanceof LMMessageEnd.VerticalConstraintedPositioning)) {
                            return false;
                        }
                        LMMessageEnd.VerticalConstraintedPositioning sendVerticalPositioning = (LMMessageEnd.VerticalConstraintedPositioning)sendPositioning;
                        LMMessageEnd.VerticalConstraintedPositioning receiveVerticalPositioning = (LMMessageEnd.VerticalConstraintedPositioning)receivePositioning;
                        LMCallMessage lmCallMessage = isAsynchronous ? new LMCallMessageAsynch(gdeLink) : new LMCallMessageSynch(gdeLink);
                        lmCallMessage.setSendMessageEnd(lmSendMessageEnd, sendVerticalPositioning, sendHorizontalPositioning);
                        lmCallMessage.setReceiveMessageEnd(lmReceiveMessageEnd, receiveVerticalPositioning, receiveHorizontalPositioning);
                        lmMessage = lmCallMessage;
                    } else {
                        LMReturnMessage lmReturnMessage = new LMReturnMessage(gdeLink, MissedMethods._arcasMetamodelSpecific().isAsynchonousMessage(gdeLink));
                        lmReturnMessage.setSendMessageEnd(lmSendMessageEnd, sendHorizontalPositioning);
                        lmReturnMessage.setReceiveMessageEnd(lmReceiveMessageEnd, receiveHorizontalPositioning);
                        lmMessage = lmReturnMessage;
                    }
                }
                lmReceiveMessageEnd.addMessage(lmMessage);
                lmSendMessageEnd.addMessage(lmMessage);
                ((LMMessage)lmMessage).becomeLayoutConstraint(true);
                SDLayoutModel.this.myGdeElement2lmElement.put(gdeLink, lmMessage);
                return true;
            }
            if (MissedMethods._arcasMetamodelSpecific().isMountingLink(gdeLink)) {
                AbsElement gdeSource = gdeLink.getSource();
                AbsElement gdeDestination = gdeLink.getDestination();
                Object sourceLMObject = SDLayoutModel.this.myGdeElement2lmElement.get(gdeSource);
                Object destinationLMObject = SDLayoutModel.this.myGdeElement2lmElement.get(gdeDestination);
                if (!(sourceLMObject instanceof LMMountingRegion)) {
                    return false;
                }
                if (!(destinationLMObject instanceof LMFrame)) {
                    return false;
                }
                LMMountingRegion sourceMoutingPoint = (LMMountingRegion)sourceLMObject;
                LMFrame destinationFrame = (LMFrame)destinationLMObject;
                if (sourceMoutingPoint.getMountingLink() != null) {
                    this.addBadLink(gdeLink);
                    return true;
                }
                LMMountingLink mountingLink = new LMMountingLink(gdeLink);
                mountingLink.setMountingRegion(sourceMoutingPoint);
                mountingLink.setFrame(destinationFrame);
                sourceMoutingPoint.setMountLink(mountingLink);
                destinationFrame.addMountingLink(mountingLink);
                SDLayoutModel.this.myGdeElement2lmElement.put(gdeLink, mountingLink);
                return true;
            }
            return this.addedAlienLink(gdeLink);
        }

        boolean addedAlienLink(AbsLink gdeLink) {
            SDLayoutModel.this.myGdeElement2lmElement.put(gdeLink, SDLayoutModel.this.myAlienElementfactory.createAlienLink(gdeLink));
            return true;
        }

        LMBadElement.Link addBadLink(AbsLink gdeLink) {
            LMBadElement.Link badLink = new LMBadElement.Link(gdeLink);
            SDLayoutModel.this.myBadElements.add(badLink);
            SDLayoutModel.this.myGdeElement2lmElement.put(gdeLink, badLink);
            return badLink;
        }

        @Override
        public boolean processRemovedGdeNode(AbsNode gdeNode) {
            assert (this.isProcessorActive());
            Object lmObject = SDLayoutModel.this.myGdeElement2lmElement.get(gdeNode);
            if (lmObject == null) {
                return false;
            }
            if (lmObject instanceof LMLifeLine) {
                LMLifeLine lmLifeLine = (LMLifeLine)lmObject;
                this.removeLifeLine(lmLifeLine);
                return true;
            }
            if (lmObject instanceof LMFrame) {
                LMFrame lmFrame = (LMFrame)lmObject;
                this.removeFrame(lmFrame);
                return true;
            }
            if (lmObject instanceof LMFoundInvocationOccurence) {
                LMFoundInvocationOccurence lmFoundInvocationOccurence = (LMFoundInvocationOccurence)lmObject;
                this.removeFoundInvocationOccurence(lmFoundInvocationOccurence);
                return true;
            }
            if (lmObject instanceof LMLifeLineBracket) {
                LMLifeLineBracket bracket1 = (LMLifeLineBracket)lmObject;
                LMBracketContainer container = bracket1.getContainer();
                if (container == null) {
                    throw new RuntimeException("Container is null");
                }
                this.removeBracket(bracket1);
                container.getChildBracketsList().remove(bracket1);
                return true;
            }
            if (lmObject instanceof LMBadElement.Node) {
                LMBadElement.Node badNode = (LMBadElement.Node)lmObject;
                this.removeBadElement(badNode);
                return true;
            }
            if (lmObject instanceof LmAlienElement) {
                LmAlienElement alienElement = (LmAlienElement)lmObject;
                alienElement.dispose();
                SDLayoutModel.this.myGdeElement2lmElement.remove(gdeNode);
                return true;
            }
            throw new RuntimeException("Remove " + lmObject + ": unknown element");
        }

        private void removeLifeLine(LMLifeLine lmLifeLine) {
            if (!lmLifeLine.getChildBracketsList().isEmpty()) {
                Iterator it = lmLifeLine.getChildBracketsList().iterator();
                while (it.hasNext()) {
                    LMLifeLineBracket bracket1 = (LMLifeLineBracket)it.next();
                    this.removeBracket(bracket1);
                }
                lmLifeLine.getChildBracketsList().removeAll();
            }
            SDLayoutModel.this.myTopLineConstraint.getLifeLineElementsList().remove(lmLifeLine.getFirstLifeLineElement());
            lmLifeLine.getFirstLifeLineElement().setHorizontalConstraint(null);
            SDLayoutModel.this.myBottomLineConstraint.getLifeLineElementsList().remove(lmLifeLine.getLastLifeLineElement());
            lmLifeLine.getLastLifeLineElement().setHorizontalConstraint(null);
            AbsNode lifeLineNode = lmLifeLine.getGdeNode();
            SDLayoutModel.this.myGdeElement2lmElement.remove(lifeLineNode);
            SDLayoutModel.this.myLifeLinesArray.remove(lmLifeLine);
            this.addPossibleUnorderedContainter(SDLayoutModel.this.myLifeLinesArray);
        }

        private void removeFrame(LMFrame lmFrame) {
            this.disposeFrameBranch(lmFrame);
            lmFrame.delete();
        }

        private void disposeFrameBranch(LMFrame lmFrame) {
            ArrayList<LMMountingLink> lmMountingLinks = Collections.list(lmFrame.mountingLinks());
            for (LMMountingLink mountingLink1 : lmMountingLinks) {
                this.removeMountingLink(mountingLink1);
            }
            AbsNode combinedFragmentNode = lmFrame.getGdeNode();
            SDLayoutModel.this.myGdeElement2lmElement.remove(combinedFragmentNode);
        }

        private void removeFoundInvocationOccurence(LMFoundInvocationOccurence lmFoundInvocationOccurence) {
            lmFoundInvocationOccurence.delete();
            SDLayoutModel.this.myGdeElement2lmElement.remove(lmFoundInvocationOccurence.getGdeNode());
        }

        private void removeBracket(LMLifeLineBracket lifeLineBracket) {
            LMMountingRegion mountingPoint;
            LMMountingLink mountingLink;
            if (!lifeLineBracket.getChildBracketsList().isEmpty()) {
                Iterator it = lifeLineBracket.getChildBracketsList().iterator();
                while (it.hasNext()) {
                    LMLifeLineBracket bracket1 = (LMLifeLineBracket)it.next();
                    this.removeBracket(bracket1);
                }
                lifeLineBracket.getChildBracketsList().removeAll();
            }
            if (lifeLineBracket instanceof LMGenCallOccurence) {
                LMGenCallOccurence lmGenCallOccurence = (LMGenCallOccurence)lifeLineBracket;
                List topLinks = lmGenCallOccurence.getTopBoundaryLifeLineElement().getLMMesssagesList();
                List bottomLinks = lmGenCallOccurence.getBottomBoundaryLifeLineElement().getLMMesssagesList();
                if (!topLinks.isEmpty()) {
                    throw new RuntimeException("still there are messages: " + topLinks);
                }
                if (!bottomLinks.isEmpty()) {
                    throw new RuntimeException("still there are messages: " + bottomLinks);
                }
            } else if (lifeLineBracket instanceof LMMountingRegion && (mountingLink = (mountingPoint = (LMMountingRegion)lifeLineBracket).getMountingLink()) != null) {
                this.removeMountingLink(mountingLink);
            }
            AbsNode bracketNode = lifeLineBracket.getGdeNode();
            SDLayoutModel.this.myGdeElement2lmElement.remove(bracketNode);
            lifeLineBracket.setContainer(null);
        }

        @Override
        public boolean processRemovedGdeLink(AbsLink gdeLink) {
            assert (this.isProcessorActive());
            Object lmElement = SDLayoutModel.this.myGdeElement2lmElement.get(gdeLink);
            if (lmElement == null) {
                return false;
            }
            if (lmElement instanceof LMMessage) {
                LMMessage lmMessage = (LMMessage)lmElement;
                this.removeMessageLink(lmMessage);
                return true;
            }
            if (lmElement instanceof LMMountingLink) {
                this.removeMountingLink((LMMountingLink)lmElement);
                return true;
            }
            if (lmElement instanceof LMBadElement.Link) {
                this.removeBadElement((LMBadElement.Link)lmElement);
                return true;
            }
            if (lmElement instanceof LmAlienElement) {
                LmAlienElement alienElement = (LmAlienElement)lmElement;
                alienElement.dispose();
                SDLayoutModel.this.myGdeElement2lmElement.remove(gdeLink);
                return true;
            }
            throw new RuntimeException("Remove " + lmElement + ": todo");
        }

        private void removeMessageLink(LMMessage lmMessage) {
            if (lmMessage == null) {
                throw new IllegalArgumentException("lmMessage=null");
            }
            if (lmMessage.isLayoutConstraint()) {
                lmMessage.becomeLayoutConstraint(false);
            }
            lmMessage.getReceiveMessageEnd().removeMessage(lmMessage);
            lmMessage.getSendMessageEnd().removeMessage(lmMessage);
            lmMessage.resetReceiveMessageEnd();
            lmMessage.resetSendMessageEnd();
            SDLayoutModel.this.myGdeElement2lmElement.remove(lmMessage.getGdeLink());
        }

        private void removeMountingLink(LMMountingLink lmMountingLink) {
            lmMountingLink.getFrame().removeMountingLink(lmMountingLink);
            lmMountingLink.getMountingRegion().setMountLink(null);
            lmMountingLink.setFrame(null);
            lmMountingLink.setMountingRegion(null);
            SDLayoutModel.this.myGdeElement2lmElement.remove(lmMountingLink.getGdeLink());
        }

        private void removeBadElement(LMBadElement badElement) {
            boolean res = SDLayoutModel.this.myBadElements.remove(badElement);
            if (!res) {
                throw new RuntimeException("Cannot delete bad element from list");
            }
            SDLayoutModel.this.myGdeElement2lmElement.remove(badElement.getGdeElement());
        }

        private void addPossibleUnorderedContainter(SelfReorderable bracketContainer) {
            this.myPossibleUnorderedContainers.add(bracketContainer);
        }

        @Override
        public void finish() {
            assert (this.isProcessorActive());
            try {
                for (SelfReorderable bracketContainer : this.myPossibleUnorderedContainers) {
                    bracketContainer.reorderChildElements();
                }
                this.myPossibleUnorderedContainers.clear();
                this.updateLifelineCreationDestruction();
            }
            finally {
                SDLayoutModel.this.myAddRemoveElementsProcessor = null;
            }
        }

        private void updateLifelineCreationDestruction() {
            ListIterator it = SDLayoutModel.this.myLifeLinesArray.listIterator(1);
            while (it.hasNext()) {
                LMLifeLine lifeLine = (LMLifeLine)it.next();
                lifeLine.updateCreationDestruction();
            }
        }

        private boolean isProcessorActive() {
            return SDLayoutModel.this.myAddRemoveElementsProcessor == this;
        }
    }

    public static interface Config {
    }

    private static class HorizontalConstraintImpl
    implements HorizontalConstraint {
        private final ArrayList myLifeLineElementsList = new ArrayList();
        private final String myDebugName;

        HorizontalConstraintImpl(String debugName) {
            this.myDebugName = debugName;
        }

        ArrayList getModifiableElementsList() {
            return this.myLifeLineElementsList;
        }

        public List getLifeLineElementsList() {
            return this.myLifeLineElementsList;
        }

        @Override
        public void elementIsResolved(LifeLineElement lifeLineElement) {
        }

        @Override
        public void elementIsViolated(LifeLineElement lifeLineElement) {
        }

        public String toString() {
            return "[HorizontalConstraintImpl:" + this.myDebugName + "]";
        }
    }

    private class LifelinesArray
    extends ArrayList
    implements SelfReorderable {
        private LifelinesArray() {
        }

        @Override
        public void reorderChildElements() {
            List<LMBracketContainer> allButFirstList = this.subList(1, this.size());
            List<Integer> oldIndexes = SdLayoutUtil.getReorderAgainstModel(allButFirstList, SDLayoutModel.this.myRootElementsGetter.getInteractionView());
            SdLayoutUtil.reorderList(oldIndexes, allButFirstList);
        }
    }

    private static class LmOwnerImpl
    implements LmOwner {
        private final boolean myReorderAgainstModel;

        LmOwnerImpl(Config config) {
            this.myReorderAgainstModel = true;
        }

        @Override
        public boolean reorderAgainstModelNotGde() {
            return this.myReorderAgainstModel;
        }
    }

    public static interface RootElementsGetter {
        public Interaction getInteractionEntity();

        public View getInteractionView();

        public AbsNode getRootNode();
    }

    public class State {
        private boolean myConstructionCompleted = true;

        public boolean isConstructionCompleted() {
            return this.myConstructionCompleted;
        }

        void setConstructionCompleted(boolean constructionCompleted) {
            this.myConstructionCompleted = constructionCompleted;
        }
    }
}

