/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLineBracket;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SDLayoutModel;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.HorizontalConstraint;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineIterator;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.OrderingConstraint;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.SDVerticalLayoutInput;
import org.eclipse.uml2.diagram.sequence.internal.missed.EmptyEnumeration;

public class SDVerticalLayoutInputImpl
implements SDVerticalLayoutInput {
    private final SDLayoutModel mySDLayoutModel;
    private static final Integer our1ClueValue = new Integer(1);

    public SDVerticalLayoutInputImpl(SDLayoutModel sdLayoutModel) {
        this.mySDLayoutModel = sdLayoutModel;
    }

    @Override
    public boolean doesContainNonvirtual() {
        return this.mySDLayoutModel.getLifeLinesList().size() != 1;
    }

    @Override
    public Enumeration lifeLines() {
        List lmLifelines = this.mySDLayoutModel.getLifeLinesList();
        ArrayList<LifeLine> resultList = new ArrayList<LifeLine>(lmLifelines.size());
        for (LifeLineSupply lifeLineSupply1 : lmLifelines) {
            resultList.add(lifeLineSupply1.getVerticalLayoutLifeLine());
        }
        return Collections.enumeration(resultList);
    }

    static class ContainerPosition
    implements LifeLineElement.Position {
        private int myValue;

        ContainerPosition() {
        }

        @Override
        public int getPositionValue() {
            return this.myValue;
        }

        @Override
        public void setPositionValue(int pos) {
            this.myValue = pos;
        }

        @Override
        public boolean isVirtual() {
            return false;
        }

        @Override
        public boolean isFirstPrioritedPosition() {
            return false;
        }

        @Override
        public boolean isLastPrioritedPosition() {
            return false;
        }
    }

    static abstract class ElementBottomPosition
    implements LifeLineElement.Position {
        private final AbsNode myGdeNode;

        public ElementBottomPosition(AbsNode gdeNode) {
            this.myGdeNode = gdeNode;
        }

        @Override
        public int getPositionValue() {
            return this.myGdeNode.getY() + this.myGdeNode.getHeight();
        }

        @Override
        public void setPositionValue(int pos) {
            this.myGdeNode.setHeight(pos - this.myGdeNode.getY());
        }
    }

    static abstract class ElementTopPosition
    implements LifeLineElement.Position {
        private final AbsNode myGdeNode;

        public ElementTopPosition(AbsNode gdeNode) {
            this.myGdeNode = gdeNode;
        }

        @Override
        public int getPositionValue() {
            return this.myGdeNode.getY();
        }

        @Override
        public void setPositionValue(int pos) {
            this.myGdeNode.setY(pos);
        }
    }

    static abstract class LifeLineElementGen
    extends LifeLineElementSizeAdapter {
        private HorizontalConstraint myHorizontalConstraint = null;

        public LifeLineElementGen(int pointOffset, int size) {
            super(pointOffset, size);
        }

        @Override
        public HorizontalConstraint getHorizontalConstraint() {
            return this.myHorizontalConstraint;
        }

        public void setHorizontalConstraint(HorizontalConstraint constraint) {
            if (this.myHorizontalConstraint != null && constraint != null) {
                throw new IllegalStateException("Cannot set horizontal constraint, already has one");
            }
            this.myHorizontalConstraint = constraint;
        }
    }

    static class LifeLineElementGenAdapter
    extends LifeLineElementGen {
        private final LifeLineElement.Position myPosition;
        private final LifeLineSupply myLifeLineSupply;

        protected LifeLineElementGenAdapter(int pointOffset, int size, LifeLineElement.Position position, final LMLifeLineBracket lifeLineBracket) {
            this(pointOffset, size, position, new LifeLineSupply(){

                @Override
                public LifeLine getVerticalLayoutLifeLine() {
                    return lifeLineBracket.getLifeLine().getVerticalLayoutLifeLine();
                }
            });
        }

        protected LifeLineElementGenAdapter(int pointOffset, int size, LifeLineElement.Position position, LifeLineSupply lifeLineSupply) {
            super(pointOffset, size);
            this.myPosition = position;
            this.myLifeLineSupply = lifeLineSupply;
        }

        @Override
        public LifeLine getLifeLine() {
            return this.myLifeLineSupply.getVerticalLayoutLifeLine();
        }

        @Override
        public LifeLineElement.Position getPosition() {
            return this.myPosition;
        }
    }

    static abstract class LifeLineElementSizeAdapter
    implements LifeLineElement {
        private final int myPointOffset;
        private final int mySize;

        public LifeLineElementSizeAdapter(int pointOffset, int size) {
            this.myPointOffset = pointOffset;
            this.mySize = size;
        }

        @Override
        public void optimizeSize() {
        }

        @Override
        public int getPointOffset() {
            return this.myPointOffset;
        }

        @Override
        public int getSize() {
            return this.mySize;
        }

        public Enumeration beforeConstraints() {
            return EmptyEnumeration.getEnumeration();
        }

        public Enumeration afterConstraints() {
            return EmptyEnumeration.getEnumeration();
        }
    }

    public static class LifeLineIteratorImpl
    implements LifeLineIterator {
        private boolean myClueAsked = false;
        private Integer myNextClueValue;
        private LifeLineElement myNextElement;
        private final Stack myNFIteratorStack = new Stack();

        public LifeLineIteratorImpl(NullFreeIterator nfIterator) {
            this.myNFIteratorStack.push(nfIterator);
            this.advance();
        }

        @Override
        public Integer nextClueValue() {
            if (this.myNextElement == null) {
                throw new NoSuchElementException();
            }
            if (this.myClueAsked) {
                throw new IllegalStateException("Element should be asked now");
            }
            this.myClueAsked = true;
            if (this.myNextClueValue == null) {
                return our1ClueValue;
            }
            return this.myNextClueValue;
        }

        @Override
        public LifeLineElement nextElement() {
            if (this.myNextElement == null) {
                throw new NoSuchElementException();
            }
            if (!this.myClueAsked) {
                throw new IllegalStateException("Clue should be asked now");
            }
            try {
                LifeLineElement lifeLineElement = this.myNextElement;
                return lifeLineElement;
            }
            finally {
                this.advance();
                this.myClueAsked = false;
            }
        }

        @Override
        public boolean hasNext() {
            return this.myNextElement != null;
        }

        private void advance() {
            this.myNextClueValue = null;
            while (!this.myNFIteratorStack.empty()) {
                NullFreeIterator it1 = (NullFreeIterator)this.myNFIteratorStack.peek();
                Object nextObject = it1.next();
                if (nextObject == null) {
                    this.myNFIteratorStack.pop();
                    continue;
                }
                if (nextObject instanceof NullFreeIterator) {
                    this.myNFIteratorStack.push(nextObject);
                    continue;
                }
                if (nextObject instanceof Integer) {
                    Integer nextClueValue = (Integer)nextObject;
                    if (this.myNextClueValue != null && this.myNextClueValue >= nextClueValue) continue;
                    this.myNextClueValue = nextClueValue;
                    continue;
                }
                this.myNextElement = (LifeLineElement)nextObject;
                return;
            }
            this.myNextElement = null;
        }
    }

    static interface LifeLineSupply {
        public LifeLine getVerticalLayoutLifeLine();
    }

    public static interface NullFreeIterator {
        public Object next();
    }

    public static abstract class NullFreeIteratorForArray
    implements NullFreeIterator {
        private int myPos = 0;
        private final int myArraySize;

        protected NullFreeIteratorForArray() {
            this(-1);
        }

        protected NullFreeIteratorForArray(int arraySize) {
            this.myArraySize = arraySize;
        }

        protected abstract Object get(int var1);

        @Override
        public Object next() {
            if (this.myPos == this.myArraySize) {
                return null;
            }
            Object result = this.get(this.myPos);
            if (result != null) {
                ++this.myPos;
            }
            return result;
        }
    }

    public static class NullFreeIteratorWrapper
    implements NullFreeIterator {
        private final Iterator myIterator;

        protected NullFreeIteratorWrapper(Iterator iterator) {
            this.myIterator = iterator;
        }

        @Override
        public Object next() {
            if (this.myIterator.hasNext()) {
                return this.myIterator.next();
            }
            return null;
        }
    }

    static class OrderingConstraintHolder {
        private List myBeforeConstraints = null;
        private List myAfterConstraints = null;

        OrderingConstraintHolder() {
        }

        public Enumeration afterConstraints() {
            if (this.myAfterConstraints == null) {
                return Collections.enumeration(Collections.EMPTY_LIST);
            }
            return Collections.enumeration(this.myAfterConstraints);
        }

        public Enumeration beforeConstraints() {
            if (this.myBeforeConstraints == null) {
                return Collections.enumeration(Collections.EMPTY_LIST);
            }
            return Collections.enumeration(this.myBeforeConstraints);
        }

        public void addAfterConstraint(OrderingConstraint orderingConstraint) {
            if (this.myAfterConstraints == null) {
                this.myAfterConstraints = new ArrayList(2);
            }
            this.myAfterConstraints.add(orderingConstraint);
        }

        public void addBeforeConstraint(OrderingConstraint orderingConstraint) {
            if (this.myBeforeConstraints == null) {
                this.myBeforeConstraints = new ArrayList(2);
            }
            this.myBeforeConstraints.add(orderingConstraint);
        }

        public void removeAfterConstraint(OrderingConstraint orderingConstraint) {
            if (this.myAfterConstraints == null) {
                throw new RuntimeException("Cannot remove constraint");
            }
            if (!this.myAfterConstraints.remove(orderingConstraint)) {
                throw new RuntimeException("Cannot remove constraint");
            }
        }

        public void removeBeforeConstraint(OrderingConstraint orderingConstraint) {
            if (this.myBeforeConstraints == null) {
                throw new RuntimeException("Cannot remove constraint");
            }
            if (!this.myBeforeConstraints.remove(orderingConstraint)) {
                throw new RuntimeException("Cannot remove constraint");
            }
        }
    }
}

