/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.vertical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.HorizontalConstraint;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.OrderingConstraint;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.state.LifelineState;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.state.St1MinPosIsCalculated;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.state.St2BeforeConstraintsAccounted;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.state.St3PositionIsSet;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.state.St9LifelineFinished;

public class NewLayoutSession {
    private static final boolean debug_print = false;
    private final Map myLifeline2State;
    private final CycleWatcher myCycleWatcher = new CycleWatcher();
    private final Set myBrokenOrderingConstraints = new HashSet(2);
    private final Map myBlockedHorizontal2BadElements = new HashMap(3);
    private static final Object NOT_REQUIRED_CONSTRAINT = new Object();

    public NewLayoutSession(LifeLine[] lifeLines, boolean fullLayout, int topPos) {
        if (lifeLines.length == 0) {
            throw new IllegalArgumentException("No lifelines are specified");
        }
        this.myLifeline2State = new LinkedHashMap(lifeLines.length);
        int i = 0;
        while (i < lifeLines.length) {
            LifeLine lifeLine = lifeLines[i];
            LifelineState lifelineState = new LifelineState(lifeLine, topPos, fullLayout, this.myBrokenOrderingConstraints);
            this.myLifeline2State.put(lifeLine, lifelineState);
            ++i;
        }
    }

    public int go() {
        for (LifelineState lifelineState : this.myLifeline2State.values()) {
            if (lifelineState.getState() == St9LifelineFinished.class) continue;
            this.processLifeline(lifelineState);
        }
        for (LifelineState lifelineState : this.myLifeline2State.values()) {
            lifelineState.savePositions();
        }
        LifelineState firstLifelineState = (LifelineState)this.myLifeline2State.values().iterator().next();
        int n = St9LifelineFinished.getBase(firstLifelineState);
        return n;
    }

    void processLifeline(LifelineState lifelineState) {
        boolean available = this.myCycleWatcher.requireLifeline(lifelineState);
        if (!available) {
            throw new IllegalStateException("Lifeline is locked somehow");
        }
        try {
            this.processLifelineAlreadyLocked(lifelineState, NOT_REQUIRED_CONSTRAINT);
        }
        finally {
            this.myCycleWatcher.releaseLifeline(lifelineState);
        }
    }

    int processLifeline(LifelineState lifelineState, OrderingConstraint requiredConstraint) throws LifelineBlockedException {
        Integer pos;
        block4: {
            pos = (Integer)lifelineState.getEncounteredOrderingConstraints2Pos().remove(requiredConstraint);
            if (pos == null) break block4;
            int n = pos;
            return n;
        }
        this.lockAndProcessLifeline(lifelineState, requiredConstraint);
        this.myCycleWatcher.releaseLifeline(lifelineState);
        pos = (Integer)lifelineState.getEncounteredOrderingConstraints2Pos().remove(requiredConstraint);
        if (pos == null) {
            throw new RuntimeException("Failed to get position of top element");
        }
        int n = pos;
        return n;
    }

    void processLifeline(LifelineState lifelineState, HorizontalConstraint requiredConstraint) throws LifelineBlockedException {
        this.lockAndProcessLifeline(lifelineState, requiredConstraint);
    }

    void lockAndProcessLifeline(LifelineState lifelineState, Object requiredConstraint) throws LifelineBlockedException {
        boolean available = this.myCycleWatcher.requireLifeline(lifelineState);
        if (!available) {
            throw new LifelineBlockedException();
        }
        this.processLifelineAlreadyLocked(lifelineState, requiredConstraint);
    }

    void processLifelineAlreadyLocked(LifelineState lifelineState, Object requiredConstraint) {
        if (lifelineState.getState() == St3PositionIsSet.class) {
            St3PositionIsSet.nextStep(lifelineState);
        }
        while (lifelineState.getState() != St9LifelineFinished.class) {
            int elementMinPos = St1MinPosIsCalculated.getMinPos(lifelineState);
            Iterator beforeConstraintIt = St1MinPosIsCalculated.getRequiredOrderingConstraints(lifelineState);
            while (beforeConstraintIt.hasNext()) {
                OrderingConstraint beforeConstraint = (OrderingConstraint)beforeConstraintIt.next();
                LifelineState otherLifelineState = this.getLifelineState(beforeConstraint.getBeforeElement().getLifeLine());
                try {
                    int otherPos = this.processLifeline(otherLifelineState, beforeConstraint);
                    beforeConstraint.setInvalid(false);
                    int resultMinPos = otherPos + beforeConstraint.getMinSlopeValue();
                    elementMinPos = Math.max(elementMinPos, resultMinPos);
                }
                catch (LifelineBlockedException e) {
                    beforeConstraint.setInvalid(true);
                    this.myBrokenOrderingConstraints.add(beforeConstraint);
                }
            }
            St1MinPosIsCalculated.beforeConstraintsAccounted(lifelineState, elementMinPos);
            HorizontalConstraint horizontalConstraint = St2BeforeConstraintsAccounted.getHorizontalConstraint(lifelineState);
            if (horizontalConstraint == requiredConstraint) {
                return;
            }
            if (horizontalConstraint == null) {
                elementMinPos = Math.max(elementMinPos, St2BeforeConstraintsAccounted.getCurrentPos(lifelineState));
            } else {
                HashSet<LifeLineElement> badElementsSet = (HashSet<LifeLineElement>)this.myBlockedHorizontal2BadElements.get(horizontalConstraint);
                if (badElementsSet == null) {
                    badElementsSet = new HashSet<LifeLineElement>(0);
                    this.myBlockedHorizontal2BadElements.put(horizontalConstraint, badElementsSet);
                    try {
                        List<LifeLineElement> elements = horizontalConstraint.getLifeLineElementsList();
                        boolean prioritedCoordinateFound = false;
                        int constraintMinPos = Integer.MIN_VALUE;
                        int constraintCurPos = Integer.MIN_VALUE;
                        ArrayList<LifelineState> resolvedOtherLifelines = new ArrayList<LifelineState>(elements.size());
                        for (LifeLineElement element : elements) {
                            LifelineState otherLifelineState = this.getLifelineState(element.getLifeLine());
                            if (lifelineState.getCurrentElement() == element) {
                                horizontalConstraint.elementIsResolved(element);
                            } else {
                                if (badElementsSet.contains(element)) {
                                    horizontalConstraint.elementIsViolated(element);
                                    continue;
                                }
                                try {
                                    this.processLifeline(otherLifelineState, horizontalConstraint);
                                }
                                catch (LifelineBlockedException e) {
                                    horizontalConstraint.elementIsViolated(element);
                                    otherLifelineState.addBrokenHorizontalConstraints(horizontalConstraint);
                                    continue;
                                }
                                horizontalConstraint.elementIsResolved(element);
                                resolvedOtherLifelines.add(otherLifelineState);
                            }
                            int minPos = St2BeforeConstraintsAccounted.getBeforeConstraintPos(otherLifelineState);
                            int curPos = St2BeforeConstraintsAccounted.getCurrentPos(otherLifelineState);
                            if (constraintMinPos < minPos) {
                                constraintMinPos = minPos;
                            }
                            if (prioritedCoordinateFound) continue;
                            constraintCurPos = curPos;
                            prioritedCoordinateFound = St2BeforeConstraintsAccounted.isPrioritedPosition(otherLifelineState);
                        }
                        int constraintPos = Math.max(constraintCurPos, constraintMinPos);
                        int i = 0;
                        while (i < resolvedOtherLifelines.size()) {
                            LifelineState state = (LifelineState)resolvedOtherLifelines.get(i);
                            St2BeforeConstraintsAccounted.setPos(state, constraintPos);
                            this.myCycleWatcher.releaseLifeline(state);
                            ++i;
                        }
                        elementMinPos = constraintPos;
                    }
                    finally {
                        this.myBlockedHorizontal2BadElements.remove(horizontalConstraint);
                    }
                }
                badElementsSet.add(lifelineState.getCurrentElement());
            }
            St2BeforeConstraintsAccounted.setPos(lifelineState, elementMinPos);
            if (lifelineState.getEncounteredOrderingConstraints2Pos().containsKey(requiredConstraint)) {
                return;
            }
            St3PositionIsSet.nextStep(lifelineState);
        }
        if (requiredConstraint != NOT_REQUIRED_CONSTRAINT) {
            throw new RuntimeException("Failed to find required constraint " + requiredConstraint + " on lifeline " + lifelineState);
        }
    }

    private LifelineState getLifelineState(LifeLine lifeLine) {
        LifelineState result = (LifelineState)this.myLifeline2State.get(lifeLine);
        if (result == null) {
            throw new RuntimeException("Failed to find state for lifeline");
        }
        return result;
    }

    private static class CycleWatcher {
        private final HashSet myLifelineStates = new HashSet();

        private CycleWatcher() {
        }

        boolean requireLifeline(LifelineState lifelineState) {
            return this.myLifelineStates.add(lifelineState);
        }

        void releaseLifeline(LifelineState lifelineState) {
            this.myLifelineStates.remove(lifelineState);
        }
    }

    private static class LifelineBlockedException
    extends Exception {
        private LifelineBlockedException() {
        }
    }
}

