/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.genapi.IVisualIDRegistry;
import org.eclipse.uml2.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.sequence.part.UMLNodeDescriptor;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.uml2.diagram.sequence/debug/visualID";
    public static final IVisualIDRegistry TYPED_ADAPTER = new IVisualIDRegistry(){

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public int getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }

        public boolean isShortcutDescendant(View view) {
            return UMLVisualIDRegistry.isShortcutDescendant(view);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("UMLSequence".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Package)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLSequence".equals(containerModelID)) {
            return -1;
        }
        if ("UMLSequence".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 2001: {
                if (UMLPackage.eINSTANCE.getGate().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getInteractionUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCombinedFragment().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (!UMLPackage.eINSTANCE.getLifeline().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 3008: {
                if (!UMLPackage.eINSTANCE.getInteractionOperand().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 3001: {
                if (UMLPackage.eINSTANCE.getActionExecutionSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getStateInvariant().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (UMLPackage.eINSTANCE.getBehaviorExecutionSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getInteractionUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (!UMLPackage.eINSTANCE.getCombinedFragment().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 3004: {
                if (!UMLPackage.eINSTANCE.getBehaviorExecutionSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
            case 3010: {
                if (!UMLPackage.eINSTANCE.getInteractionOperand().isSuperTypeOf(domainElement.eClass())) break;
                return 3011;
            }
            case 3011: {
                if (UMLPackage.eINSTANCE.getActionExecutionSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getStateInvariant().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (!UMLPackage.eINSTANCE.getBehaviorExecutionSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 3014: {
                if (!UMLPackage.eINSTANCE.getBehaviorExecutionSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
            case 1000: {
                if (!UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) break;
                return 2001;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLSequence".equals(containerModelID)) {
            return false;
        }
        if ("UMLSequence".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 2001: {
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 3007: {
                if (5007 != nodeVisualID) break;
                return true;
            }
            case 3008: {
                if (5010 == nodeVisualID) {
                    return true;
                }
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 3001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3010 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (5003 != nodeVisualID) break;
                return true;
            }
            case 3003: {
                if (5004 != nodeVisualID) break;
                return true;
            }
            case 3004: {
                if (3004 != nodeVisualID) break;
                return true;
            }
            case 3010: {
                if (3011 != nodeVisualID) break;
                return true;
            }
            case 3011: {
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 3012: {
                if (5011 != nodeVisualID) break;
                return true;
            }
            case 3013: {
                if (5012 != nodeVisualID) break;
                return true;
            }
            case 3014: {
                if (3004 != nodeVisualID) break;
                return true;
            }
            case 1000: {
                if (2001 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (6001 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    protected static boolean hasViewChild(View containerView, EObject domainElement, int visualId) {
        if (containerView == null) {
            return false;
        }
        if (domainElement == null) {
            return false;
        }
        for (Object next : containerView.getChildren()) {
            View nextView = (View)next;
            if (!domainElement.equals(nextView.getElement()) || !UMLVisualIDRegistry.getType(visualId).equals(nextView.getType())) continue;
            return true;
        }
        return false;
    }

    public static int getChildDescriptorVisualID(UMLNodeDescriptor container, EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        switch (container.getVisualID()) {
            case 2001: {
                if (UMLPackage.eINSTANCE.getGate().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getInteractionUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCombinedFragment().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (!UMLPackage.eINSTANCE.getLifeline().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 3008: {
                if (!UMLPackage.eINSTANCE.getInteractionOperand().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 3001: {
                if (UMLPackage.eINSTANCE.getActionExecutionSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getStateInvariant().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (UMLPackage.eINSTANCE.getBehaviorExecutionSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getInteractionUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (!UMLPackage.eINSTANCE.getCombinedFragment().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 3004: {
                if (!UMLPackage.eINSTANCE.getBehaviorExecutionSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
            case 3010: {
                if (!UMLPackage.eINSTANCE.getInteractionOperand().isSuperTypeOf(domainElement.eClass())) break;
                return 3011;
            }
            case 3011: {
                if (UMLPackage.eINSTANCE.getActionExecutionSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getStateInvariant().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (!UMLPackage.eINSTANCE.getBehaviorExecutionSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 3014: {
                if (!UMLPackage.eINSTANCE.getBehaviorExecutionSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
            case 1000: {
                if (!UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) break;
                return 2001;
            }
        }
        return -1;
    }

    protected static boolean canSubstitute(int visualId, int substituteCandidate) {
        return visualId == substituteCandidate;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate || UMLVisualIDRegistry.canSubstitute(basic, candidate);
    }

    public static boolean isCompartmentVisualID(int visualID) {
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 3002: 
            case 3003: 
            case 3005: 
            case 3006: 
            case 3007: 
            case 3009: 
            case 3012: 
            case 3013: {
                return true;
            }
        }
        return false;
    }

    public static boolean isShortcutDescendant(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram && view != null) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return true;
            }
            view = (View)view.eContainer();
        }
        return false;
    }
}

