/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.model.builder;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.uml2.diagram.sequence.model.builder.SDBuilder;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDAbstractMessage;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDBracket;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDExecution;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDInvocation;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDLifeLine;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDMessage;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;

public class MessageNumbers {
    private final SDBuilder myBuilder;

    public MessageNumbers(SDBuilder builder) {
        this.myBuilder = builder;
    }

    public void updateMessageNumbers() {
        List<SDAbstractMessage> orderedSDMessages = this.orderSDMessages();
        HashSet<SDAbstractMessage> guard = new HashSet<SDAbstractMessage>();
        int rootNumber = 1;
        for (SDAbstractMessage next : orderedSDMessages) {
            SDMessage nextMessage;
            if (!(next instanceof SDMessage) || guard.contains(nextMessage = (SDMessage)next)) continue;
            SDMessage firstInChain = this.findFirstMessageInChain(nextMessage);
            firstInChain.setMessageNumber(String.valueOf(rootNumber++));
            this.setupMessageNumbersForChain(firstInChain, guard);
        }
    }

    private List<SDAbstractMessage> orderSDMessages() {
        HashSet<Message> matchedUMLMessages = new HashSet<Message>();
        LinkedList<SDAbstractMessage> sdMessages = new LinkedList<SDAbstractMessage>();
        for (InteractionFragment next : this.myBuilder.getInteraction().getFragments()) {
            SDAbstractMessage sdMessage;
            MessageEnd nextMessageEnd;
            Message umlMessage;
            if (!(next instanceof MessageEnd) || (umlMessage = (nextMessageEnd = (MessageEnd)next).getMessage()) == null || matchedUMLMessages.contains(umlMessage) || (sdMessage = this.myBuilder.getSDModel().getUMLTracing().findMessage(umlMessage)) == null) continue;
            sdMessages.add(sdMessage);
            matchedUMLMessages.add(umlMessage);
        }
        return sdMessages;
    }

    private SDMessage findFirstMessageInChain(SDMessage message) {
        SDInvocation invocation = message.getSource();
        if (invocation.getBracketContainer() instanceof SDLifeLine) {
            return message;
        }
        SDExecution containerExecution = (SDExecution)invocation.getBracketContainer();
        return this.findFirstMessageInChain(containerExecution.getIncomingMessage());
    }

    private void setupMessageNumbersForChain(SDMessage current, Set<SDAbstractMessage> guard) {
        if (guard.contains(current)) {
            return;
        }
        guard.add(current);
        SDExecution execution = current.getTarget();
        int index = 1;
        for (SDBracket nextBracket : execution.getBrackets()) {
            if (!(nextBracket instanceof SDInvocation)) continue;
            SDInvocation nextInvocation = (SDInvocation)nextBracket;
            SDMessage nextMessage = nextInvocation.getOutgoingMessage();
            nextMessage.setMessageNumber(String.valueOf(current.getMessageNumber()) + "." + index++);
            this.setupMessageNumbersForChain(nextMessage, guard);
        }
    }
}

