/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.model.builder;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.diagram.sequence.model.builder.LifeLineCallStack;
import org.eclipse.uml2.diagram.sequence.model.builder.MessageNumbers;
import org.eclipse.uml2.diagram.sequence.model.builder.SDBuilderInternalProblem;
import org.eclipse.uml2.diagram.sequence.model.builder.SDBuilderTrace;
import org.eclipse.uml2.diagram.sequence.model.builder.SDModelHelper;
import org.eclipse.uml2.diagram.sequence.model.builder.StartAndFinishRegistry;
import org.eclipse.uml2.diagram.sequence.model.builder.UMLModelProblem;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDBehaviorSpec;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDBracketContainer;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDCombinedFragment;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDExecution;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDFactory;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDFrame;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDFrameContainer;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDGate;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDGateMessage;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDGateMessageEnd;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDInteractionOperand;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDInvocation;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDLifeLine;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDMessage;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDModel;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDMountingRegion;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDSimpleNode;
import org.eclipse.uml2.diagram.sequence.model.sequenced.impl.SDModelImpl;
import org.eclipse.uml2.uml.ActionExecutionSpecification;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Continuation;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.StateInvariant;

public class SDBuilder {
    private final Interaction myInteraction;
    private final StartAndFinishRegistry myStartsAndFinishes;
    private final LifeLineCallStack myCallStack;
    private final MessageNumbers myMessageNumbers;
    private SDModel mySDModel;
    private SDFrameContainer myCurrentFrameContainer;

    public SDBuilder(Interaction interaction) {
        this.myInteraction = interaction;
        this.myStartsAndFinishes = new StartAndFinishRegistry(this.myInteraction);
        this.myCallStack = new LifeLineCallStack();
        this.myMessageNumbers = new MessageNumbers(this);
    }

    public Interaction getInteraction() {
        return this.myInteraction;
    }

    public void updateMessageNumbers() {
        this.myMessageNumbers.updateMessageNumbers();
    }

    public LifeLineCallStack getCallStack() {
        return this.myCallStack;
    }

    public SDModel getSDModel() {
        if (this.mySDModel == null) {
            this.reBuildModel();
        }
        return this.mySDModel;
    }

    private SDModel reBuildModel() {
        this.myCallStack.clear();
        this.myStartsAndFinishes.forceRemap();
        this.mySDModel = SDFactory.eINSTANCE.createSDModel();
        this.mySDModel.setUmlInteraction(this.myInteraction);
        this.myCurrentFrameContainer = this.mySDModel;
        ((SDModelImpl)this.mySDModel).setUMLTracing(new SDBuilderTrace());
        this.buildGates(this.mySDModel, this.myInteraction);
        this.buildLifeLines(this.mySDModel, this.myInteraction);
        Iterator fragments = this.myInteraction.getFragments().iterator();
        while (fragments.hasNext()) {
            this.buildBrackets(fragments);
        }
        this.updateMessageNumbers();
        return this.mySDModel;
    }

    private void buildGates(SDModel model, Interaction interaction) {
        for (Gate umlGate : interaction.getFormalGates()) {
            SDGate sdGate = this.getTraceImpl().bindNewGate(umlGate);
            model.getGates().add((Object)sdGate);
        }
    }

    private void buildLifeLines(SDModel model, Interaction interaction) {
        assert (model.getLifelines().isEmpty());
        for (Lifeline umlLifeline : interaction.getLifelines()) {
            SDLifeLine sdLifeLine = this.getTraceImpl().bindNewLifeline(umlLifeline);
            model.getLifelines().add((Object)sdLifeLine);
            this.myCallStack.push(umlLifeline, sdLifeLine);
        }
    }

    private void buildBrackets(Iterator<InteractionFragment> orderedFragments) {
        if (!orderedFragments.hasNext()) {
            return;
        }
        InteractionFragment fragment = orderedFragments.next();
        if (fragment instanceof StateInvariant) {
            this.buildSimpleNode(fragment);
            return;
        }
        if (fragment instanceof ActionExecutionSpecification) {
            this.unsupportedFragment(fragment);
            return;
        }
        if (fragment instanceof CombinedFragment) {
            this.buildCombinedFragment((CombinedFragment)fragment);
            return;
        }
        if (fragment instanceof InteractionOperand) {
            this.unsupportedFragment(fragment);
            return;
        }
        if (fragment instanceof Continuation) {
            this.unsupportedFragment(fragment);
            return;
        }
        if (fragment instanceof Interaction) {
            this.unsupportedFragment(fragment);
            return;
        }
        if (fragment instanceof InteractionUse) {
            this.unsupportedFragment(fragment);
            return;
        }
        if (fragment instanceof ExecutionOccurrenceSpecification) {
            this.unsupportedFragment(fragment);
            return;
        }
        if (fragment instanceof MessageOccurrenceSpecification) {
            MessageOccurrenceSpecification messageEnd = (MessageOccurrenceSpecification)fragment;
            Lifeline lifeline = SDBuilder.ensureSingleCovered((InteractionFragment)messageEnd);
            if (lifeline == null) {
                SDBuilder.warning("MessageOccurrenceSpecification without a lifeline: " + messageEnd);
                return;
            }
            Message message = messageEnd.getMessage();
            if (message == null) {
                this.processPossibleExecutionFinish(orderedFragments, messageEnd, lifeline);
                return;
            }
            if (message.getSendEvent() == messageEnd) {
                this.buildMessageSource(orderedFragments, messageEnd);
                return;
            }
            if (message.getReceiveEvent() == fragment) {
                this.buildMessageTarget(orderedFragments, messageEnd);
                return;
            }
        }
        if (fragment instanceof ExecutionSpecification) {
            this.buildExecutionSpecification((ExecutionSpecification)fragment);
            return;
        }
    }

    private void processPossibleExecutionFinish(Iterator<InteractionFragment> orderedFragments, MessageOccurrenceSpecification messageEnd, Lifeline lifeline) {
        SDExecution sdFinishedExecution;
        SDInvocation sdInvocation;
        ExecutionSpecification umlFinishedExecution = this.myStartsAndFinishes.findFinishedExecution((OccurrenceSpecification)messageEnd);
        if (umlFinishedExecution == null) {
            SDBuilder.warning("Lost message end (no message) is found (will be ignored):" + messageEnd);
            return;
        }
        if (SDBuilder.ensureSingleCovered((InteractionFragment)umlFinishedExecution) != lifeline) {
            throw new UMLModelProblem("Execution is finished at wrong lifeline: " + umlFinishedExecution + ", expected lifeline is: " + lifeline);
        }
        SDBracketContainer sdFinishedContainer = this.myCallStack.peek(lifeline);
        if (!(sdFinishedContainer instanceof SDBehaviorSpec) && ((SDBehaviorSpec)sdFinishedContainer).getUmlExecutionSpec() != umlFinishedExecution) {
            throw new UMLModelProblem("ExecutionSpecification finished: " + umlFinishedExecution + ", while active bracket container was :" + sdFinishedContainer);
        }
        if (sdFinishedContainer instanceof SDInvocation && ((SDInvocation)sdFinishedContainer).getUmlExecutionSpec() == null) {
            throw new SDBuilderInternalProblem("SDInvocation : " + sdFinishedContainer + " does not have uml counterpart. However, we have found finish for it: " + messageEnd + ", actual umlExecution: " + umlFinishedExecution);
        }
        this.myCallStack.pop(lifeline);
        if (sdFinishedContainer instanceof SDExecution && (sdInvocation = (sdFinishedExecution = (SDExecution)sdFinishedContainer).getInvocation()) != null && sdInvocation.getUmlExecutionSpec() == null) {
            SDLifeLine invocationLifeLine = sdInvocation.getCoveredLifeLine();
            if (invocationLifeLine == null) {
                throw new SDBuilderInternalProblem("Can't find lifeline for 'auxiliary' SDInvocation: " + sdInvocation);
            }
            this.myCallStack.pop(invocationLifeLine.getUmlLifeline());
        }
    }

    private void buildExecutionSpecification(ExecutionSpecification umlExecutionSpec) {
        Lifeline umlLifeline = SDBuilder.ensureSingleCovered((InteractionFragment)umlExecutionSpec);
        if (umlLifeline == null) {
            SDBuilder.warning("ExecutionSpecification without lifeline, ignored: " + umlExecutionSpec);
            return;
        }
        SDBracketContainer active = this.myCallStack.peek(umlLifeline);
        if (!(active instanceof SDBehaviorSpec)) {
            throw new UMLModelProblem("Lost ExecutionSpecification found: " + umlExecutionSpec + ", active bracket container :" + active);
        }
        SDBehaviorSpec activeSpec = (SDBehaviorSpec)active;
        if (activeSpec.getUmlExecutionSpec() != umlExecutionSpec) {
            if (!this.isSelfMessageExecution(activeSpec)) {
                throw new UMLModelProblem("Lost ExecutionSpecification found: " + umlExecutionSpec + ", active bracket container :" + active);
            }
            SDExecution execution = (SDExecution)active;
            SDInvocation invocation = execution.getInvocation();
            if (umlExecutionSpec != invocation.getUmlExecutionSpec()) {
                throw new UMLModelProblem("Self message found, but executionSpecification for its invocation is wrong: " + umlExecutionSpec + ", active bracket container :" + active + ", expected invocation execSpec: " + invocation.getUmlExecutionSpec());
            }
        }
    }

    private boolean isSelfMessageExecution(SDBehaviorSpec spec) {
        if (!(spec instanceof SDExecution)) {
            return false;
        }
        SDExecution execution = (SDExecution)spec;
        SDInvocation invocation = execution.getInvocation();
        if (invocation == null) {
            return false;
        }
        Lifeline executionLL = SDBuilder.ensureSingleCovered((InteractionFragment)execution.getUmlExecutionSpec());
        Lifeline invocationLL = SDBuilder.ensureSingleCovered((InteractionFragment)invocation.getUmlExecutionSpec());
        return executionLL != null && executionLL == invocationLL;
    }

    private void buildMessageTarget(Iterator<InteractionFragment> orderedFragments, MessageOccurrenceSpecification messageTarget) {
        Message message = messageTarget.getMessage();
        MessageEnd sendEvent = message.getSendEvent();
        if (sendEvent == null) {
            this.buildFoundMessage(messageTarget);
            return;
        }
        if (sendEvent instanceof Gate) {
            this.buildGateMessage(messageTarget, (Gate)sendEvent, true);
            return;
        }
        MessageOccurrenceSpecification messageSource = (MessageOccurrenceSpecification)sendEvent;
        throw new UMLModelProblem("Message " + message + " is sent from the future: " + messageSource);
    }

    private void buildMessageSource(Iterator<InteractionFragment> orderedFragments, MessageOccurrenceSpecification messageSource) {
        Message message = messageSource.getMessage();
        MessageEnd receiveEvent = message.getReceiveEvent();
        if (receiveEvent == null) {
            this.buildLostMessage(messageSource);
            return;
        }
        if (receiveEvent instanceof Gate) {
            this.buildGateMessage(messageSource, (Gate)receiveEvent, false);
            return;
        }
        MessageOccurrenceSpecification messageTarget = (MessageOccurrenceSpecification)receiveEvent;
        boolean targetFound = false;
        while (orderedFragments.hasNext()) {
            InteractionFragment nextBetweenSendAndReceive = orderedFragments.next();
            if (nextBetweenSendAndReceive == messageTarget) {
                targetFound = true;
                break;
            }
            SDBuilder.warning("Interaction fragment found between message send and receive for message: " + message + ", that is: " + nextBetweenSendAndReceive + ". Will be ignored");
        }
        if (!targetFound) {
            throw new UMLModelProblem("Message " + message + " is sent to the past");
        }
        if (message.getMessageSort() == MessageSort.REPLY_LITERAL) {
            this.buildReplyMessage(orderedFragments, messageSource, messageTarget);
            return;
        }
        this.buildCompleteMessage(orderedFragments, messageSource, messageTarget);
    }

    private void buildCompleteMessage(Iterator<InteractionFragment> orderedFragments, MessageOccurrenceSpecification messageSource, MessageOccurrenceSpecification messageTarget) {
        Message umlMessage = messageSource.getMessage();
        Lifeline umlSendingLifeline = SDBuilder.ensureSingleCovered((InteractionFragment)messageSource);
        Lifeline umlReceivingLifeline = SDBuilder.ensureSingleCovered((InteractionFragment)messageTarget);
        if (umlSendingLifeline == null) {
            throw new UMLModelProblem("Message " + umlMessage + " has start :" + messageSource + " which does not belong to lifeline");
        }
        if (umlReceivingLifeline == null) {
            throw new UMLModelProblem("Message " + umlMessage + " has target :" + messageTarget + " which does not belong to lifeline");
        }
        ExecutionSpecification umlInvocation = this.myStartsAndFinishes.findStartedExecution((OccurrenceSpecification)messageSource);
        ExecutionSpecification umlExecution = this.myStartsAndFinishes.findStartedExecution((OccurrenceSpecification)messageTarget);
        if (umlExecution == null) {
            throw new UMLModelProblem("Message " + umlMessage + " does not have receiving ExecutionSpecification at receiveEvent: " + messageTarget);
        }
        SDMessage sdMessage = this.getTraceImpl().bindNewMessage(umlMessage);
        SDInvocation sdInvocation = this.getTraceImpl().bindNewInvocation(umlInvocation);
        SDExecution sdExecution = this.getTraceImpl().bindNewExecution(umlExecution);
        sdInvocation.setOutgoingMessage(sdMessage);
        sdExecution.setIncomingMessage(sdMessage);
        sdInvocation.setReceiveExecution(sdExecution);
        sdExecution.setUmlStart((OccurrenceSpecification)messageTarget);
        sdExecution.setUmlFinish(umlExecution.getFinish());
        if (umlInvocation != null) {
            sdInvocation.setUmlStart((OccurrenceSpecification)messageSource);
            sdInvocation.setUmlFinish(umlInvocation.getFinish());
        }
        this.mySDModel.getMessages().add((Object)sdMessage);
        SDBracketContainer sdSendingContainer = this.myCallStack.peek(umlSendingLifeline);
        sdSendingContainer.getBrackets().add((Object)sdInvocation);
        this.myCallStack.push(umlSendingLifeline, sdInvocation);
        SDBracketContainer sdReceivingContainer = this.myCallStack.peek(umlReceivingLifeline);
        sdReceivingContainer.getBrackets().add((Object)sdExecution);
        this.myCallStack.push(umlReceivingLifeline, sdExecution);
    }

    private void buildGateMessage(MessageOccurrenceSpecification umlMessageEnd, Gate umlGate, boolean fromNotToGate) {
        Lifeline umlLifeline = SDBuilder.ensureSingleCovered((InteractionFragment)umlMessageEnd);
        if (umlLifeline == null) {
            SDBuilder.warning("MessageOccurrenceSpecification without a lifeline: " + umlMessageEnd);
            return;
        }
        SDBracketContainer sdContainer = this.myCallStack.peek(umlLifeline);
        SDGateMessageEnd sdPureOccurrence = this.getTraceImpl().bindGateMessageEnd((OccurrenceSpecification)umlMessageEnd);
        sdPureOccurrence.setIsStartNotFinish(!fromNotToGate);
        sdContainer.getBrackets().add((Object)sdPureOccurrence);
        SDGateMessage sdMessageToGate = this.getTraceImpl().bindGateMessage(umlMessageEnd.getMessage());
        sdMessageToGate.setFromNotToGate(fromNotToGate);
        sdMessageToGate.setGate(SDModelHelper.findGate(this.mySDModel, umlGate));
        sdMessageToGate.setNormalEnd(sdPureOccurrence);
        this.mySDModel.getMessages().add((Object)sdMessageToGate);
    }

    private void buildLostMessage(MessageOccurrenceSpecification messageSource) {
        this.unsupportedFragment((InteractionFragment)messageSource);
    }

    private void buildReplyMessage(Iterator<InteractionFragment> orderedFragments, MessageOccurrenceSpecification replySource, MessageOccurrenceSpecification replyTarget) {
        throw new SDBuilderInternalProblem("Reply-message is not supported: " + replySource.getMessage());
    }

    private void buildFoundMessage(MessageOccurrenceSpecification messageTarget) {
        this.unsupportedFragment((InteractionFragment)messageTarget);
    }

    private void unsupportedFragment(InteractionFragment fragment) {
        String metaclass = fragment.eClass().getName();
        throw new SDBuilderInternalProblem(String.valueOf(metaclass) + " is not supported: " + fragment);
    }

    private void buildSimpleNode(InteractionFragment umlFragment) {
        Lifeline umlLifeline = SDBuilder.ensureSingleCovered(umlFragment);
        if (umlLifeline == null) {
            return;
        }
        SDBracketContainer sdContainer = this.myCallStack.peek(umlLifeline);
        SDSimpleNode sdInvariant = this.getTraceImpl().bindNewSimpleNode(umlFragment);
        sdContainer.getBrackets().add((Object)sdInvariant);
    }

    private void buildCombinedFragment(CombinedFragment umlFragment) {
        if (umlFragment.getCovereds().isEmpty()) {
            throw new UMLModelProblem("Combined fragment without a covered lifelines found: " + umlFragment);
        }
        for (Lifeline nextUmlCovered : umlFragment.getCovereds()) {
            SDMountingRegion activeRegion;
            SDBracketContainer bracketContainer = this.myCallStack.peek(nextUmlCovered);
            if (bracketContainer instanceof SDBehaviorSpec) {
                throw new UMLModelProblem("Combined fragment " + umlFragment + " covering lifeline: " + nextUmlCovered + ", which is in the middle of the message-chain, active bracket: " + bracketContainer);
            }
            if (bracketContainer instanceof SDMountingRegion && (activeRegion = (SDMountingRegion)bracketContainer).getFrame() != this.myCurrentFrameContainer) {
                throw new UMLModelProblem("Combined fragment " + umlFragment + " covering lifeline: " + nextUmlCovered + ", can not match mounting regions for parent frame: " + this.myCurrentFrameContainer + ", actual frame found: " + activeRegion.getFrame());
            }
            if (!(bracketContainer instanceof SDLifeLine)) continue;
            if (this.myCurrentFrameContainer != this.mySDModel) {
                throw new UMLModelProblem("Combined fragment " + umlFragment + " covering lifeline: " + nextUmlCovered + ", but its parent frame: " + this.myCurrentFrameContainer + " does not.");
            }
            if (((SDLifeLine)bracketContainer).getUmlLifeline() == nextUmlCovered) continue;
            throw new SDBuilderInternalProblem("Active SDLifeLine from call-stack " + bracketContainer + ", while expecting SD-wrapper for: " + nextUmlCovered);
        }
        SDCombinedFragment sdFragment = this.getTraceImpl().bindNewCombinedFragment(umlFragment);
        this.myCurrentFrameContainer.getFrames().add((Object)sdFragment);
        this.pushMountingRegionsForAllCovereds(sdFragment, (InteractionFragment)umlFragment);
        for (InteractionOperand nextOperand : umlFragment.getOperands()) {
            this.buildInteractionOperand(nextOperand, sdFragment);
        }
        this.popMountingRegionsForAllCovereds(sdFragment, (InteractionFragment)umlFragment);
    }

    private void buildInteractionOperand(InteractionOperand umlOperand, SDCombinedFragment sdEnclosingFragment) {
        assert (umlOperand.eContainer() == sdEnclosingFragment.getUmlCombinedFragment());
        assert (this.myCurrentFrameContainer == sdEnclosingFragment);
        if (umlOperand.getCovereds().size() != sdEnclosingFragment.getCoveredLifeLines().size()) {
            throw new UMLModelProblem("Set of covered lifelines differs for InteractionOperand: " + umlOperand + ", and its enclosing fragment: " + sdEnclosingFragment.getUmlCombinedFragment());
        }
        for (SDLifeLine nextCoveredByCombined : sdEnclosingFragment.getCoveredLifeLines()) {
            if (umlOperand.getCovereds().contains((Object)nextCoveredByCombined.getUmlLifeline())) continue;
            throw new UMLModelProblem("CombinedFragment : " + sdEnclosingFragment.getUmlCombinedFragment() + " covers lifeline: " + nextCoveredByCombined.getUmlLifeline() + " while its operand : " + umlOperand + " does not.");
        }
        for (Lifeline nextUmlCovered : umlOperand.getCovereds()) {
            SDBracketContainer bracketContainer = this.myCallStack.peek(nextUmlCovered);
            if (bracketContainer instanceof SDMountingRegion) continue;
            throw new UMLModelProblem("Interaction operand : " + umlOperand + " found, while the message chain on lifeline: " + nextUmlCovered + " is not completed, active bracket: " + bracketContainer);
        }
        SDInteractionOperand sdOperand = this.getTraceImpl().bindNewInteractionOperand(umlOperand);
        sdEnclosingFragment.getFrames().add((Object)sdOperand);
        this.pushMountingRegionsForAllCovereds(sdOperand, (InteractionFragment)umlOperand);
        Iterator innerFragments = umlOperand.getFragments().iterator();
        while (innerFragments.hasNext()) {
            this.buildBrackets(innerFragments);
        }
        this.popMountingRegionsForAllCovereds(sdOperand, (InteractionFragment)umlOperand);
    }

    private void pushMountingRegionsForAllCovereds(SDFrame sdFrame, InteractionFragment umlFrame) {
        for (Lifeline nextUmlCovered : umlFrame.getCovereds()) {
            SDBracketContainer bracketContainer = this.myCallStack.peek(nextUmlCovered);
            assert (bracketContainer.getCoveredLifeLine().getUmlLifeline() == nextUmlCovered);
            sdFrame.getCoveredLifeLines().add((Object)bracketContainer.getCoveredLifeLine());
            SDMountingRegion nextRegion = this.getTraceImpl().bindNewMountingRegion(sdFrame);
            bracketContainer.getBrackets().add((Object)nextRegion);
            this.myCallStack.push(nextUmlCovered, nextRegion);
        }
        this.myCurrentFrameContainer = sdFrame;
    }

    private void popMountingRegionsForAllCovereds(SDFrame sdFrame, InteractionFragment umlFrame) {
        for (Lifeline nextUmlCovered : umlFrame.getCovereds()) {
            SDBracketContainer bracketContainer = this.myCallStack.peek(nextUmlCovered);
            if (!(bracketContainer instanceof SDMountingRegion)) {
                throw new SDBuilderInternalProblem("After processing contents for " + umlFrame + ", can't match the active bracket container for lifeline: " + nextUmlCovered + ", actual : " + bracketContainer + ", while expecting mounting region ");
            }
            SDMountingRegion nextRegion = (SDMountingRegion)bracketContainer;
            if (nextRegion.getFrame() != sdFrame) {
                throw new SDBuilderInternalProblem("After processing contents for " + umlFrame + ", can't match frame for mounting region: " + nextRegion + ", actual frame: " + nextRegion.getFrame() + ", while expecting: " + sdFrame);
            }
            this.myCallStack.pop(nextUmlCovered);
        }
        if (this.myCurrentFrameContainer != sdFrame) {
            throw new SDBuilderInternalProblem("Current frame container: " + this.myCurrentFrameContainer + ", while expecting: " + sdFrame);
        }
        this.myCurrentFrameContainer = sdFrame.getFrameContainer();
    }

    private static Lifeline ensureSingleCovered(InteractionFragment fragment) {
        EList covered = fragment.getCovereds();
        if (covered.size() > 1) {
            throw new UMLModelProblem("Expected single covered lifeline for: " + fragment + ", actually: " + fragment.getCovereds());
        }
        return covered.isEmpty() ? null : (Lifeline)covered.get(0);
    }

    private static void warning(String message) {
    }

    private SDBuilderTrace getTraceImpl() {
        return (SDBuilderTrace)this.getSDModel().getUMLTracing();
    }
}

