/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.model.builder;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class StartAndFinishRegistry {
    private HashMap<OccurrenceSpecification, ExecutionSpecification> myStarts;
    private HashMap<OccurrenceSpecification, ExecutionSpecification> myFinishes;
    private final Interaction myInteraction;

    public StartAndFinishRegistry(Interaction interaction) {
        this.myInteraction = interaction;
    }

    public void forceRemap() {
        this.myStarts = null;
        this.myFinishes = null;
    }

    public ExecutionSpecification findStartedExecution(OccurrenceSpecification occurrence) {
        if (this.myStarts == null || this.myFinishes == null) {
            this.doRemap();
        }
        return this.myStarts.get(occurrence);
    }

    public ExecutionSpecification findFinishedExecution(OccurrenceSpecification occurrence) {
        if (this.myStarts == null || this.myFinishes == null) {
            this.doRemap();
        }
        return this.myFinishes.get(occurrence);
    }

    public ExecutionSpecification findExecution(OccurrenceSpecification occurrence) {
        ExecutionSpecification startedAt;
        if (this.myStarts == null || this.myFinishes == null) {
            this.doRemap();
        }
        if ((startedAt = this.myStarts.get(occurrence)) != null) {
            return startedAt;
        }
        return startedAt != null ? startedAt : this.myFinishes.get(occurrence);
    }

    private void doRemap() {
        this.myStarts = new HashMap();
        this.myFinishes = new HashMap();
        this.doRemap(this.myInteraction.getFragments().iterator());
    }

    private void doRemap(Iterator<InteractionFragment> fragments) {
        while (fragments.hasNext()) {
            InteractionFragment next = fragments.next();
            if (next instanceof ExecutionSpecification) {
                ExecutionSpecification nextExecution = (ExecutionSpecification)next;
                this.checkDistinctEnds(nextExecution);
                OccurrenceSpecification start = nextExecution.getStart();
                OccurrenceSpecification finish = nextExecution.getFinish();
                this.checkTwoOwnersSameKind(start, nextExecution, this.myStarts.get(start), true);
                this.checkTwoOwnersSameKind(finish, nextExecution, this.myFinishes.get(finish), false);
                this.checkTwoOwnersDifferentKinds(start, nextExecution, this.myFinishes.get(start));
                this.checkTwoOwnersDifferentKinds(finish, this.myStarts.get(finish), nextExecution);
                this.myStarts.put(start, nextExecution);
                this.myFinishes.put(finish, nextExecution);
            }
            if (!(next instanceof CombinedFragment)) continue;
            CombinedFragment nextCombined = (CombinedFragment)next;
            for (InteractionOperand nextOperand : nextCombined.getOperands()) {
                this.doRemap(nextOperand.getFragments().iterator());
            }
        }
    }

    private void checkDistinctEnds(ExecutionSpecification execution) {
        if (execution.getStart() == null) {
            throw new IllegalStateException("Execution without a start: " + execution);
        }
        if (execution.getFinish() == null) {
            throw new IllegalStateException("Execution without a finish: " + execution);
        }
        if (execution.getStart() == execution.getFinish()) {
            throw new IllegalStateException("The same start and finish found for execution : " + execution);
        }
    }

    private void checkTwoOwnersSameKind(OccurrenceSpecification problem, ExecutionSpecification firstOwner, ExecutionSpecification secondOwner, boolean bothStartsNotFinishes) {
        if (secondOwner != null && secondOwner != firstOwner) {
            throw new IllegalStateException("OccurrenceSpecification: " + problem + " is " + (bothStartsNotFinishes ? "start" : "finish") + " for more than one Executions: " + firstOwner + ", and: " + secondOwner);
        }
    }

    private void checkTwoOwnersDifferentKinds(OccurrenceSpecification problem, ExecutionSpecification knownStart, ExecutionSpecification knownFinish) {
        if (knownStart != null && knownFinish != null) {
            throw new IllegalStateException("OccurrenceSpecification: " + problem + " is start for : " + knownStart + ", but finish for: " + knownFinish);
        }
    }
}

