/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.statemachine.actions;

import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.statemachine.actions.CustomMessages;
import org.eclipse.uml2.diagram.statemachine.actions.NewActionHandler;
import org.eclipse.uml2.diagram.statemachine.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.TransitionKind;
import org.eclipse.uml2.uml.Vertex;

public class NewInternalTransitionActionHandler
extends NewActionHandler {
    @Override
    protected ICommand getCreateElementCommand(ShapeNodeEditPart editPart) {
        CreateElementRequest createRequest = new CreateElementRequest(this.getTransitionContainer(editPart), (IElementType)UMLElementTypes.Transition_3022);
        return new CreateInternalTransitionCommand(createRequest);
    }

    private EObject getTransitionContainer(ShapeNodeEditPart editPart) throws IllegalArgumentException {
        EObject element = ((View)editPart.getModel()).getElement();
        if (!(element instanceof State)) {
            throw new IllegalArgumentException();
        }
        EList regions = ((State)element).getRegions();
        if (regions.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return (EObject)regions.get(0);
    }

    private static class CreateInternalTransitionCommand
    extends CreateElementCommand {
        public CreateInternalTransitionCommand(CreateElementRequest createRequest) {
            super(createRequest);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CommandResult result = super.doExecuteWithResult(monitor, info);
            Region region = (Region)((CreateElementRequest)this.getRequest()).getContainer();
            Transition transition = (Transition)result.getReturnValue();
            transition.setName(this.getTransitionName(region));
            transition.setKind(TransitionKind.INTERNAL_LITERAL);
            State state = region.getState();
            transition.setSource((Vertex)state);
            transition.setTarget((Vertex)state);
            return result;
        }

        private String getTransitionName(Region region) {
            if (!this.hasTransition(region, CustomMessages.NewInternalTransitionActionHandler_name_prefix)) {
                return CustomMessages.NewInternalTransitionActionHandler_name_prefix;
            }
            int i = 1;
            while (i <= 9) {
                String name = String.valueOf(CustomMessages.NewInternalTransitionActionHandler_name_prefix) + i;
                if (!this.hasTransition(region, name)) {
                    return name;
                }
                ++i;
            }
            return CustomMessages.NewInternalTransitionActionHandler_name_prefix;
        }

        private boolean hasTransition(Region region, String name) {
            EList transitions = region.getTransitions();
            Iterator transitionsIterator = transitions.iterator();
            while (transitionsIterator.hasNext()) {
                if (!name.equals(((Transition)transitionsIterator.next()).getName())) continue;
                return true;
            }
            return false;
        }
    }
}

