/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.statemachine.part;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.diagram.statemachine.part.CustomMessages;
import org.eclipse.uml2.diagram.statemachine.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.StateMachine;

public class SelectConnectionPointsDialog
extends Dialog {
    private StateMachine myInput;
    private PseudostateKind myKind;
    private List<Pseudostate> mySelectionConnectionPoints;

    public SelectConnectionPointsDialog(Shell parentShell, StateMachine input, PseudostateKind kind) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.myInput = input;
        this.myKind = kind;
    }

    public List<Pseudostate> getSelectedConnectionPoints() {
        return this.mySelectionConnectionPoints;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(CustomMessages.SelectConnectionPointsDialog_Title);
        this.createSelector(parent);
        return parent;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.setOkButtonEnabled(false);
        return buttonBar;
    }

    private void setOkButtonEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    private void createSelector(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 2562);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 300;
        layoutData.widthHint = 300;
        viewer.getTree().setLayoutData((Object)layoutData);
        ConnectionPointsListContentProvider contentProvider = new ConnectionPointsListContentProvider(this.myInput);
        viewer.setContentProvider((IContentProvider)contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new ConnectionPointsListLabelProvider());
        viewer.setInput((Object)this.myInput);
        viewer.addFilter((ViewerFilter)new ConnectionPointsFilter());
        viewer.addSelectionChangedListener((ISelectionChangedListener)new OkButtonEnabler());
    }

    private class ConnectionPointsFilter
    extends ViewerFilter {
        private ConnectionPointsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            Pseudostate pseudostate;
            return !(element instanceof Pseudostate) || (pseudostate = (Pseudostate)element).getKind() == SelectConnectionPointsDialog.this.myKind;
        }
    }

    private static class ConnectionPointsListContentProvider
    implements ITreeContentProvider {
        private StateMachine myContent;

        public ConnectionPointsListContentProvider(StateMachine content) {
            this.myContent = content;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof StateMachine) {
                EList connectionPoints = this.myContent.getConnectionPoints();
                return connectionPoints.toArray((Object[])new Pseudostate[connectionPoints.size()]);
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof Pseudostate) {
                return this.myContent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof StateMachine;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ConnectionPointsListLabelProvider
    implements ILabelProvider {
        private AdapterFactoryLabelProvider myAdapterFactoryLabelProvider = new AdapterFactoryLabelProvider(UMLDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());

        private ConnectionPointsListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Pseudostate) {
                Pseudostate pseudoState = (Pseudostate)element;
                StringBuffer text = new StringBuffer(10);
                if (pseudoState.getKind() == PseudostateKind.ENTRY_POINT_LITERAL) {
                    text.append(CustomMessages.SelectConnectionPointsDialog_LabelProvider_EntryPointPrefix);
                } else if (pseudoState.getKind() == PseudostateKind.EXIT_POINT_LITERAL) {
                    text.append(CustomMessages.SelectConnectionPointsDialog_LabelProvider_ExitPointPrefix);
                }
                text.append(' ');
                text.append(pseudoState.getName());
                return text.toString();
            }
            return this.myAdapterFactoryLabelProvider.getText(element);
        }

        public Image getImage(Object element) {
            return this.myAdapterFactoryLabelProvider.getImage(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.myAdapterFactoryLabelProvider.addListener(listener);
        }

        public void dispose() {
            this.myAdapterFactoryLabelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.myAdapterFactoryLabelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.myAdapterFactoryLabelProvider.removeListener(listener);
        }
    }

    private class OkButtonEnabler
    implements ISelectionChangedListener {
        private OkButtonEnabler() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!(event.getSelection() instanceof IStructuredSelection)) {
                SelectConnectionPointsDialog.this.setOkButtonEnabled(false);
                return;
            }
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            SelectConnectionPointsDialog.this.mySelectionConnectionPoints = selection.toList();
            if (selection.isEmpty()) {
                SelectConnectionPointsDialog.this.setOkButtonEnabled(false);
                return;
            }
            for (Object selectedElement : selection) {
                if (selectedElement instanceof Pseudostate) continue;
                SelectConnectionPointsDialog.this.setOkButtonEnabled(false);
                return;
            }
            SelectConnectionPointsDialog.this.setOkButtonEnabled(true);
        }
    }
}

